/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.wire.FlowControlBatcher;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth8;
import java.util.Collection;
import java.util.Optional;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FlowControlBatcherTest {
    private final FlowControlBatcher batcher = new FlowControlBatcher();

    @Test
    public void onClientFlowRequestIncrementsTokens() throws CheckedApiException {
        FlowControlRequest clientFlowRequest = FlowControlRequest.newBuilder().setAllowedBytes(500L).setAllowedMessages(10L).build();
        this.batcher.onClientFlowRequest(clientFlowRequest);
        Truth.assertThat(this.batcher.releasePendingRequest().get()).isEqualTo((Object)clientFlowRequest);
        Truth8.assertThat((Optional)this.batcher.releasePendingRequest()).isEmpty();
        Truth.assertThat(this.batcher.requestForRestart().get()).isEqualTo((Object)clientFlowRequest);
        Truth.assertThat(this.batcher.requestForRestart().get()).isEqualTo((Object)clientFlowRequest);
    }

    @Test
    public void onMessagesDecrementsClientTokens() throws CheckedApiException {
        FlowControlRequest clientFlowRequest = FlowControlRequest.newBuilder().setAllowedBytes(500L).setAllowedMessages(10L).build();
        this.batcher.onClientFlowRequest(clientFlowRequest);
        ImmutableList messages = ImmutableList.of((Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)0L), (long)100L), (Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)1L), (long)150L));
        this.batcher.onMessages((Collection)messages);
        Truth.assertThat(this.batcher.releasePendingRequest().get()).isEqualTo((Object)clientFlowRequest);
        FlowControlRequest expectedRequestForRestart = FlowControlRequest.newBuilder().setAllowedBytes(250L).setAllowedMessages(8L).build();
        Truth.assertThat(this.batcher.requestForRestart().get()).isEqualTo((Object)expectedRequestForRestart);
    }

    @Test
    public void shouldExpediteBatchRequestChecksByteRatio() throws CheckedApiException {
        FlowControlRequest request = FlowControlRequest.newBuilder().setAllowedBytes(100L).setAllowedMessages(100L).build();
        this.batcher.onClientFlowRequest(request);
        Truth8.assertThat((Optional)this.batcher.releasePendingRequest()).hasValue((Object)request);
        this.batcher.onClientFlowRequest(FlowControlRequest.newBuilder().setAllowedBytes(10L).build());
        Truth.assertThat((Boolean)this.batcher.shouldExpediteBatchRequest()).isFalse();
        this.batcher.onClientFlowRequest(FlowControlRequest.newBuilder().setAllowedBytes(90L).build());
        Truth.assertThat((Boolean)this.batcher.shouldExpediteBatchRequest()).isTrue();
    }

    @Test
    public void shouldExpediteBatchRequestChecksMessageRatio() throws CheckedApiException {
        FlowControlRequest request = FlowControlRequest.newBuilder().setAllowedBytes(100L).setAllowedMessages(100L).build();
        this.batcher.onClientFlowRequest(request);
        Truth8.assertThat((Optional)this.batcher.releasePendingRequest()).hasValue((Object)request);
        this.batcher.onClientFlowRequest(FlowControlRequest.newBuilder().setAllowedMessages(80L).build());
        Truth.assertThat((Boolean)this.batcher.shouldExpediteBatchRequest()).isFalse();
        this.batcher.onClientFlowRequest(FlowControlRequest.newBuilder().setAllowedMessages(20L).build());
        Truth.assertThat((Boolean)this.batcher.shouldExpediteBatchRequest()).isTrue();
    }

    @Test
    public void shouldExpediteBatchRequestHandlesDivByZero() {
        Truth.assertThat((Boolean)this.batcher.shouldExpediteBatchRequest()).isFalse();
    }
}

