/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.AlarmFactory;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatcher;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatcherImpl;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class PartitionCountWatcherImplTest {
    private static final CloudRegion REGION = CloudRegion.of((String)"us-east1");
    @Mock
    AdminClient mockClient;
    @Mock
    AlarmFactory alarmFactory;
    @Mock
    Consumer<Long> mockConsumer;
    PartitionCountWatcher watcher;
    final SettableApiFuture<Void> alarmFuture = SettableApiFuture.create();

    private static TopicPath path() {
        return ((TopicPath.Builder)((TopicPath.Builder)TopicPath.newBuilder().setName(TopicName.of((String)"a")).setProject(ProjectNumber.of((long)4L))).setLocation(CloudZone.of((CloudRegion)REGION, (char)'a'))).build();
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PartitionCountWatcherImpl.Factory watcherFactory = new PartitionCountWatcherImpl.Factory(PartitionCountWatcherImplTest.path(), this.mockClient, this.alarmFactory);
        this.watcher = watcherFactory.newWatcher(this.mockConsumer);
    }

    @Test
    public void testFirstCallFails() {
        Mockito.when((Object)this.mockClient.getTopicPartitionCount(PartitionCountWatcherImplTest.path())).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new CheckedApiException((StatusCode.Code)StatusCode.Code.FAILED_PRECONDITION).underlying));
        this.watcher.startAsync();
        Assert.assertThrows(IllegalStateException.class, () -> ((PartitionCountWatcher)this.watcher).awaitTerminated());
        ApiExceptionMatcher.assertThrowableMatches(this.watcher.failureCause(), StatusCode.Code.FAILED_PRECONDITION);
        ((AdminClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).getTopicPartitionCount(PartitionCountWatcherImplTest.path());
    }

    @Test
    public void testConsumerExcepts() {
        Mockito.when((Object)this.mockClient.getTopicPartitionCount(PartitionCountWatcherImplTest.path())).thenReturn((Object)ApiFutures.immediateFuture((Object)1L));
        ((Consumer)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("bad batching settings")}).when(this.mockConsumer)).accept(1L);
        this.watcher.startAsync();
        Assert.assertThrows(IllegalStateException.class, () -> ((PartitionCountWatcher)this.watcher).awaitTerminated());
        ApiExceptionMatcher.assertThrowableMatches(this.watcher.failureCause(), StatusCode.Code.INTERNAL);
        ((AdminClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).getTopicPartitionCount(PartitionCountWatcherImplTest.path());
    }

    Runnable startAndLeakAlarm() throws Exception {
        SettableApiFuture toLeak = SettableApiFuture.create();
        Mockito.when((Object)this.alarmFactory.newAlarm((Runnable)Mockito.any())).thenAnswer(args -> {
            toLeak.set(args.getArgument(0));
            return this.alarmFuture;
        });
        this.watcher.startAsync();
        return (Runnable)toLeak.get();
    }

    @Test
    public void testCallsHandlerOnStart() throws Exception {
        Mockito.when((Object)this.mockClient.getTopicPartitionCount(PartitionCountWatcherImplTest.path())).thenReturn((Object)ApiFutures.immediateFuture((Object)1L));
        Runnable unusedAlarm = this.startAndLeakAlarm();
        ((Consumer)Mockito.verify(this.mockConsumer)).accept(1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockConsumer});
        Truth.assertThat((Boolean)this.watcher.isRunning()).isTrue();
    }

    @Test
    public void testHandlerCalledOnUpdates() throws Exception {
        Mockito.when((Object)this.mockClient.getTopicPartitionCount(PartitionCountWatcherImplTest.path())).thenReturn((Object)ApiFutures.immediateFuture((Object)1L)).thenReturn((Object)ApiFutures.immediateFuture((Object)1L)).thenReturn((Object)ApiFutures.immediateFuture((Object)2L));
        Runnable alarm = this.startAndLeakAlarm();
        alarm.run();
        alarm.run();
        ((AdminClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)3))).getTopicPartitionCount(PartitionCountWatcherImplTest.path());
        ((Consumer)Mockito.verify(this.mockConsumer, (VerificationMode)Mockito.times((int)1))).accept(1L);
        ((Consumer)Mockito.verify(this.mockConsumer, (VerificationMode)Mockito.times((int)1))).accept(2L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockConsumer});
    }

    @Test
    public void testFailuresAfterFirstSuccessIgnored() throws Exception {
        Mockito.when((Object)this.mockClient.getTopicPartitionCount(PartitionCountWatcherImplTest.path())).thenReturn((Object)ApiFutures.immediateFuture((Object)1L)).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new CheckedApiException(StatusCode.Code.FAILED_PRECONDITION))).thenReturn((Object)ApiFutures.immediateFuture((Object)2L));
        Runnable alarm = this.startAndLeakAlarm();
        alarm.run();
        alarm.run();
        ((AdminClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)3))).getTopicPartitionCount(PartitionCountWatcherImplTest.path());
        ((Consumer)Mockito.verify(this.mockConsumer, (VerificationMode)Mockito.times((int)1))).accept(1L);
        ((Consumer)Mockito.verify(this.mockConsumer, (VerificationMode)Mockito.times((int)1))).accept(2L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockConsumer});
    }

    @Test
    public void testStopStopsAlarm() throws Exception {
        Mockito.when((Object)this.mockClient.getTopicPartitionCount(PartitionCountWatcherImplTest.path())).thenReturn((Object)ApiFutures.immediateFuture((Object)1L));
        Runnable unusedAlarm = this.startAndLeakAlarm();
        this.watcher.awaitRunning();
        this.watcher.stopAsync().awaitTerminated();
        Truth.assertThat((Boolean)this.alarmFuture.isCancelled()).isTrue();
    }
}

