/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import com.google.cloud.pubsublite.internal.testing.FakeApiService;
import com.google.cloud.pubsublite.internal.testing.RetryingConnectionHelpers;
import com.google.cloud.pubsublite.internal.testing.UnitTestExamples;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatcher;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisher;
import com.google.cloud.pubsublite.internal.wire.PartitionPublisherFactory;
import com.google.protobuf.ByteString;
import java.time.Duration;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

@RunWith(value=JUnit4.class)
public class PartitionCountWatchingPublisherTest {
    private static final Duration PERIOD = Duration.ofMinutes(1L);
    private static final CloudRegion REGION = (CloudRegion)UnitTestExamples.example(CloudRegion.class);
    @Mock
    PartitionPublisherFactory mockPublisherFactory;
    @Spy
    private FakePublisher publisher0;
    @Spy
    private FakePublisher publisher1;
    @Spy
    private FakePublisher publisher2;
    @Mock
    RoutingPolicy.Factory mockRoutingPolicyFactory;
    @Mock
    RoutingPolicy mockRoutingPolicy;
    Consumer<Long> leakedConsumer;
    @Spy
    FakeConfigWatcher fakeConfigWatcher;
    Publisher<MessageMetadata> publisher;

    private static TopicPath path() {
        return (TopicPath)UnitTestExamples.example(TopicPath.class);
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ((FakePublisher)((Object)Mockito.doReturn((Object)ApiFutures.immediateFuture((Object)MessageMetadata.of((Partition)Partition.of((long)0L), (Offset)Offset.of((long)0L)))).when((Object)this.publisher0))).publish((Message)Mockito.any());
        ((FakePublisher)((Object)Mockito.doReturn((Object)ApiFutures.immediateFuture((Object)MessageMetadata.of((Partition)Partition.of((long)1L), (Offset)Offset.of((long)0L)))).when((Object)this.publisher1))).publish((Message)Mockito.any());
        ((FakePublisher)((Object)Mockito.doReturn((Object)ApiFutures.immediateFuture((Object)MessageMetadata.of((Partition)Partition.of((long)2L), (Offset)Offset.of((long)0L)))).when((Object)this.publisher2))).publish((Message)Mockito.any());
        Mockito.when((Object)this.mockPublisherFactory.newPublisher(Partition.of((long)0L))).thenReturn((Object)this.publisher0);
        Mockito.when((Object)this.mockPublisherFactory.newPublisher(Partition.of((long)1L))).thenReturn((Object)this.publisher1);
        Mockito.when((Object)this.mockPublisherFactory.newPublisher(Partition.of((long)2L))).thenReturn((Object)this.publisher2);
        Mockito.when((Object)this.mockRoutingPolicyFactory.newPolicy(Mockito.anyLong())).thenReturn((Object)this.mockRoutingPolicy);
        ((FakeConfigWatcher)((Object)Mockito.doAnswer(invocation -> {
            this.leakedConsumer.accept(2L);
            invocation.callRealMethod();
            return null;
        }).when((Object)this.fakeConfigWatcher))).startAsync();
        this.publisher = new PartitionCountWatchingPublisher(this.mockPublisherFactory, this.mockRoutingPolicyFactory, c -> {
            this.leakedConsumer = c;
            return this.fakeConfigWatcher;
        });
        this.publisher.startAsync();
        this.publisher.awaitRunning();
        ((RoutingPolicy.Factory)Mockito.verify((Object)this.mockRoutingPolicyFactory)).newPolicy(2L);
    }

    @Test
    public void testPublishWithKey() throws Exception {
        Message message0 = Message.builder().setKey(ByteString.copyFromUtf8((String)"0")).build();
        Message message1 = Message.builder().setKey(ByteString.copyFromUtf8((String)"1")).build();
        Mockito.when((Object)this.mockRoutingPolicy.route(message0.key())).thenReturn((Object)Partition.of((long)0L));
        Mockito.when((Object)this.mockRoutingPolicy.route(message1.key())).thenReturn((Object)Partition.of((long)1L));
        ApiFuture unusedFuture0 = this.publisher.publish(message0);
        ApiFuture unusedFuture1 = this.publisher.publish(message1);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher0)))).publish(message0);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher1)))).publish(message1);
    }

    @Test
    public void testPublishWithoutKey() throws Exception {
        Message messageA = Message.builder().setData(ByteString.copyFromUtf8((String)"a")).build();
        Message messageB = Message.builder().setData(ByteString.copyFromUtf8((String)"b")).build();
        Mockito.when((Object)this.mockRoutingPolicy.routeWithoutKey()).thenReturn((Object)Partition.of((long)0L)).thenReturn((Object)Partition.of((long)1L));
        ApiFuture unusedFutureA = this.publisher.publish(messageA);
        ApiFuture unusedFutureB = this.publisher.publish(messageB);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher0)))).publish(messageA);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher1)))).publish(messageB);
    }

    @Test
    public void testPublishWithBadRouting() throws Exception {
        Message message = Message.builder().build();
        Mockito.when((Object)this.mockRoutingPolicy.routeWithoutKey()).thenReturn((Object)Partition.of((long)4L));
        ApiFuture unusedFuture = this.publisher.publish(message);
        ApiExceptionMatcher.assertThrowableMatches(this.publisher.failureCause(), StatusCode.Code.FAILED_PRECONDITION);
        Assert.assertThrows(IllegalStateException.class, () -> this.publisher.flush());
        Assert.assertThrows(IllegalStateException.class, () -> this.publisher.publish(Message.builder().build()));
    }

    @Test
    public void testChildPublisherFailure() throws Exception {
        Future<Void> publisherTerminated = RetryingConnectionHelpers.whenTerminated(this.publisher);
        this.publisher0.fail((Throwable)new CheckedApiException(StatusCode.Code.FAILED_PRECONDITION));
        publisherTerminated.get();
        ApiExceptionMatcher.assertThrowableMatches(this.publisher.failureCause(), StatusCode.Code.FAILED_PRECONDITION);
        Assert.assertThrows(IllegalStateException.class, () -> this.publisher.flush());
        Assert.assertThrows(IllegalStateException.class, () -> this.publisher.publish(Message.builder().build()));
    }

    @Test
    public void testFlush() throws Exception {
        this.publisher.flush();
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher0)))).flush();
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher1)))).flush();
    }

    @Test
    public void testCancelOutstandingPublishes() throws Exception {
        this.publisher.cancelOutstandingPublishes();
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher0)))).cancelOutstandingPublishes();
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher1)))).cancelOutstandingPublishes();
    }

    @Test
    public void testIncreaseSucceeds() throws Exception {
        this.leakedConsumer.accept(3L);
        ((RoutingPolicy.Factory)Mockito.verify((Object)this.mockRoutingPolicyFactory)).newPolicy(3L);
        Message message0 = Message.builder().setKey(ByteString.copyFromUtf8((String)"0")).build();
        Message message1 = Message.builder().setKey(ByteString.copyFromUtf8((String)"1")).build();
        Message message2 = Message.builder().setKey(ByteString.copyFromUtf8((String)"2")).build();
        Mockito.when((Object)this.mockRoutingPolicy.route(message0.key())).thenReturn((Object)Partition.of((long)0L));
        Mockito.when((Object)this.mockRoutingPolicy.route(message1.key())).thenReturn((Object)Partition.of((long)1L));
        Mockito.when((Object)this.mockRoutingPolicy.route(message2.key())).thenReturn((Object)Partition.of((long)2L));
        ApiFuture unusedFuture0 = this.publisher.publish(message0);
        ApiFuture unusedFuture1 = this.publisher.publish(message1);
        ApiFuture unusedFuture2 = this.publisher.publish(message2);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher0)))).publish(message0);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher1)))).publish(message1);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher2)))).publish(message2);
    }

    @Test
    public void testDecreaseIgnored() throws Exception {
        this.leakedConsumer.accept(1L);
        Message message0 = Message.builder().setKey(ByteString.copyFromUtf8((String)"0")).build();
        Message message1 = Message.builder().setKey(ByteString.copyFromUtf8((String)"1")).build();
        Mockito.when((Object)this.mockRoutingPolicy.route(message0.key())).thenReturn((Object)Partition.of((long)0L));
        Mockito.when((Object)this.mockRoutingPolicy.route(message1.key())).thenReturn((Object)Partition.of((long)1L));
        ApiFuture unusedFuture0 = this.publisher.publish(message0);
        ApiFuture unusedFuture1 = this.publisher.publish(message1);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher0)))).publish(message0);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher1)))).publish(message1);
    }

    @Test
    public void testNoopConfigUpdate() throws Exception {
        this.leakedConsumer.accept(2L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRoutingPolicyFactory});
        Message message0 = Message.builder().setKey(ByteString.copyFromUtf8((String)"0")).build();
        Message message1 = Message.builder().setKey(ByteString.copyFromUtf8((String)"1")).build();
        Mockito.when((Object)this.mockRoutingPolicy.route(message0.key())).thenReturn((Object)Partition.of((long)0L));
        Mockito.when((Object)this.mockRoutingPolicy.route(message1.key())).thenReturn((Object)Partition.of((long)1L));
        ApiFuture unusedFuture0 = this.publisher.publish(message0);
        ApiFuture unusedFuture1 = this.publisher.publish(message1);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher0)))).publish(message0);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher1)))).publish(message1);
    }

    @Test
    public void testStopWorksProperly() {
        this.publisher.stopAsync();
        this.publisher.awaitTerminated();
        this.leakedConsumer.accept(3L);
        Assert.assertThrows(IllegalStateException.class, () -> this.publisher.flush());
        Assert.assertThrows(IllegalStateException.class, () -> this.publisher.publish(Message.builder().build()));
    }

    @Test
    public void testStopAfterIncrease() throws Exception {
        this.leakedConsumer.accept(3L);
        ((RoutingPolicy.Factory)Mockito.verify((Object)this.mockRoutingPolicyFactory)).newPolicy(3L);
        this.publisher.stopAsync();
        this.publisher.awaitTerminated();
        this.leakedConsumer.accept(4L);
        Assert.assertThrows(IllegalStateException.class, () -> this.publisher.flush());
        Assert.assertThrows(IllegalStateException.class, () -> this.publisher.publish(Message.builder().build()));
    }

    static abstract class FakeConfigWatcher
    extends FakeApiService
    implements PartitionCountWatcher {
        FakeConfigWatcher() {
        }
    }

    static abstract class FakePublisher
    extends FakeApiService
    implements Publisher<MessageMetadata> {
        FakePublisher() {
        }
    }
}

