/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.Versions;
import com.google.protobuf.Struct;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PubsubContextTest {
    @Test
    public void withFramework_hasFramework() {
        Struct contextStruct = PubsubContext.of((PubsubContext.Framework)PubsubContext.Framework.of((String)"ABC_FRAMEWORK")).getStruct();
        Truth.assertThat((String)contextStruct.getFieldsOrThrow("language").getStringValue()).isEqualTo((Object)"JAVA");
        Truth.assertThat((String)contextStruct.getFieldsOrThrow("framework").getStringValue()).isEqualTo((Object)"ABC_FRAMEWORK");
        Truth.assertThat((Double)contextStruct.getFieldsOrThrow("major_version").getNumberValue()).isEqualTo((Object)Versions.MAJOR_VERSION);
        Truth.assertThat((Double)contextStruct.getFieldsOrThrow("minor_version").getNumberValue()).isEqualTo((Object)Versions.MINOR_VERSION);
    }

    @Test
    public void noFramework_noFramework() {
        Struct contextStruct = PubsubContext.of().getStruct();
        Truth.assertThat((String)contextStruct.getFieldsOrThrow("language").getStringValue()).isEqualTo((Object)"JAVA");
        Truth.assertThat((Boolean)contextStruct.containsFields("framework")).isFalse();
        Truth.assertThat((Double)contextStruct.getFieldsOrThrow("major_version").getNumberValue()).isEqualTo((Object)Versions.MAJOR_VERSION);
        Truth.assertThat((Double)contextStruct.getFieldsOrThrow("minor_version").getNumberValue()).isEqualTo((Object)Versions.MINOR_VERSION);
    }
}

