/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.testing.TestResetSignal;
import com.google.cloud.pubsublite.internal.wire.ResetSignal;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.rpc.ErrorInfo;
import com.google.rpc.ResourceInfo;
import com.google.rpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.protobuf.StatusProto;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ResetSignalTest {
    @Test
    public void isResetSignal_matches() {
        Truth.assertThat((Boolean)ResetSignal.isResetSignal((CheckedApiException)TestResetSignal.newCheckedException())).isTrue();
    }

    @Test
    public void isResetSignal_notStatus() {
        Truth.assertThat((Boolean)ResetSignal.isResetSignal((CheckedApiException)new CheckedApiException((Throwable)new Exception(""), StatusCode.Code.ABORTED))).isFalse();
    }

    @Test
    public void isResetSignal_missingDetails() {
        Truth.assertThat((Boolean)ResetSignal.isResetSignal((CheckedApiException)new CheckedApiException(StatusCode.Code.ABORTED))).isFalse();
    }

    @Test
    public void isResetSignal_wrongReason() {
        ErrorInfo errorInfo = ErrorInfo.newBuilder().setReason("OTHER").setDomain("pubsublite.googleapis.com").build();
        Status status = Status.newBuilder().setCode(StatusCode.Code.ABORTED.ordinal()).addDetails(Any.pack((Message)errorInfo)).build();
        CheckedApiException exception = new CheckedApiException((Throwable)StatusProto.toStatusRuntimeException((Status)status), StatusCode.Code.ABORTED);
        Truth.assertThat((Boolean)ResetSignal.isResetSignal((CheckedApiException)exception)).isFalse();
    }

    @Test
    public void isResetSignal_wrongDomain() {
        ErrorInfo errorInfo = ErrorInfo.newBuilder().setReason("RESET").setDomain("other.googleapis.com").build();
        Status status = Status.newBuilder().setCode(StatusCode.Code.ABORTED.ordinal()).addDetails(Any.pack((Message)errorInfo)).build();
        CheckedApiException exception = new CheckedApiException((Throwable)StatusProto.toStatusRuntimeException((Status)status), StatusCode.Code.ABORTED);
        Truth.assertThat((Boolean)ResetSignal.isResetSignal((CheckedApiException)exception)).isFalse();
    }

    @Test
    public void isResetSignal_notRetryable() {
        ErrorInfo errorInfo = ErrorInfo.newBuilder().setReason("RESET").setDomain("pubsublite.googleapis.com").build();
        Status status = Status.newBuilder().setCode(StatusCode.Code.FAILED_PRECONDITION.ordinal()).addDetails(Any.pack((Message)errorInfo)).build();
        CheckedApiException exception = new CheckedApiException((Throwable)StatusProto.toStatusRuntimeException((Status)status), StatusCode.Code.FAILED_PRECONDITION);
        Truth.assertThat((Boolean)ResetSignal.isResetSignal((CheckedApiException)exception)).isFalse();
    }

    @Test
    public void isResetSignal_notErrorInfo() {
        Status status = Status.newBuilder().setCode(StatusCode.Code.ABORTED.ordinal()).addDetails(Any.pack((Message)ResourceInfo.getDefaultInstance())).build();
        CheckedApiException exception = new CheckedApiException((Throwable)StatusProto.toStatusRuntimeException((Status)status), StatusCode.Code.ABORTED);
        Truth.assertThat((Boolean)ResetSignal.isResetSignal((CheckedApiException)exception)).isFalse();
    }
}

