/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import com.google.cloud.pubsublite.internal.testing.FakeApiService;
import com.google.cloud.pubsublite.internal.wire.RoutingPublisher;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class RoutingPublisherTest {
    @Spy
    private FakePublisher publisher0;
    @Spy
    private FakePublisher publisher1;
    @Mock
    private RoutingPolicy routingPolicy;
    private RoutingPublisher routing;

    @Before
    public void setUp() throws CheckedApiException {
        MockitoAnnotations.initMocks((Object)this);
        this.routing = new RoutingPublisher((Map)ImmutableMap.of((Object)Partition.of((long)0L), (Object)((Object)this.publisher0), (Object)Partition.of((long)1L), (Object)((Object)this.publisher1)), this.routingPolicy);
        this.routing.startAsync().awaitRunning();
    }

    @Test
    public void flushFlushesAll() throws Exception {
        this.routing.flush();
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher0), (VerificationMode)Mockito.times((int)1)))).flush();
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher1), (VerificationMode)Mockito.times((int)1)))).flush();
        this.routing.stopAsync().awaitTerminated();
    }

    @Test
    public void cancelOutstandingCancelsAll() throws Exception {
        this.routing.cancelOutstandingPublishes();
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher0), (VerificationMode)Mockito.times((int)1)))).cancelOutstandingPublishes();
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher1), (VerificationMode)Mockito.times((int)1)))).cancelOutstandingPublishes();
        this.routing.stopAsync().awaitTerminated();
    }

    @Test
    public void publishValidRoute() throws Exception {
        Message message = Message.builder().setKey(ByteString.copyFromUtf8((String)"abc")).build();
        Mockito.when((Object)this.routingPolicy.route(message.key())).thenReturn((Object)Partition.of((long)1L));
        MessageMetadata meta = MessageMetadata.of((Partition)Partition.of((long)1L), (Offset)Offset.of((long)3L));
        Mockito.when((Object)this.publisher1.publish(message)).thenReturn((Object)ApiFutures.immediateFuture((Object)meta));
        ApiFuture fut = this.routing.publish(message);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.publisher1), (VerificationMode)Mockito.times((int)1)))).publish(message);
        Truth.assertThat((Object)fut.get()).isEqualTo((Object)meta);
        this.routing.stopAsync().awaitTerminated();
    }

    @Test
    public void publishInvalidRoute() throws Exception {
        Message message = Message.builder().setKey(ByteString.copyFromUtf8((String)"abc")).build();
        Mockito.when((Object)this.routingPolicy.route(message.key())).thenReturn((Object)Partition.of((long)77L));
        ApiFuture fut = this.routing.publish(message);
        ApiExceptionMatcher.assertFutureThrowsCode(fut, StatusCode.Code.FAILED_PRECONDITION);
    }

    static abstract class FakePublisher
    extends FakeApiService
    implements Publisher<MessageMetadata> {
        FakePublisher() {
        }
    }
}

