/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.wire.SerialBatcher;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SerialBatcherTest {
    private static final PubSubMessage MESSAGE_1 = PubSubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"data")).build();
    private static final PubSubMessage MESSAGE_2 = PubSubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"other data")).build();
    private static final PubSubMessage MESSAGE_3 = PubSubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"more data")).build();

    private static List<PubSubMessage> extractMessages(List<List<SerialBatcher.UnbatchedMessage>> messages) {
        return messages.stream().flatMap(batch -> batch.stream().map(SerialBatcher.UnbatchedMessage::message)).collect(Collectors.toList());
    }

    private static List<PubSubMessage> extractMessagesFromBatch(List<SerialBatcher.UnbatchedMessage> messages) {
        return messages.stream().map(SerialBatcher.UnbatchedMessage::message).collect(Collectors.toList());
    }

    @Test
    public void needsImmediateFlushAtMessageLimit() throws Exception {
        SerialBatcher batcher = new SerialBatcher(10000L, 1L);
        ApiFuture future = batcher.add(PubSubMessage.getDefaultInstance());
        List batches = batcher.flush();
        Truth.assertThat((Iterable)batches).hasSize(1);
        List messages = (List)batches.get(0);
        Truth.assertThat((Iterable)messages).hasSize(1);
        Truth.assertThat((Boolean)future.isDone()).isFalse();
        ((SerialBatcher.UnbatchedMessage)messages.get(0)).future().set((Object)Offset.of((long)43L));
        Truth.assertThat((Comparable)((Comparable)future.get())).isEqualTo((Object)Offset.of((long)43L));
    }

    @Test
    public void moreThanLimitMultipleBatches() throws Exception {
        SerialBatcher batcher = new SerialBatcher((long)(MESSAGE_1.getSerializedSize() + MESSAGE_2.getSerializedSize()), 1000L);
        batcher.add(MESSAGE_1);
        batcher.add(MESSAGE_2);
        batcher.add(MESSAGE_3);
        List batches = batcher.flush();
        Truth.assertThat((Iterable)batches).hasSize(2);
        Truth.assertThat(SerialBatcherTest.extractMessagesFromBatch((List)batches.get(0))).containsExactly(new Object[]{MESSAGE_1, MESSAGE_2});
        Truth.assertThat(SerialBatcherTest.extractMessagesFromBatch((List)batches.get(1))).containsExactly(new Object[]{MESSAGE_3});
    }

    @Test
    public void flushMessageLimit() {
        SerialBatcher batcher = new SerialBatcher(10000L, 2L);
        batcher.add(MESSAGE_1);
        batcher.add(MESSAGE_2);
        batcher.add(MESSAGE_3);
        List batches = batcher.flush();
        Truth.assertThat((Integer)batches.size()).isEqualTo((Object)2);
        Truth.assertThat(SerialBatcherTest.extractMessagesFromBatch((List)batches.get(0))).containsExactly(new Object[]{MESSAGE_1, MESSAGE_2});
        Truth.assertThat(SerialBatcherTest.extractMessagesFromBatch((List)batches.get(1))).containsExactly(new Object[]{MESSAGE_3});
    }

    @Test
    public void flushByteLimit() {
        SerialBatcher batcher = new SerialBatcher((long)(MESSAGE_1.getSerializedSize() + MESSAGE_2.getSerializedSize() + 1), 10000L);
        batcher.add(MESSAGE_1);
        batcher.add(MESSAGE_2);
        batcher.add(MESSAGE_3);
        List batches = batcher.flush();
        Truth.assertThat((Integer)batches.size()).isEqualTo((Object)2);
        Truth.assertThat(SerialBatcherTest.extractMessagesFromBatch((List)batches.get(0))).containsExactly(new Object[]{MESSAGE_1, MESSAGE_2});
        Truth.assertThat(SerialBatcherTest.extractMessagesFromBatch((List)batches.get(1))).containsExactly(new Object[]{MESSAGE_3});
    }

    @Test
    public void batchesMessagesAtLimit() {
        SerialBatcher batcher = new SerialBatcher((long)(MESSAGE_1.getSerializedSize() + MESSAGE_2.getSerializedSize()), 10000L);
        batcher.add(MESSAGE_2);
        batcher.add(MESSAGE_1);
        Truth.assertThat(SerialBatcherTest.extractMessages(batcher.flush())).containsExactly(new Object[]{MESSAGE_2, MESSAGE_1});
    }
}

