/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.testing.FakeApiService;
import com.google.cloud.pubsublite.internal.wire.PublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.StreamFactories;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class SinglePartitionPublisherTest {
    @Spy
    private FakeOffsetPublisher underlying;
    @Mock
    private StreamFactories.PublishStreamFactory streamFactory;
    private Publisher<MessageMetadata> pub;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        TopicPath topic = ((TopicPath.Builder)((TopicPath.Builder)TopicPath.newBuilder().setName(TopicName.of((String)"abc")).setProject(ProjectNumber.of((long)123L))).setLocation(CloudZone.of((CloudRegion)CloudRegion.of((String)"us-central1"), (char)'a'))).build();
        Partition partition = Partition.of((long)3L);
        PublisherBuilder.Builder mockBuilder = (PublisherBuilder.Builder)Mockito.mock(PublisherBuilder.Builder.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)mockBuilder.build()).thenReturn((Object)this.underlying);
        Mockito.when((Object)mockBuilder.setTopic(topic)).thenReturn((Object)mockBuilder);
        this.pub = SinglePartitionPublisherBuilder.newBuilder().setTopic(topic).setPartition(partition).setUnderlyingBuilder(mockBuilder).setBatchingSettings(BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(false)).build()).setStreamFactory(this.streamFactory).build();
        this.pub.startAsync().awaitRunning();
    }

    @Test
    public void publishResultTransformed() throws Exception {
        SettableApiFuture offsetFuture = SettableApiFuture.create();
        Message message = Message.builder().setData(ByteString.copyFromUtf8((String)"xyz")).build();
        Mockito.when((Object)this.underlying.publish(message)).thenReturn((Object)offsetFuture);
        ApiFuture metadataFuture = this.pub.publish(message);
        Truth.assertThat((Boolean)metadataFuture.isDone()).isFalse();
        offsetFuture.set((Object)Offset.of((long)7L));
        Truth.assertThat((Object)metadataFuture.get()).isEqualTo((Object)MessageMetadata.of((Partition)Partition.of((long)3L), (Offset)Offset.of((long)7L)));
        this.pub.stopAsync().awaitTerminated();
    }

    @Test
    public void flushFlushesUnderlying() throws Exception {
        this.pub.flush();
        ((FakeOffsetPublisher)((Object)Mockito.verify((Object)((Object)this.underlying), (VerificationMode)Mockito.times((int)1)))).flush();
        this.pub.stopAsync().awaitTerminated();
    }

    @Test
    public void cancelOutstandingCancelsUnderlyingPublishes() throws Exception {
        this.pub.cancelOutstandingPublishes();
        ((FakeOffsetPublisher)((Object)Mockito.verify((Object)((Object)this.underlying), (VerificationMode)Mockito.times((int)1)))).cancelOutstandingPublishes();
        this.pub.stopAsync().awaitTerminated();
    }

    static abstract class FakeOffsetPublisher
    extends FakeApiService
    implements Publisher<Offset> {
        FakeOffsetPublisher() {
        }
    }
}

