/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.SettableApiFuture;
import com.google.cloud.pubsublite.internal.AlarmFactory;
import com.google.cloud.pubsublite.internal.wire.StreamIdleTimer;
import cz.o2.proxima.internal.shaded.com.google.common.base.Ticker;
import cz.o2.proxima.internal.shaded.com.google.common.testing.FakeTicker;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class StreamIdleTimerTest {
    private static final Duration TIMEOUT = Duration.ofSeconds(60L);
    @Mock
    private AlarmFactory mockAlarmFactory;
    private final SettableApiFuture<Void> taskFuture = SettableApiFuture.create();
    private final FakeTicker fakeTicker = new FakeTicker();
    private final CountDownLatch handlerCalled = new CountDownLatch(1);
    private StreamIdleTimer timer;
    private Runnable leakedPoller;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockAlarmFactory.newAlarm((Runnable)ArgumentMatchers.any())).thenAnswer(args -> {
            this.leakedPoller = (Runnable)args.getArgument(0);
            return this.taskFuture;
        });
        this.timer = new StreamIdleTimer(TIMEOUT, this.handlerCalled::countDown, (Ticker)this.fakeTicker, this.mockAlarmFactory);
        ((AlarmFactory)Mockito.verify((Object)this.mockAlarmFactory)).newAlarm((Runnable)ArgumentMatchers.any());
        Truth.assertThat((Object)this.leakedPoller).isNotNull();
    }

    @After
    public void shutdown() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockAlarmFactory});
    }

    @Test
    public void delayComputedCorrectly() {
        Truth.assertThat((Comparable)StreamIdleTimer.getDelay((Duration)Duration.ofSeconds(60L))).isEqualTo((Object)Duration.ofSeconds(15L));
        Truth.assertThat((Comparable)StreamIdleTimer.getDelay((Duration)Duration.ofMinutes(5L))).isEqualTo((Object)Duration.ofMinutes(1L));
    }

    @Test
    public void timeoutHandlerCalledCorrectly() throws Exception {
        this.fakeTicker.advance(TIMEOUT.minusSeconds(1L));
        this.leakedPoller.run();
        Truth.assertThat((Boolean)this.handlerCalled.await(10L, TimeUnit.MILLISECONDS)).isFalse();
        this.fakeTicker.advance(Duration.ofSeconds(2L));
        this.leakedPoller.run();
        Truth.assertThat((Boolean)this.handlerCalled.await(30L, TimeUnit.SECONDS)).isTrue();
    }

    @Test
    public void restartResetsTimer() throws Exception {
        this.fakeTicker.advance(TIMEOUT.minusSeconds(1L));
        this.timer.restart();
        this.fakeTicker.advance(Duration.ofSeconds(2L));
        this.leakedPoller.run();
        Truth.assertThat((Boolean)this.handlerCalled.await(10L, TimeUnit.MILLISECONDS)).isFalse();
        this.fakeTicker.advance(TIMEOUT);
        this.leakedPoller.run();
        Truth.assertThat((Boolean)this.handlerCalled.await(30L, TimeUnit.SECONDS)).isTrue();
    }

    @Test
    public void closeCancelsTask() throws Exception {
        this.fakeTicker.advance(TIMEOUT.minusSeconds(1L));
        this.leakedPoller.run();
        this.timer.close();
        Truth.assertThat((Boolean)this.taskFuture.isCancelled()).isTrue();
        Truth.assertThat((Boolean)this.handlerCalled.await(10L, TimeUnit.MILLISECONDS)).isFalse();
    }
}

