/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiService;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.AlarmFactory;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.testing.RetryingConnectionHelpers;
import com.google.cloud.pubsublite.internal.testing.TestResetSignal;
import com.google.cloud.pubsublite.internal.wire.ConnectedSubscriber;
import com.google.cloud.pubsublite.internal.wire.ConnectedSubscriberFactory;
import com.google.cloud.pubsublite.internal.wire.StreamFactories;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.cloud.pubsublite.internal.wire.SubscriberImpl;
import com.google.cloud.pubsublite.internal.wire.SubscriberResetHandler;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.cloud.pubsublite.proto.InitialSubscribeRequest;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.proto.SubscribeRequest;
import com.google.protobuf.Any;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.protobuf.StatusProto;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class SubscriberImplTest {
    private static final InitialSubscribeRequest BASE_INITIAL_SUBSCRIBE_REQUEST = InitialSubscribeRequest.newBuilder().setSubscription(((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setProject(ProjectNumber.of((long)12345L))).setLocation(CloudZone.of((CloudRegion)CloudRegion.of((String)"us-east1"), (char)'a'))).setName(SubscriptionName.of((String)"some_subscription")).build().toString()).setPartition(1024L).build();
    private static final SeekRequest INITIAL_LOCATION = SeekRequest.newBuilder().setNamedTarget(SeekRequest.NamedTarget.COMMITTED_CURSOR).build();
    private static final CheckedApiException DUPLICATE_CONNECTION_SIGNAL = new CheckedApiException((Throwable)StatusProto.toStatusRuntimeException((Status)Status.newBuilder().setCode(StatusCode.Code.ABORTED.ordinal()).addDetails(Any.pack((com.google.protobuf.Message)ErrorInfo.newBuilder().setReason("DUPLICATE_SUBSCRIBER_CONNECTIONS").setDomain("pubsublite.googleapis.com").build())).build()), StatusCode.Code.ABORTED);
    @Mock
    private StreamFactories.SubscribeStreamFactory unusedStreamFactory;
    @Mock
    private ConnectedSubscriber mockConnectedSubscriber1;
    @Mock
    private ConnectedSubscriber mockConnectedSubscriber2;
    @Mock
    private ConnectedSubscriberFactory mockSubscriberFactory;
    @Mock
    private AlarmFactory alarmFactory;
    @Mock
    private Consumer<List<SequencedMessage>> mockMessageConsumer;
    @Mock
    private SubscriberResetHandler mockResetHandler;
    private SubscriberImpl subscriber;
    private ResponseObserver<List<SequencedMessage>> leakedResponseObserver;
    private Runnable leakedFlowControlAlarm;

    private static SubscribeRequest initialRequest() {
        return SubscribeRequest.newBuilder().setInitial(BASE_INITIAL_SUBSCRIBE_REQUEST.toBuilder().setInitialLocation(INITIAL_LOCATION)).build();
    }

    private CountDownLatch countdownMessageBatches(int count) {
        CountDownLatch received = new CountDownLatch(count);
        ((Consumer)Mockito.doAnswer(args -> {
            received.countDown();
            return null;
        }).when(this.mockMessageConsumer)).accept(ArgumentMatchers.any());
        return received;
    }

    @Before
    public void setUp() throws CheckedApiException {
        MockitoAnnotations.initMocks((Object)this);
        ((ConnectedSubscriberFactory)Mockito.doAnswer(args -> {
            this.leakedResponseObserver = (ResponseObserver)args.getArgument(1);
            return this.mockConnectedSubscriber1;
        }).when((Object)this.mockSubscriberFactory)).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
        Mockito.when((Object)this.alarmFactory.newAlarm((Runnable)ArgumentMatchers.any())).thenAnswer(args -> {
            this.leakedFlowControlAlarm = (Runnable)args.getArgument(0);
            return SettableApiFuture.create();
        });
        this.subscriber = new SubscriberImpl(this.unusedStreamFactory, this.mockSubscriberFactory, this.alarmFactory, BASE_INITIAL_SUBSCRIBE_REQUEST, INITIAL_LOCATION, this.mockMessageConsumer, this.mockResetHandler, true);
        this.subscriber.startAsync().awaitRunning();
    }

    @Test
    public void invalidFlowThrows() {
        Assert.assertThrows(CheckedApiException.class, () -> this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(-1L).build()));
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
    }

    FlowControlRequest bigFlowControlRequest() {
        return FlowControlRequest.newBuilder().setAllowedBytes(Long.MAX_VALUE).setAllowedMessages(Long.MAX_VALUE).build();
    }

    @Test
    public void anyFlowAllowedAndProxies() throws CheckedApiException {
        this.subscriber.allowFlow(this.bigFlowControlRequest());
        ((ConnectedSubscriber)Mockito.verify((Object)this.mockConnectedSubscriber1)).allowFlow(this.bigFlowControlRequest());
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
    }

    @Test
    public void batchesFlowControlRequests() throws Exception {
        FlowControlRequest initialFlowRequest = FlowControlRequest.newBuilder().setAllowedBytes(10000L).setAllowedMessages(1000L).build();
        this.subscriber.allowFlow(initialFlowRequest);
        ((ConnectedSubscriber)Mockito.verify((Object)this.mockConnectedSubscriber1)).allowFlow(initialFlowRequest);
        FlowControlRequest deltaFlowRequest = FlowControlRequest.newBuilder().setAllowedBytes(100L).setAllowedMessages(10L).build();
        this.subscriber.allowFlow(deltaFlowRequest);
        this.subscriber.allowFlow(deltaFlowRequest);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockConnectedSubscriber1});
        this.leakedFlowControlAlarm.run();
        FlowControlRequest expectedBatchFlowRequest = FlowControlRequest.newBuilder().setAllowedBytes(200L).setAllowedMessages(20L).build();
        ((ConnectedSubscriber)Mockito.verify((Object)this.mockConnectedSubscriber1)).allowFlow(expectedBatchFlowRequest);
        this.leakedFlowControlAlarm.run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockConnectedSubscriber1});
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
    }

    @Test
    public void messagesEmpty_IsError() throws Exception {
        Future<Void> failed = RetryingConnectionHelpers.whenFailed((ApiService)this.subscriber);
        this.subscriber.allowFlow(this.bigFlowControlRequest());
        this.leakedResponseObserver.onResponse((Object)ImmutableList.of());
        Assert.assertThrows(IllegalStateException.class, () -> ((SubscriberImpl)this.subscriber).awaitTerminated());
        failed.get();
        ApiExceptionMatcher.assertThrowableMatches(this.subscriber.failureCause(), StatusCode.Code.INVALID_ARGUMENT);
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
    }

    @Test
    public void messagesUnordered_IsError() throws Exception {
        Future<Void> failed = RetryingConnectionHelpers.whenFailed((ApiService)this.subscriber);
        this.subscriber.allowFlow(this.bigFlowControlRequest());
        this.leakedResponseObserver.onResponse((Object)ImmutableList.of((Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)1L), (long)10L), (Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)0L), (long)10L)));
        Assert.assertThrows(IllegalStateException.class, () -> ((SubscriberImpl)this.subscriber).awaitTerminated());
        failed.get();
        ApiExceptionMatcher.assertThrowableMatches(this.subscriber.failureCause(), StatusCode.Code.INVALID_ARGUMENT);
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
    }

    @Test
    public void messageBatchesOutOfOrder_IsError() throws Exception {
        Future<Void> failed = RetryingConnectionHelpers.whenFailed((ApiService)this.subscriber);
        this.subscriber.allowFlow(this.bigFlowControlRequest());
        ImmutableList messages = ImmutableList.of((Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)0L), (long)0L));
        this.leakedResponseObserver.onResponse((Object)messages);
        this.leakedResponseObserver.onResponse((Object)messages);
        failed.get();
        ApiExceptionMatcher.assertThrowableMatches(this.subscriber.failureCause(), StatusCode.Code.FAILED_PRECONDITION);
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
    }

    @Test
    public void messagesOrdered_Ok() throws Exception {
        this.subscriber.allowFlow(this.bigFlowControlRequest());
        ImmutableList messages = ImmutableList.of((Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)0L), (long)10L), (Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)1L), (long)10L));
        CountDownLatch messagesReceived = this.countdownMessageBatches(1);
        this.leakedResponseObserver.onResponse((Object)messages);
        Truth.assertThat((Boolean)messagesReceived.await(10L, TimeUnit.SECONDS)).isTrue();
        ((Consumer)Mockito.verify(this.mockMessageConsumer)).accept(messages);
        Truth.assertThat((Boolean)this.subscriber.isRunning()).isTrue();
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
    }

    @Test
    public void messageResponseSubtracts() throws Exception {
        Future<Void> failed = RetryingConnectionHelpers.whenFailed((ApiService)this.subscriber);
        FlowControlRequest request = FlowControlRequest.newBuilder().setAllowedBytes(100L).setAllowedMessages(100L).build();
        this.subscriber.allowFlow(request);
        ((ConnectedSubscriber)Mockito.verify((Object)this.mockConnectedSubscriber1)).allowFlow(request);
        ImmutableList messages1 = ImmutableList.of((Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)1L), (long)98L), (Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)2L), (long)1L));
        ImmutableList messages2 = ImmutableList.of((Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)3L), (long)2L));
        CountDownLatch messagesReceived = this.countdownMessageBatches(1);
        this.leakedResponseObserver.onResponse((Object)messages1);
        Truth.assertThat((Boolean)messagesReceived.await(10L, TimeUnit.SECONDS)).isTrue();
        ((Consumer)Mockito.verify(this.mockMessageConsumer)).accept(messages1);
        Truth.assertThat((Boolean)this.subscriber.isRunning()).isTrue();
        this.leakedResponseObserver.onResponse((Object)messages2);
        failed.get();
        ApiExceptionMatcher.assertThrowableMatches(this.subscriber.failureCause(), StatusCode.Code.FAILED_PRECONDITION);
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
    }

    @Test
    public void reinitialize_reconnectsToNextOffset() throws Exception {
        this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(100L).setAllowedMessages(100L).build());
        ImmutableList messages = ImmutableList.of((Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)0L), (long)10L), (Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)1L), (long)10L));
        CountDownLatch messagesReceived = this.countdownMessageBatches(1);
        this.leakedResponseObserver.onResponse((Object)messages);
        Truth.assertThat((Boolean)messagesReceived.await(10L, TimeUnit.SECONDS)).isTrue();
        ((Consumer)Mockito.verify(this.mockMessageConsumer)).accept(messages);
        SubscribeRequest nextOffsetRequest = SubscribeRequest.newBuilder().setInitial(BASE_INITIAL_SUBSCRIBE_REQUEST.toBuilder().setInitialLocation(SeekRequest.newBuilder().setCursor(Cursor.newBuilder().setOffset(2L)))).build();
        ((ConnectedSubscriberFactory)Mockito.doAnswer(args -> {
            this.leakedResponseObserver = (ResponseObserver)args.getArgument(1);
            return this.mockConnectedSubscriber2;
        }).when((Object)this.mockSubscriberFactory)).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)nextOffsetRequest));
        this.subscriber.triggerReinitialize(new CheckedApiException(StatusCode.Code.ABORTED));
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)nextOffsetRequest));
        ((ConnectedSubscriber)Mockito.verify((Object)this.mockConnectedSubscriber2)).allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(80L).setAllowedMessages(98L).build());
    }

    @Test
    public void reinitialize_retriesDuplicateConnectionByDefault() {
        this.subscriber.triggerReinitialize(DUPLICATE_CONNECTION_SIGNAL);
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)2))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
    }

    @Test
    public void reinitialize_doesntRetryDuplicateConnectionIfDisabled() throws Exception {
        this.subscriber = new SubscriberImpl(this.unusedStreamFactory, this.mockSubscriberFactory, this.alarmFactory, BASE_INITIAL_SUBSCRIBE_REQUEST, INITIAL_LOCATION, this.mockMessageConsumer, this.mockResetHandler, false);
        Future<Void> failed = RetryingConnectionHelpers.whenFailed((ApiService)this.subscriber);
        this.subscriber.startAsync().awaitRunning();
        this.subscriber.triggerReinitialize(DUPLICATE_CONNECTION_SIGNAL);
        failed.get();
        ApiExceptionMatcher.assertThrowableMatches(this.subscriber.failureCause(), DUPLICATE_CONNECTION_SIGNAL.code());
    }

    @Test
    public void reinitialize_handlesSuccessfulReset() throws Exception {
        this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(100L).setAllowedMessages(100L).build());
        ImmutableList messages = ImmutableList.of((Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)0L), (long)10L), (Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)1L), (long)10L));
        CountDownLatch messagesReceived = this.countdownMessageBatches(1);
        this.leakedResponseObserver.onResponse((Object)messages);
        ((ConnectedSubscriberFactory)Mockito.doAnswer(args -> {
            this.leakedResponseObserver = (ResponseObserver)args.getArgument(1);
            return this.mockConnectedSubscriber2;
        }).when((Object)this.mockSubscriberFactory)).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
        Mockito.when((Object)this.mockResetHandler.handleReset()).thenReturn((Object)true);
        this.subscriber.triggerReinitialize(TestResetSignal.newCheckedException());
        Truth.assertThat((Boolean)messagesReceived.await(10L, TimeUnit.SECONDS)).isTrue();
        ((Consumer)Mockito.verify(this.mockMessageConsumer)).accept(messages);
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)2))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
        ((ConnectedSubscriber)Mockito.verify((Object)this.mockConnectedSubscriber2)).allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(80L).setAllowedMessages(98L).build());
    }

    @Test
    public void reinitialize_handlesIgnoredReset() throws Exception {
        this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(100L).setAllowedMessages(100L).build());
        ImmutableList messages = ImmutableList.of((Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)0L), (long)10L), (Object)SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)1L), (long)10L));
        CountDownLatch messagesReceived = this.countdownMessageBatches(1);
        this.leakedResponseObserver.onResponse((Object)messages);
        Truth.assertThat((Boolean)messagesReceived.await(10L, TimeUnit.SECONDS)).isTrue();
        ((Consumer)Mockito.verify(this.mockMessageConsumer)).accept(messages);
        SubscribeRequest nextOffsetRequest = SubscribeRequest.newBuilder().setInitial(BASE_INITIAL_SUBSCRIBE_REQUEST.toBuilder().setInitialLocation(SeekRequest.newBuilder().setCursor(Cursor.newBuilder().setOffset(2L)))).build();
        ((ConnectedSubscriberFactory)Mockito.doAnswer(args -> {
            this.leakedResponseObserver = (ResponseObserver)args.getArgument(1);
            return this.mockConnectedSubscriber2;
        }).when((Object)this.mockSubscriberFactory)).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)nextOffsetRequest));
        Mockito.when((Object)this.mockResetHandler.handleReset()).thenReturn((Object)false);
        this.subscriber.triggerReinitialize(TestResetSignal.newCheckedException());
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)nextOffsetRequest));
        ((ConnectedSubscriber)Mockito.verify((Object)this.mockConnectedSubscriber2)).allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(80L).setAllowedMessages(98L).build());
    }

    @Test
    public void reinitialize_handlesResetFailure() throws Exception {
        Future<Void> failed = RetryingConnectionHelpers.whenFailed((ApiService)this.subscriber);
        ((SubscriberResetHandler)Mockito.doThrow((Throwable[])new Throwable[]{new CheckedApiException(StatusCode.Code.UNAVAILABLE)}).when((Object)this.mockResetHandler)).handleReset();
        this.subscriber.triggerReinitialize(TestResetSignal.newCheckedException());
        failed.get();
        ApiExceptionMatcher.assertThrowableMatches(this.subscriber.failureCause(), StatusCode.Code.UNAVAILABLE);
        ((ConnectedSubscriberFactory)Mockito.verify((Object)this.mockSubscriberFactory, (VerificationMode)Mockito.times((int)1))).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)SubscriberImplTest.initialRequest()));
    }
}

