/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.it;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.cloudpubsub.Publisher;
import com.google.cloud.pubsublite.cloudpubsub.PublisherSettings;
import com.google.cloud.pubsublite.cloudpubsub.Subscriber;
import com.google.cloud.pubsublite.cloudpubsub.SubscriberSettings;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.protobuf.FieldMask;
import com.google.protobuf.util.Durations;
import com.google.pubsub.v1.PubsubMessage;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ITVPCNegativeTest {
    private static final boolean IS_VPCSC_TEST = System.getenv("GOOGLE_CLOUD_TESTS_IN_VPCSC") != null && System.getenv("GOOGLE_CLOUD_TESTS_IN_VPCSC").equalsIgnoreCase("true");
    private static final String OUTSIDE_VPCSC_PROJECT = System.getenv("GOOGLE_CLOUD_TESTS_VPCSC_OUTSIDE_PERIMETER_PROJECT_NUMBER");
    private static final Long PROJECT_NUMBER = OUTSIDE_VPCSC_PROJECT == null ? 0L : Long.parseLong(OUTSIDE_VPCSC_PROJECT);
    private static final String CLOUD_REGION = "us-central1";
    private static final char ZONE_ID = 'b';
    private static final String SUFFIX = UUID.randomUUID().toString();
    private static final String TOPIC_NAME = "lite-topic-" + SUFFIX;
    private static final String SUBSCRIPTION_NAME = "lite-subscription-" + SUFFIX;
    private static final int PARTITIONS = 1;
    private LocationPath locationPath;
    private TopicPath topicPath;
    private Topic topic;
    private SubscriptionPath subscriptionPath;
    private Subscription subscription;
    private AdminClient adminClient;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)300L);

    private static void requireEnvVar(String varName) {
        TestCase.assertNotNull((String)("Environment variable " + varName + " is required to perform these tests."), (Object)System.getenv(varName));
    }

    @BeforeClass
    public static void checkRequirements() {
        Assume.assumeTrue((String)"To run tests, GOOGLE_CLOUD_TESTS_IN_VPCSC environment variable needs to be set to True", (boolean)IS_VPCSC_TEST);
        ITVPCNegativeTest.requireEnvVar("GOOGLE_CLOUD_TESTS_VPCSC_OUTSIDE_PERIMETER_PROJECT_NUMBER");
    }

    @Before
    public void setUp() throws Exception {
        CloudRegion cloudRegion = CloudRegion.of((String)CLOUD_REGION);
        CloudZone zone = CloudZone.of((CloudRegion)cloudRegion, (char)'b');
        ProjectNumber projectNum = ProjectNumber.of((long)PROJECT_NUMBER);
        this.locationPath = ((LocationPath.Builder)((LocationPath.Builder)LocationPath.newBuilder().setProject(projectNum)).setLocation(zone)).build();
        TopicName topicName = TopicName.of((String)TOPIC_NAME);
        this.topicPath = ((TopicPath.Builder)((TopicPath.Builder)TopicPath.newBuilder().setLocation(zone)).setProject(projectNum)).setName(topicName).build();
        this.topic = Topic.newBuilder().setPartitionConfig(Topic.PartitionConfig.newBuilder().setScale(1).setCount(1L)).setRetentionConfig(Topic.RetentionConfig.newBuilder().setPeriod(Durations.fromDays((long)1L)).setPerPartitionBytes(0x1900000000L)).setName(this.topicPath.toString()).build();
        SubscriptionName subscriptionName = SubscriptionName.of((String)SUBSCRIPTION_NAME);
        this.subscriptionPath = ((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setLocation(zone)).setProject(projectNum)).setName(subscriptionName).build();
        this.subscription = Subscription.newBuilder().setDeliveryConfig(Subscription.DeliveryConfig.newBuilder().setDeliveryRequirement(Subscription.DeliveryConfig.DeliveryRequirement.DELIVER_AFTER_STORED)).setName(this.subscriptionPath.toString()).setTopic(this.topicPath.toString()).build();
        AdminClientSettings adminClientSettings = AdminClientSettings.newBuilder().setRegion(cloudRegion).build();
        this.adminClient = AdminClient.create((AdminClientSettings)adminClientSettings);
    }

    @After
    public void tearDown() throws Exception {
        this.adminClient.close();
    }

    private static void checkExceptionForVPCError(CheckedApiException e) {
        Assert.assertEquals((Object)StatusCode.Code.PERMISSION_DENIED, (Object)e.code());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Request is prohibited by organization's policy");
    }

    @Test
    public void deniedCreateTopic() {
        try {
            this.adminClient.createTopic(this.topic).get();
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
            return;
        }
        try {
            this.adminClient.deleteTopic(this.topicPath).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException during createTopic");
        }
        catch (Exception e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException during createTopic but got: " + e.toString()));
        }
    }

    @Test
    public void deniedDeleteTopic() {
        try {
            this.adminClient.deleteTopic(this.topicPath).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException");
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
        }
    }

    @Test
    public void deniedGetTopic() {
        try {
            this.adminClient.getTopic(this.topicPath).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException");
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
        }
    }

    @Test
    public void deniedListTopics() {
        try {
            this.adminClient.listTopics(this.locationPath).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException");
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
        }
    }

    @Test
    public void deniedListTopicSubscriptions() {
        try {
            this.adminClient.listTopicSubscriptions(this.topicPath).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException");
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
        }
    }

    @Test
    public void deniedUpdateTopic() {
        try {
            FieldMask mask = FieldMask.newBuilder().addPaths("partition_config.scale").build();
            this.adminClient.updateTopic(this.topic, mask).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException");
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
        }
    }

    @Test
    public void deniedCreateSubscription() {
        try {
            this.adminClient.createSubscription(this.subscription).get();
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
            return;
        }
        try {
            this.adminClient.deleteSubscription(this.subscriptionPath).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException during createSubscription");
        }
        catch (Exception e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException during createSubscription but got: " + e.toString()));
        }
    }

    @Test
    public void deniedDeleteSubscription() {
        try {
            this.adminClient.deleteSubscription(this.subscriptionPath).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException");
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
        }
    }

    @Test
    public void deniedGetSubscription() {
        try {
            this.adminClient.getSubscription(this.subscriptionPath).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException");
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
        }
    }

    @Test
    public void deniedListSubscriptions() {
        try {
            this.adminClient.listSubscriptions(this.locationPath).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException");
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
        }
    }

    @Test
    public void deniedUpdateSubscription() {
        try {
            FieldMask mask = FieldMask.newBuilder().addPaths("delivery_config.delivery_requirement").build();
            this.adminClient.updateSubscription(this.subscription, mask).get();
            Assert.fail((String)"Expected PERMISSION_DENIED StatusRuntimeException");
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Expected PERMISSION_DENIED StatusRuntimeException but got: " + e.toString()));
        }
        catch (ExecutionException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e));
        }
    }

    @Test
    public void deniedPublish() {
        try {
            PublisherSettings publisherSettings = PublisherSettings.newBuilder().setTopicPath(this.topicPath).build();
            Publisher publisher = Publisher.create((PublisherSettings)publisherSettings);
            publisher.startAsync().awaitRunning();
            publisher.publish(PubsubMessage.newBuilder().build());
            publisher.awaitTerminated(30L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected PERMISSION_DENIED CheckedApiException");
        }
        catch (ApiException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(new CheckedApiException(e));
        }
        catch (TimeoutException t) {
            Assert.fail((String)("Expected PERMISSION_DENIED CheckedApiException but got: " + t.toString()));
        }
        catch (IllegalStateException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e.getCause()));
        }
    }

    @Test
    public void deniedSubscriber() {
        try {
            FlowControlSettings flowControlSettings = FlowControlSettings.builder().setBytesOutstanding(0xA00000L).setMessagesOutstanding(Long.MAX_VALUE).build();
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            partitions.add(Partition.of((long)0L));
            MessageReceiver receiver = (message, consumer) -> Assert.fail((String)"Expected PERMISSION_DENIED CheckedApiException");
            SubscriberSettings subscriberSettings = SubscriberSettings.newBuilder().setSubscriptionPath(this.subscriptionPath).setPerPartitionFlowControlSettings(flowControlSettings).setPartitions(partitions).setReceiver(receiver).build();
            Subscriber subscriber = Subscriber.create((SubscriberSettings)subscriberSettings);
            subscriber.startAsync().awaitRunning();
            subscriber.awaitTerminated(30L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected PERMISSION_DENIED CheckedApiException");
        }
        catch (ApiException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(new CheckedApiException(e));
        }
        catch (TimeoutException t) {
            Assert.fail((String)("Expected PERMISSION_DENIED CheckedApiException but got: " + t.toString()));
        }
        catch (IllegalStateException e) {
            ITVPCNegativeTest.checkExceptionForVPCError(ExtractStatus.toCanonical((Throwable)e.getCause()));
        }
    }
}

