/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsublite.proto.CreateReservationRequest;
import com.google.cloud.pubsublite.proto.CreateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.CreateTopicRequest;
import com.google.cloud.pubsublite.proto.DeleteReservationRequest;
import com.google.cloud.pubsublite.proto.DeleteSubscriptionRequest;
import com.google.cloud.pubsublite.proto.DeleteTopicRequest;
import com.google.cloud.pubsublite.proto.ExportConfig;
import com.google.cloud.pubsublite.proto.GetReservationRequest;
import com.google.cloud.pubsublite.proto.GetSubscriptionRequest;
import com.google.cloud.pubsublite.proto.GetTopicPartitionsRequest;
import com.google.cloud.pubsublite.proto.GetTopicRequest;
import com.google.cloud.pubsublite.proto.ListReservationTopicsRequest;
import com.google.cloud.pubsublite.proto.ListReservationTopicsResponse;
import com.google.cloud.pubsublite.proto.ListReservationsRequest;
import com.google.cloud.pubsublite.proto.ListReservationsResponse;
import com.google.cloud.pubsublite.proto.ListSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicsRequest;
import com.google.cloud.pubsublite.proto.ListTopicsResponse;
import com.google.cloud.pubsublite.proto.LocationName;
import com.google.cloud.pubsublite.proto.Reservation;
import com.google.cloud.pubsublite.proto.ReservationName;
import com.google.cloud.pubsublite.proto.SeekSubscriptionRequest;
import com.google.cloud.pubsublite.proto.SeekSubscriptionResponse;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.SubscriptionName;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.cloud.pubsublite.proto.TopicName;
import com.google.cloud.pubsublite.proto.TopicPartitions;
import com.google.cloud.pubsublite.proto.UpdateReservationRequest;
import com.google.cloud.pubsublite.proto.UpdateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.UpdateTopicRequest;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.cloud.pubsublite.v1.AdminServiceSettings;
import com.google.cloud.pubsublite.v1.MockAdminService;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AdminServiceClientTest {
    private static MockAdminService mockAdminService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private AdminServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockAdminService = new MockAdminService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockAdminService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        AdminServiceSettings settings = ((AdminServiceSettings.Builder)((AdminServiceSettings.Builder)AdminServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = AdminServiceClient.create((AdminServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createTopicTest() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartitionConfig(Topic.PartitionConfig.newBuilder().build()).setRetentionConfig(Topic.RetentionConfig.newBuilder().build()).setReservationConfig(Topic.ReservationConfig.newBuilder().build()).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Topic topic = Topic.newBuilder().build();
        String topicId = "topicId-1139259734";
        Topic actualResponse = this.client.createTopic(parent, topic, topicId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTopicRequest actualRequest = (CreateTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertEquals((Object)topicId, (Object)actualRequest.getTopicId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Topic topic = Topic.newBuilder().build();
            String topicId = "topicId-1139259734";
            this.client.createTopic(parent, topic, topicId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTopicTest2() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartitionConfig(Topic.PartitionConfig.newBuilder().build()).setRetentionConfig(Topic.RetentionConfig.newBuilder().build()).setReservationConfig(Topic.ReservationConfig.newBuilder().build()).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Topic topic = Topic.newBuilder().build();
        String topicId = "topicId-1139259734";
        Topic actualResponse = this.client.createTopic(parent, topic, topicId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTopicRequest actualRequest = (CreateTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertEquals((Object)topicId, (Object)actualRequest.getTopicId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTopicExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Topic topic = Topic.newBuilder().build();
            String topicId = "topicId-1139259734";
            this.client.createTopic(parent, topic, topicId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTopicTest() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartitionConfig(Topic.PartitionConfig.newBuilder().build()).setRetentionConfig(Topic.RetentionConfig.newBuilder().build()).setReservationConfig(Topic.ReservationConfig.newBuilder().build()).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        TopicName name = TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]");
        Topic actualResponse = this.client.getTopic(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTopicRequest actualRequest = (GetTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            TopicName name = TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]");
            this.client.getTopic(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTopicTest2() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartitionConfig(Topic.PartitionConfig.newBuilder().build()).setRetentionConfig(Topic.RetentionConfig.newBuilder().build()).setReservationConfig(Topic.ReservationConfig.newBuilder().build()).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Topic actualResponse = this.client.getTopic(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTopicRequest actualRequest = (GetTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTopicExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getTopic(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTopicPartitionsTest() throws Exception {
        TopicPartitions expectedResponse = TopicPartitions.newBuilder().setPartitionCount(-1738969222L).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        TopicName name = TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]");
        TopicPartitions actualResponse = this.client.getTopicPartitions(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTopicPartitionsRequest actualRequest = (GetTopicPartitionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTopicPartitionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            TopicName name = TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]");
            this.client.getTopicPartitions(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTopicPartitionsTest2() throws Exception {
        TopicPartitions expectedResponse = TopicPartitions.newBuilder().setPartitionCount(-1738969222L).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        TopicPartitions actualResponse = this.client.getTopicPartitions(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTopicPartitionsRequest actualRequest = (GetTopicPartitionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTopicPartitionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getTopicPartitions(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicsTest() throws Exception {
        Topic responsesElement = Topic.newBuilder().build();
        ListTopicsResponse expectedResponse = ListTopicsResponse.newBuilder().setNextPageToken("").addAllTopics(Arrays.asList(responsesElement)).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        AdminServiceClient.ListTopicsPagedResponse pagedListResponse = this.client.listTopics(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTopicsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicsRequest actualRequest = (ListTopicsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listTopics(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicsTest2() throws Exception {
        Topic responsesElement = Topic.newBuilder().build();
        ListTopicsResponse expectedResponse = ListTopicsResponse.newBuilder().setNextPageToken("").addAllTopics(Arrays.asList(responsesElement)).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        AdminServiceClient.ListTopicsPagedResponse pagedListResponse = this.client.listTopics(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTopicsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicsRequest actualRequest = (ListTopicsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listTopics(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateTopicTest() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartitionConfig(Topic.PartitionConfig.newBuilder().build()).setRetentionConfig(Topic.RetentionConfig.newBuilder().build()).setReservationConfig(Topic.ReservationConfig.newBuilder().build()).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        Topic topic = Topic.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Topic actualResponse = this.client.updateTopic(topic, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateTopicRequest actualRequest = (UpdateTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            Topic topic = Topic.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateTopic(topic, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTopicTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        TopicName name = TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]");
        this.client.deleteTopic(name);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTopicRequest actualRequest = (DeleteTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            TopicName name = TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]");
            this.client.deleteTopic(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTopicTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteTopic(name);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTopicRequest actualRequest = (DeleteTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTopicExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteTopic(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSubscriptionsTest() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListTopicSubscriptionsResponse expectedResponse = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        TopicName name = TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]");
        AdminServiceClient.ListTopicSubscriptionsPagedResponse pagedListResponse = this.client.listTopicSubscriptions(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicSubscriptionsRequest actualRequest = (ListTopicSubscriptionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicSubscriptionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            TopicName name = TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]");
            this.client.listTopicSubscriptions(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSubscriptionsTest2() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListTopicSubscriptionsResponse expectedResponse = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AdminServiceClient.ListTopicSubscriptionsPagedResponse pagedListResponse = this.client.listTopicSubscriptions(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicSubscriptionsRequest actualRequest = (ListTopicSubscriptionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicSubscriptionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listTopicSubscriptions(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSubscriptionTest() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setDeliveryConfig(Subscription.DeliveryConfig.newBuilder().build()).setExportConfig(ExportConfig.newBuilder().build()).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Subscription subscription = Subscription.newBuilder().build();
        String subscriptionId = "subscriptionId1478790936";
        Subscription actualResponse = this.client.createSubscription(parent, subscription, subscriptionId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSubscriptionRequest actualRequest = (CreateSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertEquals((Object)subscriptionId, (Object)actualRequest.getSubscriptionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Subscription subscription = Subscription.newBuilder().build();
            String subscriptionId = "subscriptionId1478790936";
            this.client.createSubscription(parent, subscription, subscriptionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSubscriptionTest2() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setDeliveryConfig(Subscription.DeliveryConfig.newBuilder().build()).setExportConfig(ExportConfig.newBuilder().build()).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Subscription subscription = Subscription.newBuilder().build();
        String subscriptionId = "subscriptionId1478790936";
        Subscription actualResponse = this.client.createSubscription(parent, subscription, subscriptionId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSubscriptionRequest actualRequest = (CreateSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertEquals((Object)subscriptionId, (Object)actualRequest.getSubscriptionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSubscriptionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Subscription subscription = Subscription.newBuilder().build();
            String subscriptionId = "subscriptionId1478790936";
            this.client.createSubscription(parent, subscription, subscriptionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubscriptionTest() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setDeliveryConfig(Subscription.DeliveryConfig.newBuilder().build()).setExportConfig(ExportConfig.newBuilder().build()).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]");
        Subscription actualResponse = this.client.getSubscription(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSubscriptionRequest actualRequest = (GetSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]");
            this.client.getSubscription(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubscriptionTest2() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setDeliveryConfig(Subscription.DeliveryConfig.newBuilder().build()).setExportConfig(ExportConfig.newBuilder().build()).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Subscription actualResponse = this.client.getSubscription(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSubscriptionRequest actualRequest = (GetSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSubscriptionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSubscription(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSubscriptionsTest() throws Exception {
        Subscription responsesElement = Subscription.newBuilder().build();
        ListSubscriptionsResponse expectedResponse = ListSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        AdminServiceClient.ListSubscriptionsPagedResponse pagedListResponse = this.client.listSubscriptions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSubscriptionsRequest actualRequest = (ListSubscriptionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSubscriptionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listSubscriptions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSubscriptionsTest2() throws Exception {
        Subscription responsesElement = Subscription.newBuilder().build();
        ListSubscriptionsResponse expectedResponse = ListSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        AdminServiceClient.ListSubscriptionsPagedResponse pagedListResponse = this.client.listSubscriptions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSubscriptionsRequest actualRequest = (ListSubscriptionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSubscriptionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSubscriptions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSubscriptionTest() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setDeliveryConfig(Subscription.DeliveryConfig.newBuilder().build()).setExportConfig(ExportConfig.newBuilder().build()).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        Subscription subscription = Subscription.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Subscription actualResponse = this.client.updateSubscription(subscription, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSubscriptionRequest actualRequest = (UpdateSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            Subscription subscription = Subscription.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateSubscription(subscription, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSubscriptionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]");
        this.client.deleteSubscription(name);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSubscriptionRequest actualRequest = (DeleteSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]");
            this.client.deleteSubscription(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSubscriptionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteSubscription(name);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSubscriptionRequest actualRequest = (DeleteSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSubscriptionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteSubscription(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void seekSubscriptionTest() throws Exception {
        SeekSubscriptionResponse expectedResponse = SeekSubscriptionResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("seekSubscriptionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAdminService.addResponse((AbstractMessage)resultOperation);
        SeekSubscriptionRequest request = SeekSubscriptionRequest.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]").toString()).build();
        SeekSubscriptionResponse actualResponse = (SeekSubscriptionResponse)this.client.seekSubscriptionAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SeekSubscriptionRequest actualRequest = (SeekSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getNamedTarget(), (Object)actualRequest.getNamedTarget());
        Assert.assertEquals((Object)request.getTimeTarget(), (Object)actualRequest.getTimeTarget());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void seekSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            SeekSubscriptionRequest request = SeekSubscriptionRequest.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]").toString()).build();
            this.client.seekSubscriptionAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createReservationTest() throws Exception {
        Reservation expectedResponse = Reservation.newBuilder().setName(ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]").toString()).setThroughputCapacity(-1174790353L).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Reservation reservation = Reservation.newBuilder().build();
        String reservationId = "reservationId1116965383";
        Reservation actualResponse = this.client.createReservation(parent, reservation, reservationId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateReservationRequest actualRequest = (CreateReservationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)reservation, (Object)actualRequest.getReservation());
        Assert.assertEquals((Object)reservationId, (Object)actualRequest.getReservationId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReservationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Reservation reservation = Reservation.newBuilder().build();
            String reservationId = "reservationId1116965383";
            this.client.createReservation(parent, reservation, reservationId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createReservationTest2() throws Exception {
        Reservation expectedResponse = Reservation.newBuilder().setName(ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]").toString()).setThroughputCapacity(-1174790353L).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Reservation reservation = Reservation.newBuilder().build();
        String reservationId = "reservationId1116965383";
        Reservation actualResponse = this.client.createReservation(parent, reservation, reservationId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateReservationRequest actualRequest = (CreateReservationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)reservation, (Object)actualRequest.getReservation());
        Assert.assertEquals((Object)reservationId, (Object)actualRequest.getReservationId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReservationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Reservation reservation = Reservation.newBuilder().build();
            String reservationId = "reservationId1116965383";
            this.client.createReservation(parent, reservation, reservationId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getReservationTest() throws Exception {
        Reservation expectedResponse = Reservation.newBuilder().setName(ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]").toString()).setThroughputCapacity(-1174790353L).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        ReservationName name = ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]");
        Reservation actualResponse = this.client.getReservation(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetReservationRequest actualRequest = (GetReservationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getReservationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            ReservationName name = ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]");
            this.client.getReservation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getReservationTest2() throws Exception {
        Reservation expectedResponse = Reservation.newBuilder().setName(ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]").toString()).setThroughputCapacity(-1174790353L).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Reservation actualResponse = this.client.getReservation(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetReservationRequest actualRequest = (GetReservationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getReservationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getReservation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listReservationsTest() throws Exception {
        Reservation responsesElement = Reservation.newBuilder().build();
        ListReservationsResponse expectedResponse = ListReservationsResponse.newBuilder().setNextPageToken("").addAllReservations(Arrays.asList(responsesElement)).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        AdminServiceClient.ListReservationsPagedResponse pagedListResponse = this.client.listReservations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getReservationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListReservationsRequest actualRequest = (ListReservationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listReservationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listReservations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listReservationsTest2() throws Exception {
        Reservation responsesElement = Reservation.newBuilder().build();
        ListReservationsResponse expectedResponse = ListReservationsResponse.newBuilder().setNextPageToken("").addAllReservations(Arrays.asList(responsesElement)).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        AdminServiceClient.ListReservationsPagedResponse pagedListResponse = this.client.listReservations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getReservationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListReservationsRequest actualRequest = (ListReservationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listReservationsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listReservations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateReservationTest() throws Exception {
        Reservation expectedResponse = Reservation.newBuilder().setName(ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]").toString()).setThroughputCapacity(-1174790353L).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        Reservation reservation = Reservation.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Reservation actualResponse = this.client.updateReservation(reservation, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateReservationRequest actualRequest = (UpdateReservationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)reservation, (Object)actualRequest.getReservation());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateReservationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            Reservation reservation = Reservation.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateReservation(reservation, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteReservationTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        ReservationName name = ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]");
        this.client.deleteReservation(name);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteReservationRequest actualRequest = (DeleteReservationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteReservationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            ReservationName name = ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]");
            this.client.deleteReservation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteReservationTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteReservation(name);
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteReservationRequest actualRequest = (DeleteReservationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteReservationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteReservation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listReservationTopicsTest() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListReservationTopicsResponse expectedResponse = ListReservationTopicsResponse.newBuilder().setNextPageToken("").addAllTopics(Arrays.asList(responsesElement)).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        ReservationName name = ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]");
        AdminServiceClient.ListReservationTopicsPagedResponse pagedListResponse = this.client.listReservationTopics(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getTopicsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListReservationTopicsRequest actualRequest = (ListReservationTopicsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listReservationTopicsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            ReservationName name = ReservationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESERVATION]");
            this.client.listReservationTopics(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listReservationTopicsTest2() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListReservationTopicsResponse expectedResponse = ListReservationTopicsResponse.newBuilder().setNextPageToken("").addAllTopics(Arrays.asList(responsesElement)).build();
        mockAdminService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AdminServiceClient.ListReservationTopicsPagedResponse pagedListResponse = this.client.listReservationTopics(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getTopicsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAdminService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListReservationTopicsRequest actualRequest = (ListReservationTopicsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listReservationTopicsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAdminService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listReservationTopics(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

