/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsublite.proto.CommitCursorRequest;
import com.google.cloud.pubsublite.proto.CommitCursorResponse;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsRequest;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsResponse;
import com.google.cloud.pubsublite.proto.PartitionCursor;
import com.google.cloud.pubsublite.proto.StreamingCommitCursorRequest;
import com.google.cloud.pubsublite.proto.StreamingCommitCursorResponse;
import com.google.cloud.pubsublite.proto.SubscriptionName;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.CursorServiceSettings;
import com.google.cloud.pubsublite.v1.MockCursorService;
import com.google.protobuf.AbstractMessage;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CursorServiceClientTest {
    private static MockCursorService mockCursorService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private CursorServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockCursorService = new MockCursorService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockCursorService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        CursorServiceSettings settings = ((CursorServiceSettings.Builder)((CursorServiceSettings.Builder)CursorServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = CursorServiceClient.create((CursorServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void streamingCommitCursorTest() throws Exception {
        StreamingCommitCursorResponse expectedResponse = StreamingCommitCursorResponse.newBuilder().build();
        mockCursorService.addResponse((AbstractMessage)expectedResponse);
        StreamingCommitCursorRequest request = StreamingCommitCursorRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.streamingCommitCursorCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void streamingCommitCursorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCursorService.addException((Exception)exception);
        StreamingCommitCursorRequest request = StreamingCommitCursorRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.streamingCommitCursorCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void commitCursorTest() throws Exception {
        CommitCursorResponse expectedResponse = CommitCursorResponse.newBuilder().build();
        mockCursorService.addResponse((AbstractMessage)expectedResponse);
        CommitCursorRequest request = CommitCursorRequest.newBuilder().setSubscription("subscription341203229").setPartition(-1799810326L).setCursor(Cursor.newBuilder().build()).build();
        CommitCursorResponse actualResponse = this.client.commitCursor(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCursorService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitCursorRequest actualRequest = (CommitCursorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSubscription(), (Object)actualRequest.getSubscription());
        Assert.assertEquals((long)request.getPartition(), (long)actualRequest.getPartition());
        Assert.assertEquals((Object)request.getCursor(), (Object)actualRequest.getCursor());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitCursorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCursorService.addException((Exception)exception);
        try {
            CommitCursorRequest request = CommitCursorRequest.newBuilder().setSubscription("subscription341203229").setPartition(-1799810326L).setCursor(Cursor.newBuilder().build()).build();
            this.client.commitCursor(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPartitionCursorsTest() throws Exception {
        PartitionCursor responsesElement = PartitionCursor.newBuilder().build();
        ListPartitionCursorsResponse expectedResponse = ListPartitionCursorsResponse.newBuilder().setNextPageToken("").addAllPartitionCursors(Arrays.asList(responsesElement)).build();
        mockCursorService.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName parent = SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]");
        CursorServiceClient.ListPartitionCursorsPagedResponse pagedListResponse = this.client.listPartitionCursors(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPartitionCursorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCursorService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPartitionCursorsRequest actualRequest = (ListPartitionCursorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPartitionCursorsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCursorService.addException((Exception)exception);
        try {
            SubscriptionName parent = SubscriptionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SUBSCRIPTION]");
            this.client.listPartitionCursors(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPartitionCursorsTest2() throws Exception {
        PartitionCursor responsesElement = PartitionCursor.newBuilder().build();
        ListPartitionCursorsResponse expectedResponse = ListPartitionCursorsResponse.newBuilder().setNextPageToken("").addAllPartitionCursors(Arrays.asList(responsesElement)).build();
        mockCursorService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        CursorServiceClient.ListPartitionCursorsPagedResponse pagedListResponse = this.client.listPartitionCursors(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPartitionCursorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCursorService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPartitionCursorsRequest actualRequest = (ListPartitionCursorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPartitionCursorsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCursorService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listPartitionCursors(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

