/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsublite.proto.PublishRequest;
import com.google.cloud.pubsublite.proto.PublishResponse;
import com.google.cloud.pubsublite.v1.MockPublisherService;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.cloud.pubsublite.v1.PublisherServiceSettings;
import com.google.protobuf.AbstractMessage;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PublisherServiceClientTest {
    private static MockPublisherService mockPublisherService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private PublisherServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockPublisherService = new MockPublisherService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockPublisherService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        PublisherServiceSettings settings = ((PublisherServiceSettings.Builder)((PublisherServiceSettings.Builder)PublisherServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = PublisherServiceClient.create((PublisherServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void publishTest() throws Exception {
        PublishResponse expectedResponse = PublishResponse.newBuilder().build();
        mockPublisherService.addResponse((AbstractMessage)expectedResponse);
        PublishRequest request = PublishRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.publishCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void publishExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisherService.addException((Exception)exception);
        PublishRequest request = PublishRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.publishCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

