/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsublite.proto.ComputeHeadCursorRequest;
import com.google.cloud.pubsublite.proto.ComputeHeadCursorResponse;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import com.google.cloud.pubsublite.proto.ComputeTimeCursorRequest;
import com.google.cloud.pubsublite.proto.ComputeTimeCursorResponse;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.TimeTarget;
import com.google.cloud.pubsublite.proto.TopicName;
import com.google.cloud.pubsublite.v1.MockTopicStatsService;
import com.google.cloud.pubsublite.v1.TopicStatsServiceClient;
import com.google.cloud.pubsublite.v1.TopicStatsServiceSettings;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Timestamp;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TopicStatsServiceClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockTopicStatsService mockTopicStatsService;
    private LocalChannelProvider channelProvider;
    private TopicStatsServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockTopicStatsService = new MockTopicStatsService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockTopicStatsService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        TopicStatsServiceSettings settings = ((TopicStatsServiceSettings.Builder)((TopicStatsServiceSettings.Builder)TopicStatsServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = TopicStatsServiceClient.create((TopicStatsServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void computeMessageStatsTest() throws Exception {
        ComputeMessageStatsResponse expectedResponse = ComputeMessageStatsResponse.newBuilder().setMessageCount(-1229303081L).setMessageBytes(-1229929933L).setMinimumPublishTime(Timestamp.newBuilder().build()).setMinimumEventTime(Timestamp.newBuilder().build()).build();
        mockTopicStatsService.addResponse((AbstractMessage)expectedResponse);
        ComputeMessageStatsRequest request = ComputeMessageStatsRequest.newBuilder().setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartition(-1799810326L).setStartCursor(Cursor.newBuilder().build()).setEndCursor(Cursor.newBuilder().build()).build();
        ComputeMessageStatsResponse actualResponse = this.client.computeMessageStats(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTopicStatsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ComputeMessageStatsRequest actualRequest = (ComputeMessageStatsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getTopic(), (Object)actualRequest.getTopic());
        Assert.assertEquals((long)request.getPartition(), (long)actualRequest.getPartition());
        Assert.assertEquals((Object)request.getStartCursor(), (Object)actualRequest.getStartCursor());
        Assert.assertEquals((Object)request.getEndCursor(), (Object)actualRequest.getEndCursor());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void computeMessageStatsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTopicStatsService.addException((Exception)exception);
        try {
            ComputeMessageStatsRequest request = ComputeMessageStatsRequest.newBuilder().setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartition(-1799810326L).setStartCursor(Cursor.newBuilder().build()).setEndCursor(Cursor.newBuilder().build()).build();
            this.client.computeMessageStats(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void computeHeadCursorTest() throws Exception {
        ComputeHeadCursorResponse expectedResponse = ComputeHeadCursorResponse.newBuilder().setHeadCursor(Cursor.newBuilder().build()).build();
        mockTopicStatsService.addResponse((AbstractMessage)expectedResponse);
        ComputeHeadCursorRequest request = ComputeHeadCursorRequest.newBuilder().setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartition(-1799810326L).build();
        ComputeHeadCursorResponse actualResponse = this.client.computeHeadCursor(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTopicStatsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ComputeHeadCursorRequest actualRequest = (ComputeHeadCursorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getTopic(), (Object)actualRequest.getTopic());
        Assert.assertEquals((long)request.getPartition(), (long)actualRequest.getPartition());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void computeHeadCursorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTopicStatsService.addException((Exception)exception);
        try {
            ComputeHeadCursorRequest request = ComputeHeadCursorRequest.newBuilder().setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartition(-1799810326L).build();
            this.client.computeHeadCursor(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void computeTimeCursorTest() throws Exception {
        ComputeTimeCursorResponse expectedResponse = ComputeTimeCursorResponse.newBuilder().setCursor(Cursor.newBuilder().build()).build();
        mockTopicStatsService.addResponse((AbstractMessage)expectedResponse);
        ComputeTimeCursorRequest request = ComputeTimeCursorRequest.newBuilder().setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartition(-1799810326L).setTarget(TimeTarget.newBuilder().build()).build();
        ComputeTimeCursorResponse actualResponse = this.client.computeTimeCursor(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTopicStatsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ComputeTimeCursorRequest actualRequest = (ComputeTimeCursorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getTopic(), (Object)actualRequest.getTopic());
        Assert.assertEquals((long)request.getPartition(), (long)actualRequest.getPartition());
        Assert.assertEquals((Object)request.getTarget(), (Object)actualRequest.getTarget());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void computeTimeCursorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTopicStatsService.addException((Exception)exception);
        try {
            ComputeTimeCursorRequest request = ComputeTimeCursorRequest.newBuilder().setTopic(TopicName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TOPIC]").toString()).setPartition(-1799810326L).setTarget(TimeTarget.newBuilder().build()).build();
            this.client.computeTimeCursor(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

