/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.testing.junit4;

import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public final class MultipleAttemptsRule
implements TestRule {
    private final long initialBackoffMillis;
    private final int maxAttemptCount;

    public MultipleAttemptsRule(int maxAttemptCount) {
        this(maxAttemptCount, 1000L);
    }

    public MultipleAttemptsRule(int maxAttemptCount, long initialBackoffMillis) {
        Preconditions.checkArgument((maxAttemptCount > 0 ? 1 : 0) != 0, (Object)"attemptCount must be > 0");
        Preconditions.checkArgument((initialBackoffMillis >= 0L ? 1 : 0) != 0, (Object)"initialBackoffMillis must be >= 0");
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxAttemptCount = maxAttemptCount;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> failures = new ArrayList<Throwable>();
                long retryIntervalMillis = MultipleAttemptsRule.this.initialBackoffMillis;
                for (int i = 1; i <= MultipleAttemptsRule.this.maxAttemptCount; ++i) {
                    try {
                        base.evaluate();
                        return;
                    }
                    catch (Throwable t) {
                        failures.add(t);
                        Thread.sleep(retryIntervalMillis);
                        retryIntervalMillis = (long)((float)retryIntervalMillis * 1.5f);
                        continue;
                    }
                }
                MultipleFailureException.assertEmpty(failures);
            }
        };
    }
}

