/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.testing.junit4.tests;

import com.google.cloud.testing.junit4.MultipleAttemptsRule;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public final class MultipleAttemptsRuleTest {
    private static final int NUMBER_OF_ATTEMPTS = 5;
    @Rule
    public MultipleAttemptsRule rr = new MultipleAttemptsRule(5, 0L);
    private int numberAttempted = 0;

    @Test
    public void wontPassUntil5() {
        ++this.numberAttempted;
        Assert.assertEquals((long)5L, (long)this.numberAttempted);
    }

    @Test(expected=IllegalArgumentException.class)
    public void errorConstructing_attemptLessThan1() {
        new MultipleAttemptsRule(0);
    }

    @Test
    public void errorConstructing_attemptEquals1() {
        new MultipleAttemptsRule(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void errorConstructing_attemptGreaterThanOrEqualTo1AndBackoffLessThan0() {
        new MultipleAttemptsRule(1, -1L);
    }

    @Test
    public void errorConstructing_attemptGreaterThanOrEqualTo1AndBackoffEqualTo0() {
        new MultipleAttemptsRule(1, 0L);
    }

    @Test
    public void allErrorPropagated() {
        MultipleAttemptsRule rule = new MultipleAttemptsRule(3, 0L);
        Statement statement = rule.apply(new Statement(){
            private int counter = 1;

            public void evaluate() {
                Assert.fail((String)("attempt " + this.counter++));
            }
        }, null);
        try {
            statement.evaluate();
        }
        catch (MultipleFailureException mfe) {
            Truth.assertThat((Iterable)mfe.getFailures()).hasSize(3);
        }
        catch (Throwable throwable) {
            Assert.fail((String)("unexpected error: " + throwable.getMessage()));
        }
    }
}

