/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.datastore.v1.client.ChecksumEnforcingInputStream;
import com.google.datastore.v1.client.EndToEndChecksumHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ChecksumEnforcingInputStreamTest {
    public void test(int payloadSize) throws Exception {
        try (ChecksumEnforcingInputStream testInstance = this.setUpData(payloadSize);){
            byte[] buf = new byte[1000];
            while (testInstance.read(buf, 0, 1000) != -1) {
            }
        }
        catch (IOException e) {
            Assert.fail((String)("checksum verification failed! " + e.getMessage()));
        }
    }

    @Test
    public void read_withValidChecksum_differentPayloadSizes() throws Exception {
        int payloadSize = 1;
        for (int i = 0; i < 29; ++i) {
            long start = System.currentTimeMillis();
            this.test(payloadSize);
            payloadSize *= 2;
            long duration = System.currentTimeMillis() - start;
            if (i <= 20) continue;
            System.out.println("Test duration for payloadsize = 2** " + i + " is: " + duration + "ms");
        }
    }

    @Test
    public void read_withInvalidChecksum() {
        try (ChecksumEnforcingInputStream instance = new ChecksumEnforcingInputStream((InputStream)new ByteArrayInputStream("hello there".getBytes(StandardCharsets.UTF_8)), "this checksum is invalid");){
            byte[] buf = new byte[1000];
            while (instance.read(buf, 0, 1000) != -1) {
            }
        }
        catch (IOException e) {
            return;
        }
        Assert.fail((String)"should have failed");
    }

    @Test
    public void markNotSupported() throws Exception {
        try (ChecksumEnforcingInputStream testInstance = this.setUpData(1);){
            Assert.assertFalse((boolean)testInstance.markSupported());
        }
    }

    private ChecksumEnforcingInputStream setUpData(int payloadSize) throws Exception {
        String payload;
        String str = "This is a repeating string.";
        if (payloadSize > str.length()) {
            int num = payloadSize / str.length();
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < num; ++i) {
                buf.append(str);
            }
            payload = buf.toString();
        } else {
            payload = str.substring(0, payloadSize);
        }
        byte[] bytes = payload.getBytes(StandardCharsets.UTF_8);
        String expectedChecksum = EndToEndChecksumHandler.computeChecksum((byte[])bytes);
        return new ChecksumEnforcingInputStream((InputStream)new ByteArrayInputStream(bytes), expectedChecksum);
    }
}

