/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.QueryResultBatch;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.DatastoreFactory;
import com.google.datastore.v1.client.DatastoreOptions;
import com.google.datastore.v1.client.testing.MockCredential;
import com.google.datastore.v1.client.testing.MockDatastoreFactory;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.rpc.Code;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DatastoreClientTest {
    private static final String PROJECT_ID = "project-id";
    private DatastoreFactory factory = new MockDatastoreFactory();
    private DatastoreOptions.Builder options = new DatastoreOptions.Builder().projectId("project-id").credential((Credential)new MockCredential());

    @Test
    public void options_NoProjectIdOrProjectEndpoint() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.factory.create(new DatastoreOptions.Builder().build()));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Either project ID or project endpoint must be provided");
        this.factory.create(this.options.build());
    }

    @Test
    public void options_ProjectIdAndProjectEndpoint() throws Exception {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new DatastoreOptions.Builder().projectId(PROJECT_ID).projectEndpoint("http://localhost:1234/datastore/v1beta42/projects/project-id"));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Cannot set both project endpoint and project ID");
    }

    @Test
    public void options_LocalHostAndProjectEndpoint() throws Exception {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new DatastoreOptions.Builder().localHost("localhost:8080").projectEndpoint("http://localhost:1234/datastore/v1beta42/projects/project-id"));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Can set at most one of project endpoint, host, and local host");
    }

    @Test
    public void options_HostAndProjectEndpoint() throws Exception {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new DatastoreOptions.Builder().host("foo-datastore.googleapis.com").projectEndpoint("http://localhost:1234/datastore/v1beta42/projects/project-id"));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Can set at most one of project endpoint, host, and local host");
    }

    @Test
    public void options_HostAndLocalHost() throws Exception {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new DatastoreOptions.Builder().host("foo-datastore.googleapis.com").localHost("localhost:8080"));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Can set at most one of project endpoint, host, and local host");
    }

    @Test
    public void options_InvalidLocalHost() throws Exception {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.factory.create(new DatastoreOptions.Builder().projectId(PROJECT_ID).localHost("!not a valid url!").build()));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Illegal character");
    }

    @Test
    public void options_SchemeInLocalHost() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new DatastoreOptions.Builder().localHost("http://localhost:8080"));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Local host \"http://localhost:8080\" must not include scheme");
    }

    @Test
    public void options_InvalidHost() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.factory.create(new DatastoreOptions.Builder().projectId(PROJECT_ID).host("!not a valid url!").build()));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Illegal character");
    }

    @Test
    public void options_SchemeInHost() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new DatastoreOptions.Builder().host("http://foo-datastore.googleapis.com"));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Host \"http://foo-datastore.googleapis.com\" must not include scheme.");
    }

    @Test
    public void create_NullOptions() throws Exception {
        Assert.assertThrows(NullPointerException.class, () -> this.factory.create(null));
    }

    @Test
    public void create_Host() {
        Datastore datastore = this.factory.create(new DatastoreOptions.Builder().projectId(PROJECT_ID).host("foo-datastore.googleapis.com").build());
        Truth.assertThat((String)datastore.remoteRpc.getUrl()).isEqualTo((Object)"https://foo-datastore.googleapis.com/v1/projects/project-id");
    }

    @Test
    public void create_LocalHost() {
        Datastore datastore = this.factory.create(new DatastoreOptions.Builder().projectId(PROJECT_ID).localHost("localhost:8080").build());
        Truth.assertThat((String)datastore.remoteRpc.getUrl()).isEqualTo((Object)"http://localhost:8080/v1/projects/project-id");
    }

    @Test
    public void create_LocalHostIp() {
        Datastore datastore = this.factory.create(new DatastoreOptions.Builder().projectId(PROJECT_ID).localHost("127.0.0.1:8080").build());
        Truth.assertThat((String)datastore.remoteRpc.getUrl()).isEqualTo((Object)"http://127.0.0.1:8080/v1/projects/project-id");
    }

    @Test
    public void create_DefaultHost() {
        Datastore datastore = this.factory.create(new DatastoreOptions.Builder().projectId(PROJECT_ID).build());
        Truth.assertThat((String)datastore.remoteRpc.getUrl()).isEqualTo((Object)"https://datastore.googleapis.com/v1/projects/project-id");
    }

    @Test
    public void create_ProjectEndpoint() {
        Datastore datastore = this.factory.create(new DatastoreOptions.Builder().projectEndpoint("http://prom-qa/datastore/v1beta42/projects/project-id").build());
        Truth.assertThat((String)datastore.remoteRpc.getUrl()).isEqualTo((Object)"http://prom-qa/datastore/v1beta42/projects/project-id");
    }

    @Test
    public void create_ProjectEndpointNoScheme() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.factory.create(new DatastoreOptions.Builder().projectEndpoint("localhost:1234/datastore/v1beta42/projects/project-id").build()));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Project endpoint \"localhost:1234/datastore/v1beta42/projects/project-id\" must include scheme.");
    }

    @Test
    public void initializer() throws Exception {
        this.options.initializer(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.getHeaders().setCookie("magic");
            }
        });
        Datastore datastore = this.factory.create(this.options.build());
        MockDatastoreFactory mockClient = (MockDatastoreFactory)this.factory;
        AllocateIdsRequest request = AllocateIdsRequest.newBuilder().build();
        AllocateIdsResponse response = AllocateIdsResponse.newBuilder().build();
        mockClient.setNextResponse((Message)response);
        Assert.assertEquals((Object)response, (Object)datastore.allocateIds(request));
        Assert.assertEquals((Object)"magic", mockClient.getLastCookies().get(0));
    }

    @Test
    public void allocateIds() throws Exception {
        AllocateIdsRequest.Builder request = AllocateIdsRequest.newBuilder();
        AllocateIdsResponse.Builder response = AllocateIdsResponse.newBuilder();
        this.expectRpc("allocateIds", (Message)request.build(), (Message)response.build());
    }

    @Test
    public void lookup() throws Exception {
        LookupRequest.Builder request = LookupRequest.newBuilder();
        LookupResponse.Builder response = LookupResponse.newBuilder();
        this.expectRpc("lookup", (Message)request.build(), (Message)response.build());
    }

    @Test
    public void beginTransaction() throws Exception {
        BeginTransactionRequest.Builder request = BeginTransactionRequest.newBuilder();
        BeginTransactionResponse.Builder response = BeginTransactionResponse.newBuilder();
        response.setTransaction(ByteString.copyFromUtf8((String)PROJECT_ID));
        this.expectRpc("beginTransaction", (Message)request.build(), (Message)response.build());
    }

    @Test
    public void commit() throws Exception {
        CommitRequest.Builder request = CommitRequest.newBuilder();
        request.setTransaction(ByteString.copyFromUtf8((String)PROJECT_ID));
        CommitResponse.Builder response = CommitResponse.newBuilder();
        this.expectRpc("commit", (Message)request.build(), (Message)response.build());
    }

    @Test
    public void reserveIds() throws Exception {
        ReserveIdsRequest.Builder request = ReserveIdsRequest.newBuilder();
        ReserveIdsResponse.Builder response = ReserveIdsResponse.newBuilder();
        this.expectRpc("reserveIds", (Message)request.build(), (Message)response.build());
    }

    @Test
    public void rollback() throws Exception {
        RollbackRequest.Builder request = RollbackRequest.newBuilder();
        request.setTransaction(ByteString.copyFromUtf8((String)PROJECT_ID));
        RollbackResponse.Builder response = RollbackResponse.newBuilder();
        this.expectRpc("rollback", (Message)request.build(), (Message)response.build());
    }

    @Test
    public void runQuery() throws Exception {
        RunQueryRequest.Builder request = RunQueryRequest.newBuilder();
        request.getQueryBuilder();
        RunQueryResponse.Builder response = RunQueryResponse.newBuilder();
        response.getBatchBuilder().setEntityResultType(EntityResult.ResultType.FULL).setMoreResults(QueryResultBatch.MoreResultsType.NOT_FINISHED);
        this.expectRpc("runQuery", (Message)request.build(), (Message)response.build());
    }

    private void expectRpc(String methodName, Message request, Message response) throws Exception {
        Datastore datastore = this.factory.create(this.options.build());
        MockDatastoreFactory mockClient = (MockDatastoreFactory)this.factory;
        mockClient.setNextResponse(response);
        Class[] methodArgs = new Class[]{request.getClass()};
        Method call = Datastore.class.getMethod(methodName, methodArgs);
        Object[] callArgs = new Object[]{request};
        Assert.assertEquals((Object)response, (Object)call.invoke((Object)datastore, callArgs));
        Assert.assertEquals((Object)("/v1/projects/project-id:" + methodName), (Object)mockClient.getLastPath());
        Assert.assertEquals((Object)"application/x-protobuf", (Object)mockClient.getLastMimeType());
        Assert.assertEquals((Object)"2", (Object)mockClient.getLastApiFormatHeaderValue());
        Assert.assertArrayEquals((byte[])request.toByteArray(), (byte[])mockClient.getLastBody());
        Assert.assertEquals((long)1L, (long)datastore.getRpcCount());
        datastore.resetRpcCount();
        Assert.assertEquals((long)0L, (long)datastore.getRpcCount());
        mockClient.setNextError(400, Code.INVALID_ARGUMENT, "oops");
        try {
            call.invoke((Object)datastore, callArgs);
            Assert.fail();
        }
        catch (InvocationTargetException targetException) {
            DatastoreException exception = (DatastoreException)targetException.getCause();
            Assert.assertEquals((Object)Code.INVALID_ARGUMENT, (Object)exception.getCode());
            Assert.assertEquals((Object)methodName, (Object)exception.getMethodName());
            Assert.assertEquals((Object)"oops", (Object)exception.getMessage());
        }
        SocketTimeoutException socketTimeoutException = new SocketTimeoutException("ste");
        mockClient.setNextException((IOException)socketTimeoutException);
        try {
            call.invoke((Object)datastore, callArgs);
            Assert.fail();
        }
        catch (InvocationTargetException targetException) {
            DatastoreException exception = (DatastoreException)targetException.getCause();
            Assert.assertEquals((Object)Code.DEADLINE_EXCEEDED, (Object)exception.getCode());
            Assert.assertEquals((Object)methodName, (Object)exception.getMethodName());
            Assert.assertEquals((Object)"Deadline exceeded", (Object)exception.getMessage());
            Assert.assertSame((Object)socketTimeoutException, (Object)exception.getCause());
        }
        IOException ioException = new IOException("ioe");
        mockClient.setNextException(ioException);
        try {
            call.invoke((Object)datastore, callArgs);
            Assert.fail();
        }
        catch (InvocationTargetException targetException) {
            DatastoreException exception = (DatastoreException)targetException.getCause();
            Assert.assertEquals((Object)Code.UNAVAILABLE, (Object)exception.getCode());
            Assert.assertEquals((Object)methodName, (Object)exception.getMethodName());
            Assert.assertEquals((Object)"I/O error", (Object)exception.getMessage());
            Assert.assertSame((Object)ioException, (Object)exception.getCause());
        }
        Assert.assertEquals((long)3L, (long)datastore.getRpcCount());
    }
}

