/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.datastore.v1.client.DatastoreEmulator;
import com.google.datastore.v1.client.DatastoreEmulatorException;
import com.google.datastore.v1.client.DatastoreEmulatorOptions;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DatastoreEmulatorTest {
    private static final DatastoreEmulatorOptions options = new DatastoreEmulatorOptions.Builder().build();

    @Test
    public void testArgs() throws DatastoreEmulatorException {
        DatastoreEmulator datastore = new DatastoreEmulator(null, "blar", options){

            void startEmulatorInternal(String emulatorDir, String projectId, List<String> cmdLineOpts) {
            }
        };
        try {
            datastore.start(null, "projectId", new String[0]);
            Assert.fail((String)"expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            datastore.start("path/to/emulator", null, new String[0]);
            Assert.fail((String)"expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        datastore.start("path/to/emulator", "projectId", new String[0]);
    }

    @Test
    public void testLifecycle() throws DatastoreEmulatorException {
        DatastoreEmulator datastore = new DatastoreEmulator(null, "blar", options){

            void startEmulatorInternal(String emulatorDir, String projectId, List<String> cmdLineOpts) {
            }

            protected void stopEmulatorInternal() {
            }
        };
        String emulatorDir = "/yar";
        String myProject = "myproject";
        datastore.start(emulatorDir, myProject, new String[0]);
        try {
            datastore.start(emulatorDir, myProject, new String[0]);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        datastore.stop();
        datastore.stop();
        try {
            datastore.start(emulatorDir, myProject, new String[0]);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

