/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.datastore.v1.client.DatastoreFactory;
import com.google.datastore.v1.client.DatastoreOptions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DatastoreFactoryTest {
    private static final String PROJECT_ID = "project-id";
    private DatastoreFactory factory = DatastoreFactory.get();

    @Test
    public void makeClient_Default() {
        DatastoreOptions options = new DatastoreOptions.Builder().projectId(PROJECT_ID).build();
        HttpRequestFactory f = this.factory.makeClient(options);
        Assert.assertNotNull((Object)f.getTransport());
        Assert.assertTrue((boolean)(f.getTransport() instanceof NetHttpTransport));
    }

    @Test
    public void makeClient_WithCredential() {
        NetHttpTransport transport = new NetHttpTransport();
        GoogleCredential credential = new GoogleCredential.Builder().setTransport((HttpTransport)transport).build();
        DatastoreOptions options = new DatastoreOptions.Builder().projectId(PROJECT_ID).credential((Credential)credential).build();
        HttpRequestFactory f = this.factory.makeClient(options);
        Assert.assertEquals((Object)transport, (Object)f.getTransport());
    }

    @Test
    public void makeClient_WithTransport() {
        NetHttpTransport transport = new NetHttpTransport();
        DatastoreOptions options = new DatastoreOptions.Builder().projectId(PROJECT_ID).transport((HttpTransport)transport).build();
        HttpRequestFactory f = this.factory.makeClient(options);
        Assert.assertEquals((Object)transport, (Object)f.getTransport());
    }

    @Test
    public void makeClient_WithCredentialTransport() {
        NetHttpTransport credTransport = new NetHttpTransport();
        NetHttpTransport transport = new NetHttpTransport();
        GoogleCredential credential = new GoogleCredential.Builder().setTransport((HttpTransport)credTransport).build();
        DatastoreOptions options = new DatastoreOptions.Builder().projectId(PROJECT_ID).credential((Credential)credential).transport((HttpTransport)transport).build();
        HttpRequestFactory f = this.factory.makeClient(options);
        Assert.assertNotSame((Object)credTransport, (Object)f.getTransport());
        Assert.assertEquals((Object)transport, (Object)f.getTransport());
    }
}

