/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.datastore.v1.Key;
import com.google.datastore.v1.PartitionId;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.client.DatastoreHelper;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DatastoreHelperTest {
    private static final Key PARENT = Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Parent").setId(23L)).build();
    private static final Key GRANDPARENT = Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Grandparent").setId(24L)).build();
    private static final Key CHILD = Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Child").setId(26L)).build();

    @Test
    public void testMakeKey_BadTypeForKind() {
        try {
            DatastoreHelper.makeKey((Object[])new Object[]{new Object()});
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMakeKey_BadTypeForNameId() {
        try {
            DatastoreHelper.makeKey((Object[])new Object[]{"kind", new Object()});
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMakeKey_Empty() {
        Assert.assertEquals((Object)Key.newBuilder().build(), (Object)DatastoreHelper.makeKey((Object[])new Object[0]).build());
    }

    @Test
    public void testMakeKey_Incomplete() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Foo")).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{"Foo"}).build());
    }

    @Test
    public void testMakeKey_IdInt() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Foo").setId(1L)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{"Foo", 1}).build());
    }

    @Test
    public void testMakeKey_IdLong() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Foo").setId(1L)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{"Foo", 1L}).build());
    }

    @Test
    public void testMakeKey_IdShort() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Foo").setId(1L)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{"Foo", (short)1}).build());
    }

    @Test
    public void testMakeKey_Name() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Foo").setName("hi")).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{"Foo", "hi"}).build());
    }

    @Test
    public void testMakeKey_KindNameKind() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Foo").setName("hi")).addPath(Key.PathElement.newBuilder().setKind("Bar")).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{"Foo", "hi", "Bar"}).build());
    }

    @Test
    public void testMakeKey_KeyKind() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(PARENT.getPath(0)).addPath(Key.PathElement.newBuilder().setKind("Child")).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{PARENT, "Child"}).build());
    }

    @Test
    public void testMakeKey_KindIdKeyKind() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Grandparent").setId(24L)).addPath(PARENT.getPath(0)).addPath(Key.PathElement.newBuilder().setKind("Child")).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{"Grandparent", 24L, PARENT, "Child"}).build());
    }

    @Test
    public void testMakeKey_KindIdKey() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(Key.PathElement.newBuilder().setKind("Grandparent").setId(24L)).addPath(PARENT.getPath(0)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{"Grandparent", 24L, PARENT}).build());
    }

    @Test
    public void testMakeKey_KeyKindIdKey() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(GRANDPARENT.getPath(0)).addPath(Key.PathElement.newBuilder().setKind("Parent").setId(23L)).addPath(CHILD.getPath(0)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{GRANDPARENT, "Parent", 23, CHILD}).build());
    }

    @Test
    public void testMakeKey_Key() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(CHILD.getPath(0)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{CHILD}).build());
    }

    @Test
    public void testMakeKey_KeyKey() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(PARENT.getPath(0)).addPath(CHILD.getPath(0)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{PARENT, CHILD}).build());
    }

    @Test
    public void testMakeKey_KeyKeyKey() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(GRANDPARENT.getPath(0)).addPath(PARENT.getPath(0)).addPath(CHILD.getPath(0)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{GRANDPARENT, PARENT, CHILD}).build());
    }

    @Test
    public void testMakeKey_KeyMultiLevelKey() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(GRANDPARENT.getPath(0)).addPath(PARENT.getPath(0)).addPath(CHILD.getPath(0)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{GRANDPARENT, DatastoreHelper.makeKey((Object[])new Object[]{PARENT, CHILD}).build()}).build());
    }

    @Test
    public void testMakeKey_MultiLevelKeyKey() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(GRANDPARENT.getPath(0)).addPath(PARENT.getPath(0)).addPath(CHILD.getPath(0)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{DatastoreHelper.makeKey((Object[])new Object[]{GRANDPARENT, PARENT}).build(), CHILD}).build());
    }

    @Test
    public void testMakeKey_MultiLevelKey() {
        Assert.assertEquals((Object)Key.newBuilder().addPath(GRANDPARENT.getPath(0)).addPath(PARENT.getPath(0)).addPath(CHILD.getPath(0)).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{DatastoreHelper.makeKey((Object[])new Object[]{GRANDPARENT, PARENT, CHILD}).build()}).build());
    }

    @Test
    public void testMakeKey_PartitionId() {
        PartitionId partitionId = PartitionId.newBuilder().setNamespaceId("namespace-id").build();
        Key parent = PARENT.toBuilder().setPartitionId(partitionId).build();
        Assert.assertEquals((Object)Key.newBuilder().setPartitionId(partitionId).addPath(PARENT.getPath(0)).addPath(Key.PathElement.newBuilder().setKind("Child")).build(), (Object)DatastoreHelper.makeKey((Object[])new Object[]{parent, "Child"}).build());
    }

    @Test
    public void testMakeKey_NonMatchingPartitionId2() {
        PartitionId partitionId1 = PartitionId.newBuilder().setNamespaceId("namespace-id").build();
        PartitionId partitionId2 = PartitionId.newBuilder().setNamespaceId("another-namespace-id").build();
        try {
            DatastoreHelper.makeKey((Object[])new Object[]{PARENT.toBuilder().setPartitionId(partitionId1).build(), CHILD.toBuilder().setPartitionId(partitionId2).build()});
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMakeTimestampValue() throws Exception {
        this.assertConversion(-50000L, -50L, 0);
        this.assertConversion(-1000L, -1L, 0);
        this.assertConversion(0L, 0L, 0);
        this.assertConversion(1000L, 1L, 0);
        this.assertConversion(2000L, 2L, 0);
        this.assertConversion(100000L, 100L, 0);
        this.assertConversion(2L, 0L, 2000000);
        this.assertConversion(1003L, 1L, 3000000);
        this.assertConversion(2005L, 2L, 5000000);
        this.assertConversion(0L, 0L, 0);
        this.assertConversion(-250L, -1L, 750000000);
        this.assertConversion(-500L, -1L, 500000000);
        this.assertConversion(-750L, -1L, 250000000);
        this.assertTimestampToMilliseconds(3100L, 3L, 100000999);
        this.assertMillisecondsToTimestamp(3100L, 3L, 100000000L);
        this.assertTimestampToMilliseconds(5999L, 5L, 999999999);
        this.assertMillisecondsToTimestamp(5999L, 5L, 999000000L);
        this.assertTimestampToMilliseconds(7100L, 7L, 100000001);
        this.assertMillisecondsToTimestamp(7100L, 7L, 100000000L);
    }

    private void assertConversion(long millis, long seconds, int nanos) {
        this.assertMillisecondsToTimestamp(millis, seconds, nanos);
        this.assertTimestampToMilliseconds(millis, seconds, nanos);
    }

    private void assertMillisecondsToTimestamp(long millis, long seconds, long nanos) {
        Value timestampValue = DatastoreHelper.makeValue((Date)new Date(millis)).build();
        Assert.assertEquals((Object)Value.ValueTypeCase.TIMESTAMP_VALUE, (Object)timestampValue.getValueTypeCase());
        Assert.assertEquals((long)seconds, (long)timestampValue.getTimestampValue().getSeconds());
        Assert.assertEquals((long)nanos, (long)timestampValue.getTimestampValue().getNanos());
    }

    private void assertTimestampToMilliseconds(long millis, long seconds, int nanos) {
        Value.Builder value = Value.newBuilder().setTimestampValue(Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos));
        Assert.assertEquals((long)millis, (long)DatastoreHelper.toDate((Value)value.build()).getTime());
    }

    @Test
    public void testProjectionHandling() {
        Assert.assertEquals((Object)ByteString.copyFromUtf8((String)"hi"), (Object)DatastoreHelper.getByteString((Value)DatastoreHelper.makeValue((String)"hi").setMeaning(18).build()));
        try {
            DatastoreHelper.getByteString((Value)DatastoreHelper.makeValue((String)"hi").build());
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)new Date(1L), (Object)DatastoreHelper.toDate((Value)DatastoreHelper.makeValue((long)1000L).setMeaning(18).build()));
        try {
            DatastoreHelper.toDate((Value)DatastoreHelper.makeValue((long)1000L).build());
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

