/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.datastore.v1.client.EndToEndChecksumHandler;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class EndToEndChecksumHandlerTest {
    private byte[] payloadBytes = "This is a long string with numbers 1234, 134.56 ".getBytes(StandardCharsets.UTF_8);

    @Test
    public void validateChecksum_correctChecksum() {
        String computed = EndToEndChecksumHandler.computeChecksum((byte[])this.payloadBytes);
        Assert.assertTrue((boolean)EndToEndChecksumHandler.validateChecksum((String)computed, (byte[])this.payloadBytes));
    }

    @Test
    public void validateChecksum_incorrectChecksum() {
        String computed = EndToEndChecksumHandler.computeChecksum((byte[])"random string".getBytes(StandardCharsets.UTF_8));
        Assert.assertFalse((boolean)EndToEndChecksumHandler.validateChecksum((String)computed, (byte[])this.payloadBytes));
    }

    @Test
    public void validateChecksum_nullChecksum() {
        Assert.assertFalse((boolean)EndToEndChecksumHandler.validateChecksum(null, (byte[])this.payloadBytes));
    }

    @Test
    public void validateChecksum_emptyChecksum() {
        Assert.assertFalse((boolean)EndToEndChecksumHandler.validateChecksum((String)"", (byte[])this.payloadBytes));
    }

    @Test
    public void validateChecksum_nullPayload() {
        Assert.assertFalse((boolean)EndToEndChecksumHandler.validateChecksum((String)"foo", null));
    }

    @Test
    public void validateChecksum_emptyPayload() {
        Assert.assertFalse((boolean)EndToEndChecksumHandler.validateChecksum((String)"foo", (byte[])new byte[0]));
    }

    @Test
    public void computeChecksum_nullInputBytes() {
        Assert.assertNull((Object)EndToEndChecksumHandler.computeChecksum(null));
    }

    @Test
    public void computeChecksum_emptyArrayForInputBytes() {
        Assert.assertNull((Object)EndToEndChecksumHandler.computeChecksum((byte[])new byte[0]));
    }
}

