/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.api.client.auth.oauth2.Credential;
import com.google.datastore.v1.Entity;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.Filter;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.KindExpression;
import com.google.datastore.v1.PartitionId;
import com.google.datastore.v1.Projection;
import com.google.datastore.v1.PropertyFilter;
import com.google.datastore.v1.PropertyOrder;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.QueryResultBatch;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreFactory;
import com.google.datastore.v1.client.DatastoreHelper;
import com.google.datastore.v1.client.DatastoreOptions;
import com.google.datastore.v1.client.QuerySplitterImpl;
import com.google.datastore.v1.client.testing.MockCredential;
import com.google.datastore.v1.client.testing.MockDatastoreFactory;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class QuerySplitterTest {
    private static final String PROJECT_ID = "project-id";
    private static final PartitionId PARTITION = PartitionId.newBuilder().setProjectId("project-id").build();
    private static final String KIND = "test-kind";
    private DatastoreFactory factory = new MockDatastoreFactory();
    private DatastoreOptions.Builder options = new DatastoreOptions.Builder().projectId("project-id").credential((Credential)new MockCredential());
    private Filter propertyFilter = DatastoreHelper.makeFilter((String)"foo", (PropertyFilter.Operator)PropertyFilter.Operator.EQUAL, (Value.Builder)DatastoreHelper.makeValue((String)"value")).build();
    private Query query = Query.newBuilder().addKind(KindExpression.newBuilder().setName("test-kind").build()).setFilter(this.propertyFilter).build();
    private Query splitQuery = Query.newBuilder().addKind(KindExpression.newBuilder().setName("test-kind").build()).addOrder(DatastoreHelper.makeOrder((String)"__scatter__", (PropertyOrder.Direction)PropertyOrder.Direction.ASCENDING)).addProjection(Projection.newBuilder().setProperty(DatastoreHelper.makePropertyReference((String)"__key__"))).build();
    private Key splitKey0 = DatastoreHelper.makeKey((Object[])new Object[]{"test-kind", String.format("%05d", 1)}).setPartitionId(PARTITION).build();
    private Key splitKey1 = DatastoreHelper.makeKey((Object[])new Object[]{"test-kind", String.format("%05d", 101)}).setPartitionId(PARTITION).build();
    private Key splitKey2 = DatastoreHelper.makeKey((Object[])new Object[]{"test-kind", String.format("%05d", 201)}).setPartitionId(PARTITION).build();
    private Key splitKey3 = DatastoreHelper.makeKey((Object[])new Object[]{"test-kind", String.format("%05d", 301)}).setPartitionId(PARTITION).build();

    @Test
    public void disallowsSortOrder() {
        Datastore datastore = this.factory.create(this.options.build());
        Query queryWithOrder = this.query.toBuilder().addOrder(DatastoreHelper.makeOrder((String)"bar", (PropertyOrder.Direction)PropertyOrder.Direction.ASCENDING)).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> QuerySplitterImpl.INSTANCE.getSplits(queryWithOrder, PARTITION, 2, datastore));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Query cannot have any sort orders.");
    }

    @Test
    public void disallowsMultipleKinds() {
        Datastore datastore = this.factory.create(this.options.build());
        Query queryWithMultipleKinds = this.query.toBuilder().addKind(KindExpression.newBuilder().setName("another-kind").build()).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> QuerySplitterImpl.INSTANCE.getSplits(queryWithMultipleKinds, PARTITION, 2, datastore));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Query must have exactly one kind.");
    }

    @Test
    public void disallowsKindlessQuery() {
        Datastore datastore = this.factory.create(this.options.build());
        Query kindlessQuery = this.query.toBuilder().clearKind().build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> QuerySplitterImpl.INSTANCE.getSplits(kindlessQuery, PARTITION, 2, datastore));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Query must have exactly one kind.");
    }

    @Test
    public void disallowsInequalityFilter() {
        Datastore datastore = this.factory.create(this.options.build());
        Query queryWithInequality = this.query.toBuilder().setFilter(DatastoreHelper.makeFilter((String)"foo", (PropertyFilter.Operator)PropertyFilter.Operator.GREATER_THAN, (Value.Builder)DatastoreHelper.makeValue((String)"value"))).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> QuerySplitterImpl.INSTANCE.getSplits(queryWithInequality, PARTITION, 2, datastore));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Query cannot have any inequality filters.");
    }

    @Test
    public void splitsMustBePositive() {
        Datastore datastore = this.factory.create(this.options.build());
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> QuerySplitterImpl.INSTANCE.getSplits(this.query, PARTITION, 0, datastore));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"The number of splits must be greater than 0.");
    }

    @Test
    public void getSplits() throws Exception {
        Datastore datastore = this.factory.create(this.options.build());
        MockDatastoreFactory mockClient = (MockDatastoreFactory)this.factory;
        RunQueryResponse splitQueryResponse = RunQueryResponse.newBuilder().setQuery(this.splitQuery).setBatch(QueryResultBatch.newBuilder().setEntityResultType(EntityResult.ResultType.KEY_ONLY).setMoreResults(QueryResultBatch.MoreResultsType.NO_MORE_RESULTS).addEntityResults(QuerySplitterTest.makeKeyOnlyEntity(this.splitKey0)).addEntityResults(QuerySplitterTest.makeKeyOnlyEntity(this.splitKey1)).addEntityResults(QuerySplitterTest.makeKeyOnlyEntity(this.splitKey2)).addEntityResults(QuerySplitterTest.makeKeyOnlyEntity(this.splitKey3)).build()).build();
        mockClient.setNextResponse((Message)splitQueryResponse);
        List splittedQueries = QuerySplitterImpl.INSTANCE.getSplits(this.query, PARTITION, 3, datastore);
        Truth.assertThat((Iterable)splittedQueries).containsExactly(new Object[]{this.query.toBuilder().setFilter(QuerySplitterTest.makeFilterWithKeyRange(this.propertyFilter, null, this.splitKey1)).build(), this.query.toBuilder().setFilter(QuerySplitterTest.makeFilterWithKeyRange(this.propertyFilter, this.splitKey1, this.splitKey3)).build(), this.query.toBuilder().setFilter(QuerySplitterTest.makeFilterWithKeyRange(this.propertyFilter, this.splitKey3, null)).build()});
        RunQueryRequest expectedSplitQueryRequest = RunQueryRequest.newBuilder().setPartitionId(PARTITION).setQuery(this.splitQuery.toBuilder().setLimit(Int32Value.newBuilder().setValue(64).build())).build();
        Assert.assertArrayEquals((byte[])expectedSplitQueryRequest.toByteArray(), (byte[])mockClient.getLastBody());
    }

    @Test
    public void notEnoughSplits() throws Exception {
        Datastore datastore = this.factory.create(this.options.build());
        MockDatastoreFactory mockClient = (MockDatastoreFactory)this.factory;
        RunQueryResponse splitQueryResponse = RunQueryResponse.newBuilder().setQuery(this.splitQuery).setBatch(QueryResultBatch.newBuilder().setEntityResultType(EntityResult.ResultType.KEY_ONLY).setMoreResults(QueryResultBatch.MoreResultsType.NO_MORE_RESULTS).addEntityResults(QuerySplitterTest.makeKeyOnlyEntity(this.splitKey0)).build()).build();
        mockClient.setNextResponse((Message)splitQueryResponse);
        List splittedQueries = QuerySplitterImpl.INSTANCE.getSplits(this.query, PARTITION, 100, datastore);
        Truth.assertThat((Iterable)splittedQueries).containsExactly(new Object[]{this.query.toBuilder().setFilter(QuerySplitterTest.makeFilterWithKeyRange(this.propertyFilter, null, this.splitKey0)).build(), this.query.toBuilder().setFilter(QuerySplitterTest.makeFilterWithKeyRange(this.propertyFilter, this.splitKey0, null)).build()});
        RunQueryRequest expectedSplitQueryRequest = RunQueryRequest.newBuilder().setPartitionId(PARTITION).setQuery(this.splitQuery.toBuilder().setLimit(Int32Value.newBuilder().setValue(3168).build())).build();
        Assert.assertArrayEquals((byte[])expectedSplitQueryRequest.toByteArray(), (byte[])mockClient.getLastBody());
    }

    @Test
    public void getSplits_withReadTime() throws Exception {
        Datastore datastore = this.factory.create(this.options.build());
        MockDatastoreFactory mockClient = (MockDatastoreFactory)this.factory;
        RunQueryResponse splitQueryResponse = RunQueryResponse.newBuilder().setQuery(this.splitQuery).setBatch(QueryResultBatch.newBuilder().setEntityResultType(EntityResult.ResultType.KEY_ONLY).setMoreResults(QueryResultBatch.MoreResultsType.NO_MORE_RESULTS).addEntityResults(QuerySplitterTest.makeKeyOnlyEntity(this.splitKey0)).addEntityResults(QuerySplitterTest.makeKeyOnlyEntity(this.splitKey1)).addEntityResults(QuerySplitterTest.makeKeyOnlyEntity(this.splitKey2)).addEntityResults(QuerySplitterTest.makeKeyOnlyEntity(this.splitKey3)).build()).build();
        mockClient.setNextResponse((Message)splitQueryResponse);
        Timestamp readTime = Timestamp.newBuilder().setSeconds(1654651341L).build();
        List splittedQueries = QuerySplitterImpl.INSTANCE.getSplits(this.query, PARTITION, 3, datastore, readTime);
        Truth.assertThat((Iterable)splittedQueries).containsExactly(new Object[]{this.query.toBuilder().setFilter(QuerySplitterTest.makeFilterWithKeyRange(this.propertyFilter, null, this.splitKey1)).build(), this.query.toBuilder().setFilter(QuerySplitterTest.makeFilterWithKeyRange(this.propertyFilter, this.splitKey1, this.splitKey3)).build(), this.query.toBuilder().setFilter(QuerySplitterTest.makeFilterWithKeyRange(this.propertyFilter, this.splitKey3, null)).build()});
        RunQueryRequest expectedSplitQueryRequest = RunQueryRequest.newBuilder().setPartitionId(PARTITION).setQuery(this.splitQuery.toBuilder().setLimit(Int32Value.newBuilder().setValue(64).build())).setReadOptions(ReadOptions.newBuilder().setReadTime(readTime)).build();
        Assert.assertArrayEquals((byte[])expectedSplitQueryRequest.toByteArray(), (byte[])mockClient.getLastBody());
    }

    private static EntityResult makeKeyOnlyEntity(Key key) {
        return EntityResult.newBuilder().setEntity(Entity.newBuilder().setKey(key).build()).build();
    }

    private static Filter makeFilterWithKeyRange(Filter originalFilter, Key startKey, Key endKey) {
        Filter endKeyFilter;
        Filter startKeyFilter = startKey == null ? null : DatastoreHelper.makeFilter((String)"__key__", (PropertyFilter.Operator)PropertyFilter.Operator.GREATER_THAN_OR_EQUAL, (Value.Builder)DatastoreHelper.makeValue((Key)startKey)).build();
        Filter filter = endKeyFilter = endKey == null ? null : DatastoreHelper.makeFilter((String)"__key__", (PropertyFilter.Operator)PropertyFilter.Operator.LESS_THAN, (Value.Builder)DatastoreHelper.makeValue((Key)endKey)).build();
        if (startKeyFilter == null && endKeyFilter == null) {
            throw new IllegalArgumentException();
        }
        if (startKeyFilter != null && endKeyFilter == null) {
            return DatastoreHelper.makeAndFilter((Filter[])new Filter[]{originalFilter, startKeyFilter}).build();
        }
        if (startKeyFilter == null && endKeyFilter != null) {
            return DatastoreHelper.makeAndFilter((Filter[])new Filter[]{originalFilter, endKeyFilter}).build();
        }
        return DatastoreHelper.makeAndFilter((Filter[])new Filter[]{originalFilter, startKeyFilter, endKeyFilter}).build();
    }
}

