/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.protobuf.ProtoHttpContent;
import com.google.api.client.util.Charsets;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.RemoteRpc;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.google.rpc.Code;
import com.google.rpc.Status;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.GZIPOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RemoteRpcTest {
    private static final String METHOD_NAME = "methodName";

    @Test
    public void testException() {
        Status statusProto = Status.newBuilder().setCode(16).setMessage("The request does not have valid authentication credentials.").build();
        DatastoreException exception = RemoteRpc.makeException((String)"url", (String)METHOD_NAME, (InputStream)new ByteArrayInputStream(statusProto.toByteArray()), (String)"application/x-protobuf", (Charset)Charsets.UTF_8, (Throwable)new RuntimeException(), (int)401);
        Assert.assertEquals((Object)Code.UNAUTHENTICATED, (Object)exception.getCode());
        Assert.assertEquals((Object)"The request does not have valid authentication credentials.", (Object)exception.getMessage());
        Assert.assertEquals((Object)METHOD_NAME, (Object)exception.getMethodName());
    }

    @Test
    public void testInvalidProtoException() {
        DatastoreException exception = RemoteRpc.makeException((String)"url", (String)METHOD_NAME, (InputStream)new ByteArrayInputStream("<invalid proto>".getBytes()), (String)"application/x-protobuf", (Charset)Charsets.UTF_8, (Throwable)new RuntimeException(), (int)401);
        Assert.assertEquals((Object)Code.INTERNAL, (Object)exception.getCode());
        Assert.assertEquals((Object)"Unable to parse Status protocol buffer: HTTP status code was 401.", (Object)exception.getMessage());
        Assert.assertEquals((Object)METHOD_NAME, (Object)exception.getMethodName());
    }

    @Test
    public void testEmptyProtoException() {
        Status statusProto = Status.newBuilder().build();
        DatastoreException exception = RemoteRpc.makeException((String)"url", (String)METHOD_NAME, (InputStream)new ByteArrayInputStream(statusProto.toByteArray()), (String)"application/x-protobuf", (Charset)Charsets.UTF_8, (Throwable)new RuntimeException(), (int)404);
        Assert.assertEquals((Object)Code.INTERNAL, (Object)exception.getCode());
        Assert.assertEquals((Object)"Unexpected OK error code with HTTP status code of 404. Message: .", (Object)exception.getMessage());
        Assert.assertEquals((Object)METHOD_NAME, (Object)exception.getMethodName());
    }

    @Test
    public void testEmptyProtoExceptionUnauthenticated() {
        Status statusProto = Status.newBuilder().build();
        DatastoreException exception = RemoteRpc.makeException((String)"url", (String)METHOD_NAME, (InputStream)new ByteArrayInputStream(statusProto.toByteArray()), (String)"application/x-protobuf", (Charset)Charsets.UTF_8, (Throwable)new RuntimeException(), (int)401);
        Assert.assertEquals((Object)Code.UNAUTHENTICATED, (Object)exception.getCode());
        Assert.assertEquals((Object)"Unauthenticated.", (Object)exception.getMessage());
        Assert.assertEquals((Object)METHOD_NAME, (Object)exception.getMethodName());
    }

    @Test
    public void testPlainTextException() {
        DatastoreException exception = RemoteRpc.makeException((String)"url", (String)METHOD_NAME, (InputStream)new ByteArrayInputStream("Text Error".getBytes()), (String)"text/plain", (Charset)Charsets.UTF_8, (Throwable)new RuntimeException(), (int)401);
        Assert.assertEquals((Object)Code.INTERNAL, (Object)exception.getCode());
        Assert.assertEquals((Object)"Non-protobuf error: Text Error. HTTP status code was 401.", (Object)exception.getMessage());
        Assert.assertEquals((Object)METHOD_NAME, (Object)exception.getMethodName());
    }

    @Test
    public void testGzip() throws IOException, DatastoreException {
        BeginTransactionResponse response = RemoteRpcTest.newBeginTransactionResponse();
        InjectedTestValues injectedTestValues = new InjectedTestValues(this.gzip(response), new byte[1], true);
        RemoteRpc rpc = RemoteRpcTest.newRemoteRpc(injectedTestValues);
        InputStream is = rpc.call("beginTransaction", (MessageLite)BeginTransactionResponse.getDefaultInstance());
        BeginTransactionResponse parsedResponse = BeginTransactionResponse.parseFrom((InputStream)is);
        is.close();
        Assert.assertEquals((Object)response, (Object)parsedResponse);
        Assert.assertEquals((long)-1L, (long)injectedTestValues.inputStream.read());
    }

    @Test
    public void testHttpHeaders_expectE2eChecksumHeader() throws IOException {
        RemoteRpc.setSystemEnvE2EChecksum((boolean)true);
        RollbackRequest request = RollbackRequest.newBuilder().setTransaction(ByteString.copyFromUtf8((String)"project-id")).build();
        RemoteRpc rpc = RemoteRpcTest.newRemoteRpc(new InjectedTestValues(this.gzip(RemoteRpcTest.newBeginTransactionResponse()), new byte[1], true));
        HttpRequest httpRequest = rpc.getClient().buildPostRequest(rpc.resolveURL("blah"), (HttpContent)new ProtoHttpContent((MessageLite)request));
        rpc.setHeaders((MessageLite)request, httpRequest);
        Assert.assertNotNull((Object)httpRequest.getHeaders().getFirstHeaderStringValue("X-Goog-Api-Format-Version"));
        String header = httpRequest.getHeaders().getFirstHeaderStringValue("x-request-checksum-348659783");
        Assert.assertEquals((long)8L, (long)header.length());
    }

    @Test
    public void testHttpHeaders_doNotExpectE2eChecksumHeader() throws IOException {
        RemoteRpc.setSystemEnvE2EChecksum((boolean)false);
        RollbackRequest request = RollbackRequest.newBuilder().setTransaction(ByteString.copyFromUtf8((String)"project-id")).build();
        RemoteRpc rpc = RemoteRpcTest.newRemoteRpc(new InjectedTestValues(this.gzip(RemoteRpcTest.newBeginTransactionResponse()), new byte[1], true));
        HttpRequest httpRequest = rpc.getClient().buildPostRequest(rpc.resolveURL("blah"), (HttpContent)new ProtoHttpContent((MessageLite)request));
        rpc.setHeaders((MessageLite)request, httpRequest);
        Assert.assertNotNull((Object)httpRequest.getHeaders().getFirstHeaderStringValue("X-Goog-Api-Format-Version"));
        Assert.assertNull((Object)httpRequest.getHeaders().getFirstHeaderStringValue("x-request-checksum-348659783"));
    }

    private static BeginTransactionResponse newBeginTransactionResponse() {
        return BeginTransactionResponse.newBuilder().setTransaction(ByteString.copyFromUtf8((String)"blah-blah-blah")).build();
    }

    private static RemoteRpc newRemoteRpc(InjectedTestValues injectedTestValues) {
        return new RemoteRpc(new MyHttpTransport(injectedTestValues).createRequestFactory(), null, "https://www.example.com/v1/projects/p");
    }

    private byte[] gzip(BeginTransactionResponse response) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOut = new GZIPOutputStream(bytesOut);){
            response.writeTo((OutputStream)gzipOut);
        }
        return bytesOut.toByteArray();
    }

    private static class MyLowLevelHttpResponse
    extends LowLevelHttpResponse {
        private final InjectedTestValues injectedTestValues;

        public MyLowLevelHttpResponse(InjectedTestValues injectedTestValues) {
            this.injectedTestValues = injectedTestValues;
        }

        public InputStream getContent() throws IOException {
            return this.injectedTestValues.inputStream;
        }

        public String getContentEncoding() throws IOException {
            return this.injectedTestValues.isGzip ? "gzip" : "";
        }

        public long getContentLength() throws IOException {
            return this.injectedTestValues.contentLength;
        }

        public String getContentType() throws IOException {
            return "application/x-protobuf";
        }

        public String getStatusLine() throws IOException {
            return null;
        }

        public int getStatusCode() throws IOException {
            return 200;
        }

        public String getReasonPhrase() throws IOException {
            return null;
        }

        public int getHeaderCount() throws IOException {
            return 0;
        }

        public String getHeaderName(int index) throws IOException {
            return null;
        }

        public String getHeaderValue(int index) throws IOException {
            return null;
        }
    }

    private static class MyLowLevelHttpRequest
    extends LowLevelHttpRequest {
        private final InjectedTestValues injectedTestValues;

        public MyLowLevelHttpRequest(InjectedTestValues injectedTestValues) {
            this.injectedTestValues = injectedTestValues;
        }

        public void addHeader(String name, String value) throws IOException {
        }

        public LowLevelHttpResponse execute() throws IOException {
            return new MyLowLevelHttpResponse(this.injectedTestValues);
        }
    }

    private static class MyHttpTransport
    extends HttpTransport {
        private final InjectedTestValues injectedTestValues;

        public MyHttpTransport(InjectedTestValues injectedTestValues) {
            this.injectedTestValues = injectedTestValues;
        }

        protected LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
            return new MyLowLevelHttpRequest(this.injectedTestValues);
        }
    }

    private static class InjectedTestValues {
        private final InputStream inputStream;
        private final int contentLength;
        private final boolean isGzip;

        public InjectedTestValues(byte[] messageBytes, byte[] additionalBytes, boolean isGzip) {
            byte[] allBytes = InjectedTestValues.concat(messageBytes, additionalBytes);
            this.inputStream = new ByteArrayInputStream(allBytes);
            this.contentLength = allBytes.length;
            this.isGzip = isGzip;
        }

        private static byte[] concat(byte[] a, byte[] b) {
            byte[] c = new byte[a.length + b.length];
            System.arraycopy(a, 0, c, 0, a.length);
            System.arraycopy(b, 0, c, a.length, b.length);
            return c;
        }
    }
}

