/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.FixedCompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class FixedCompositeByteBufTest {
    private static ByteBuf newBuffer(ByteBuf ... buffers) {
        return new FixedCompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, buffers);
    }

    @Test
    public void testSetBoolean() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setBoolean(0, true);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetByte() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setByte(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetBytesWithByteBuf() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        final ByteBuf src = Unpooled.wrappedBuffer((byte[])new byte[4]);
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setBytes(0, src);
                }
            });
        }
        finally {
            buf.release();
            src.release();
        }
    }

    @Test
    public void testSetBytesWithByteBuffer() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setBytes(0, ByteBuffer.wrap(new byte[4]));
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetBytesWithInputStream() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() throws IOException {
                    buf.setBytes(0, (InputStream)new ByteArrayInputStream(new byte[4]), 4);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetBytesWithChannel() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() throws IOException {
                    buf.setBytes(0, new ScatteringByteChannel(){

                        @Override
                        public long read(ByteBuffer[] dsts, int offset, int length) {
                            return 0L;
                        }

                        @Override
                        public long read(ByteBuffer[] dsts) {
                            return 0L;
                        }

                        @Override
                        public int read(ByteBuffer dst) {
                            return 0;
                        }

                        @Override
                        public boolean isOpen() {
                            return true;
                        }

                        @Override
                        public void close() {
                        }
                    }, 4);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetChar() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setChar(0, 98);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetDouble() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setDouble(0, 1.0);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetFloat() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setFloat(0, 1.0f);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetInt() throws IOException {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setInt(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetLong() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setLong(0, 1L);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetMedium() {
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(Unpooled.wrappedBuffer((byte[])new byte[8]));
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setMedium(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testGatheringWritesHeap() throws Exception {
        FixedCompositeByteBufTest.testGatheringWrites(Unpooled.buffer(), Unpooled.buffer());
    }

    @Test
    public void testGatheringWritesDirect() throws Exception {
        FixedCompositeByteBufTest.testGatheringWrites(Unpooled.directBuffer(), Unpooled.directBuffer());
    }

    @Test
    public void testGatheringWritesMixes() throws Exception {
        FixedCompositeByteBufTest.testGatheringWrites(Unpooled.buffer(), Unpooled.directBuffer());
    }

    @Test
    public void testGatheringWritesHeapPooled() throws Exception {
        FixedCompositeByteBufTest.testGatheringWrites(PooledByteBufAllocator.DEFAULT.heapBuffer(), PooledByteBufAllocator.DEFAULT.heapBuffer());
    }

    @Test
    public void testGatheringWritesDirectPooled() throws Exception {
        FixedCompositeByteBufTest.testGatheringWrites(PooledByteBufAllocator.DEFAULT.directBuffer(), PooledByteBufAllocator.DEFAULT.directBuffer());
    }

    @Test
    public void testGatheringWritesMixesPooled() throws Exception {
        FixedCompositeByteBufTest.testGatheringWrites(PooledByteBufAllocator.DEFAULT.heapBuffer(), PooledByteBufAllocator.DEFAULT.directBuffer());
    }

    private static void testGatheringWrites(ByteBuf buf1, ByteBuf buf2) throws Exception {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(buf1.writeBytes(new byte[]{1, 2}));
        buf.addComponent(buf2.writeBytes(new byte[]{1, 2}));
        buf.writerIndex(3);
        buf.readerIndex(1);
        AbstractByteBufTest.TestGatheringByteChannel channel = new AbstractByteBufTest.TestGatheringByteChannel();
        buf.readBytes((GatheringByteChannel)channel, 2);
        byte[] data = new byte[2];
        buf.getBytes(1, data);
        buf.release();
        Assertions.assertArrayEquals((byte[])data, (byte[])channel.writtenBytes());
    }

    @Test
    public void testGatheringWritesPartialHeap() throws Exception {
        FixedCompositeByteBufTest.testGatheringWritesPartial(Unpooled.buffer(), Unpooled.buffer());
    }

    @Test
    public void testGatheringWritesPartialDirect() throws Exception {
        FixedCompositeByteBufTest.testGatheringWritesPartial(Unpooled.directBuffer(), Unpooled.directBuffer());
    }

    @Test
    public void testGatheringWritesPartialMixes() throws Exception {
        FixedCompositeByteBufTest.testGatheringWritesPartial(Unpooled.buffer(), Unpooled.directBuffer());
    }

    @Test
    public void testGatheringWritesPartialHeapPooled() throws Exception {
        FixedCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.heapBuffer(), PooledByteBufAllocator.DEFAULT.heapBuffer());
    }

    @Test
    public void testGatheringWritesPartialDirectPooled() throws Exception {
        FixedCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.directBuffer(), PooledByteBufAllocator.DEFAULT.directBuffer());
    }

    @Test
    public void testGatheringWritesPartialMixesPooled() throws Exception {
        FixedCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.heapBuffer(), PooledByteBufAllocator.DEFAULT.directBuffer());
    }

    private static void testGatheringWritesPartial(ByteBuf buf1, ByteBuf buf2) throws Exception {
        buf1.writeBytes(new byte[]{1, 2, 3, 4});
        buf2.writeBytes(new byte[]{1, 2, 3, 4});
        ByteBuf buf = FixedCompositeByteBufTest.newBuffer(buf1, buf2);
        AbstractByteBufTest.TestGatheringByteChannel channel = new AbstractByteBufTest.TestGatheringByteChannel(1);
        while (buf.isReadable()) {
            buf.readBytes((GatheringByteChannel)channel, buf.readableBytes());
        }
        byte[] data = new byte[8];
        buf.getBytes(0, data);
        Assertions.assertArrayEquals((byte[])data, (byte[])channel.writtenBytes());
        buf.release();
    }

    @Test
    public void testGatheringWritesSingleHeap() throws Exception {
        FixedCompositeByteBufTest.testGatheringWritesSingleBuf(Unpooled.buffer());
    }

    @Test
    public void testGatheringWritesSingleDirect() throws Exception {
        FixedCompositeByteBufTest.testGatheringWritesSingleBuf(Unpooled.directBuffer());
    }

    private static void testGatheringWritesSingleBuf(ByteBuf buf1) throws Exception {
        ByteBuf buf = FixedCompositeByteBufTest.newBuffer(buf1.writeBytes(new byte[]{1, 2, 3, 4}));
        buf.readerIndex(1);
        AbstractByteBufTest.TestGatheringByteChannel channel = new AbstractByteBufTest.TestGatheringByteChannel();
        buf.readBytes((GatheringByteChannel)channel, 2);
        byte[] data = new byte[2];
        buf.getBytes(1, data);
        Assertions.assertArrayEquals((byte[])data, (byte[])channel.writtenBytes());
        buf.release();
    }

    @Test
    public void testCopyingToOtherBuffer() {
        ByteBuf buf1 = Unpooled.directBuffer((int)10);
        ByteBuf buf2 = Unpooled.buffer((int)10);
        ByteBuf buf3 = Unpooled.directBuffer((int)10);
        buf1.writeBytes("a".getBytes(Charset.defaultCharset()));
        buf2.writeBytes("b".getBytes(Charset.defaultCharset()));
        buf3.writeBytes("c".getBytes(Charset.defaultCharset()));
        ByteBuf composite = Unpooled.unmodifiableBuffer((ByteBuf[])new ByteBuf[]{buf1, buf2, buf3});
        ByteBuf copy = Unpooled.directBuffer((int)3);
        ByteBuf copy2 = Unpooled.buffer((int)3);
        copy.setBytes(0, composite, 0, 3);
        copy2.setBytes(0, composite, 0, 3);
        copy.writerIndex(3);
        copy2.writerIndex(3);
        Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)copy, (ByteBuf)composite));
        Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)copy2, (ByteBuf)composite));
        Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)copy, (ByteBuf)copy2));
        copy.release();
        copy2.release();
        composite.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyingToOutputStream() throws IOException {
        ByteBuf buf1 = Unpooled.directBuffer((int)10);
        ByteBuf buf2 = Unpooled.buffer((int)10);
        ByteBuf buf3 = Unpooled.directBuffer((int)10);
        buf1.writeBytes("a".getBytes(Charset.defaultCharset()));
        buf2.writeBytes("b".getBytes(Charset.defaultCharset()));
        buf3.writeBytes("c".getBytes(Charset.defaultCharset()));
        ByteBuf composite = Unpooled.unmodifiableBuffer((ByteBuf[])new ByteBuf[]{buf1, buf2, buf3});
        ByteBuf copy = Unpooled.directBuffer((int)3);
        ByteBuf copy2 = Unpooled.buffer((int)3);
        ByteBufOutputStream copyStream = new ByteBufOutputStream(copy);
        ByteBufOutputStream copy2Stream = new ByteBufOutputStream(copy2);
        try {
            composite.getBytes(0, (OutputStream)copyStream, 3);
            composite.getBytes(0, (OutputStream)copy2Stream, 3);
            Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)copy, (ByteBuf)composite));
            Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)copy2, (ByteBuf)composite));
            Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)copy, (ByteBuf)copy2));
        }
        finally {
            copy.release();
            copy2.release();
            copyStream.close();
            copy2Stream.close();
            composite.release();
        }
    }

    @Test
    public void testExtractNioBuffers() {
        ByteBuf buf1 = Unpooled.directBuffer((int)10);
        ByteBuf buf2 = Unpooled.buffer((int)10);
        ByteBuf buf3 = Unpooled.directBuffer((int)10);
        buf1.writeBytes("a".getBytes(Charset.defaultCharset()));
        buf2.writeBytes("b".getBytes(Charset.defaultCharset()));
        buf3.writeBytes("c".getBytes(Charset.defaultCharset()));
        ByteBuf composite = Unpooled.unmodifiableBuffer((ByteBuf[])new ByteBuf[]{buf1, buf2, buf3});
        ByteBuffer[] byteBuffers = composite.nioBuffers(0, 3);
        Assertions.assertEquals((int)3, (int)byteBuffers.length);
        Assertions.assertEquals((int)1, (int)byteBuffers[0].limit());
        Assertions.assertEquals((int)1, (int)byteBuffers[1].limit());
        Assertions.assertEquals((int)1, (int)byteBuffers[2].limit());
        composite.release();
    }

    @Test
    public void testEmptyArray() {
        ByteBuf buf = FixedCompositeByteBufTest.newBuffer(new ByteBuf[0]);
        buf.release();
    }

    @Test
    public void testHasMemoryAddressWithSingleBuffer() {
        ByteBuf buf1 = Unpooled.directBuffer((int)10);
        if (!buf1.hasMemoryAddress()) {
            buf1.release();
            return;
        }
        ByteBuf buf = FixedCompositeByteBufTest.newBuffer(buf1);
        Assertions.assertTrue((boolean)buf.hasMemoryAddress());
        Assertions.assertEquals((long)buf1.memoryAddress(), (long)buf.memoryAddress());
        buf.release();
    }

    @Test
    public void testHasMemoryAddressWhenEmpty() {
        Assumptions.assumeTrue((boolean)Unpooled.EMPTY_BUFFER.hasMemoryAddress());
        ByteBuf buf = FixedCompositeByteBufTest.newBuffer(new ByteBuf[0]);
        Assertions.assertTrue((boolean)buf.hasMemoryAddress());
        Assertions.assertEquals((long)Unpooled.EMPTY_BUFFER.memoryAddress(), (long)buf.memoryAddress());
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasNoMemoryAddressWhenMultipleBuffers() {
        ByteBuf buf1 = Unpooled.directBuffer((int)10);
        if (!buf1.hasMemoryAddress()) {
            buf1.release();
            return;
        }
        ByteBuf buf2 = Unpooled.directBuffer((int)10);
        ByteBuf buf = FixedCompositeByteBufTest.newBuffer(buf1, buf2);
        Assertions.assertFalse((boolean)buf.hasMemoryAddress());
        try {
            buf.memoryAddress();
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testHasArrayWithSingleBuffer() {
        ByteBuf buf1 = Unpooled.buffer((int)10);
        ByteBuf buf = FixedCompositeByteBufTest.newBuffer(buf1);
        Assertions.assertTrue((boolean)buf.hasArray());
        Assertions.assertArrayEquals((byte[])buf1.array(), (byte[])buf.array());
        buf.release();
    }

    @Test
    public void testHasArrayWhenEmptyAndIsDirect() {
        ByteBuf buf = FixedCompositeByteBufTest.newBuffer(new ByteBuf[0]);
        Assertions.assertTrue((boolean)buf.hasArray());
        Assertions.assertArrayEquals((byte[])Unpooled.EMPTY_BUFFER.array(), (byte[])buf.array());
        Assertions.assertEquals((Object)Unpooled.EMPTY_BUFFER.isDirect(), (Object)buf.isDirect());
        Assertions.assertEquals((long)Unpooled.EMPTY_BUFFER.memoryAddress(), (long)buf.memoryAddress());
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasNoArrayWhenMultipleBuffers() {
        ByteBuf buf1 = Unpooled.buffer((int)10);
        ByteBuf buf2 = Unpooled.buffer((int)10);
        final ByteBuf buf = FixedCompositeByteBufTest.newBuffer(buf1, buf2);
        Assertions.assertFalse((boolean)buf.hasArray());
        try {
            Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

                public void execute() {
                    buf.array();
                }
            });
        }
        finally {
            buf.release();
        }
    }
}

