/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.EmptyArrays;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;

public class UnpooledTest {
    private static final ByteBuf[] EMPTY_BYTE_BUFS = new ByteBuf[0];
    private static final byte[][] EMPTY_BYTES_2D = new byte[0][];

    @Test
    public void testCompositeWrappedBuffer() {
        ByteBuf header = Unpooled.buffer((int)12);
        ByteBuf payload = Unpooled.buffer((int)512);
        header.writeBytes(new byte[12]);
        payload.writeBytes(new byte[512]);
        ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header, payload});
        Assertions.assertEquals((int)12, (int)header.readableBytes());
        Assertions.assertEquals((int)512, (int)payload.readableBytes());
        Assertions.assertEquals((int)524, (int)buffer.readableBytes());
        Assertions.assertEquals((int)2, (int)buffer.nioBufferCount());
        buffer.release();
    }

    @Test
    public void testHashCode() {
        LinkedHashMap<byte[], Integer> map = new LinkedHashMap<byte[], Integer>();
        map.put(EmptyArrays.EMPTY_BYTES, 1);
        map.put(new byte[]{1}, 32);
        map.put(new byte[]{2}, 33);
        map.put(new byte[]{0, 1}, 962);
        map.put(new byte[]{1, 2}, 994);
        map.put(new byte[]{0, 1, 2, 3, 4, 5}, 63504931);
        map.put(new byte[]{6, 7, 8, 9, 0, 1}, -1603953111);
        map.put(new byte[]{-1, -1, -1, -31}, 1);
        for (Map.Entry e : map.entrySet()) {
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])((byte[])e.getKey()));
            Assertions.assertEquals((int)((Integer)e.getValue()), (int)ByteBufUtil.hashCode((ByteBuf)buffer));
            buffer.release();
        }
    }

    @Test
    public void testEquals() {
        ByteBuf a = Unpooled.wrappedBuffer((byte[])new byte[]{1});
        ByteBuf b = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2});
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3});
        b = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3});
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3});
        b = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4}, (int)1, (int)3);
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3});
        b = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 4});
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3});
        b = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 4, 5}, (int)1, (int)3);
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        b = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        b = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, (int)1, (int)10);
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        b = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 6, 7, 8, 5, 9, 10});
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        b = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11}, (int)1, (int)10);
        Assertions.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
    }

    @Test
    public void testCompare() {
        ArrayList<ByteBuf> expected = new ArrayList<ByteBuf>();
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{1}));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{2}));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3}));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11}));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3, 4}, (int)1, (int)1));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}, (int)2, (int)2));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}, (int)1, (int)10));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}, (int)2, (int)12));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3, 4, 5}, (int)2, (int)1));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5}, (int)3, (int)2));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}, (int)2, (int)10));
        expected.add(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, (int)3, (int)12));
        for (int i = 0; i < expected.size(); ++i) {
            for (int j = 0; j < expected.size(); ++j) {
                if (i == j) {
                    Assertions.assertEquals((int)0, (int)ByteBufUtil.compare((ByteBuf)((ByteBuf)expected.get(i)), (ByteBuf)((ByteBuf)expected.get(j))));
                    continue;
                }
                if (i < j) {
                    Assertions.assertTrue((ByteBufUtil.compare((ByteBuf)((ByteBuf)expected.get(i)), (ByteBuf)((ByteBuf)expected.get(j))) < 0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((ByteBufUtil.compare((ByteBuf)((ByteBuf)expected.get(i)), (ByteBuf)((ByteBuf)expected.get(j))) > 0 ? 1 : 0) != 0);
            }
        }
        for (ByteBuf buffer : expected) {
            buffer.release();
        }
    }

    @Test
    public void shouldReturnEmptyBufferWhenLengthIsZero() {
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((byte[])EmptyArrays.EMPTY_BYTES));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((byte[])new byte[8], (int)0, (int)0));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((byte[])new byte[8], (int)8, (int)0));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocateDirect(0)));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((ByteBuf)Unpooled.EMPTY_BUFFER));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((byte[][])EMPTY_BYTES_2D));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((byte[][])new byte[][]{EmptyArrays.EMPTY_BYTES}));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((ByteBuffer[])EmptyArrays.EMPTY_BYTE_BUFFERS));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.allocate(0)}));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.allocate(0), ByteBuffer.allocate(0)}));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((ByteBuf[])EMPTY_BYTE_BUFS));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.buffer((int)0)}));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.buffer((int)0), Unpooled.buffer((int)0)}));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((byte[])EmptyArrays.EMPTY_BYTES));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((byte[])new byte[8], (int)0, (int)0));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((byte[])new byte[8], (int)8, (int)0));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((ByteBuffer)ByteBuffer.allocateDirect(0)));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((ByteBuf)Unpooled.EMPTY_BUFFER));
        Assertions.assertSame((Object)Unpooled.EMPTY_BUFFER, (Object)Unpooled.copiedBuffer((byte[][])EMPTY_BYTES_2D));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((byte[][])new byte[][]{EmptyArrays.EMPTY_BYTES}));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((ByteBuffer[])EmptyArrays.EMPTY_BYTE_BUFFERS));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.allocate(0)}));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.allocate(0), ByteBuffer.allocate(0)}));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((ByteBuf[])EMPTY_BYTE_BUFS));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.buffer((int)0)}));
        UnpooledTest.assertSameAndRelease(Unpooled.EMPTY_BUFFER, Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.buffer((int)0), Unpooled.buffer((int)0)}));
    }

    @Test
    public void testCompare2() {
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{-1, -1, -1, -1});
        ByteBuf actual = Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0, 0});
        Assertions.assertTrue((ByteBufUtil.compare((ByteBuf)expected, (ByteBuf)actual) > 0 ? 1 : 0) != 0);
        expected.release();
        actual.release();
        expected = Unpooled.wrappedBuffer((byte[])new byte[]{-1});
        actual = Unpooled.wrappedBuffer((byte[])new byte[]{0});
        Assertions.assertTrue((ByteBufUtil.compare((ByteBuf)expected, (ByteBuf)actual) > 0 ? 1 : 0) != 0);
        expected.release();
        actual.release();
    }

    @Test
    public void shouldAllowEmptyBufferToCreateCompositeBuffer() {
        ByteBuf buf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.EMPTY_BUFFER, Unpooled.wrappedBuffer((byte[])new byte[16]).order(Unpooled.LITTLE_ENDIAN), Unpooled.EMPTY_BUFFER});
        try {
            Assertions.assertEquals((int)16, (int)buf.capacity());
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testWrappedBuffer() {
        ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocateDirect(16));
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        buffer.release();
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3}}));
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.wrappedBuffer((byte[][])new byte[][]{{1}, {2}, {3}}));
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3})}));
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1}), Unpooled.wrappedBuffer((byte[])new byte[]{2}), Unpooled.wrappedBuffer((byte[])new byte[]{3})}));
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.wrappedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(new byte[]{1, 2, 3})}));
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.wrappedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{2}), ByteBuffer.wrap(new byte[]{3})}));
    }

    @Test
    public void testSingleWrappedByteBufReleased() {
        ByteBuf buf = Unpooled.buffer((int)12).writeByte(0);
        ByteBuf wrapped = Unpooled.wrappedBuffer((ByteBuf)buf);
        Assertions.assertTrue((boolean)wrapped.release());
        Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    @Test
    public void testSingleUnReadableWrappedByteBufReleased() {
        ByteBuf buf = Unpooled.buffer((int)12);
        ByteBuf wrapped = Unpooled.wrappedBuffer((ByteBuf)buf);
        Assertions.assertFalse((boolean)wrapped.release());
        Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    @Test
    public void testMultiByteBufReleased() {
        ByteBuf buf1 = Unpooled.buffer((int)12).writeByte(0);
        ByteBuf buf2 = Unpooled.buffer((int)12).writeByte(0);
        ByteBuf wrapped = Unpooled.wrappedBuffer((int)16, (ByteBuf[])new ByteBuf[]{buf1, buf2});
        Assertions.assertTrue((boolean)wrapped.release());
        Assertions.assertEquals((int)0, (int)buf1.refCnt());
        Assertions.assertEquals((int)0, (int)buf2.refCnt());
    }

    @Test
    public void testMultiUnReadableByteBufReleased() {
        ByteBuf buf1 = Unpooled.buffer((int)12);
        ByteBuf buf2 = Unpooled.buffer((int)12);
        ByteBuf wrapped = Unpooled.wrappedBuffer((int)16, (ByteBuf[])new ByteBuf[]{buf1, buf2});
        Assertions.assertFalse((boolean)wrapped.release());
        Assertions.assertEquals((int)0, (int)buf1.refCnt());
        Assertions.assertEquals((int)0, (int)buf2.refCnt());
    }

    @Test
    public void testCopiedBufferUtf8() {
        UnpooledTest.testCopiedBufferCharSequence("Some UTF_8 like \u00e4\u00c4\u220f\u0152\u0152", CharsetUtil.UTF_8);
    }

    @Test
    public void testCopiedBufferAscii() {
        UnpooledTest.testCopiedBufferCharSequence("Some US_ASCII", CharsetUtil.US_ASCII);
    }

    @Test
    public void testCopiedBufferSomeOtherCharset() {
        UnpooledTest.testCopiedBufferCharSequence("Some ISO_8859_1", CharsetUtil.ISO_8859_1);
    }

    private static void testCopiedBufferCharSequence(CharSequence sequence, Charset charset) {
        ByteBuf copied = Unpooled.copiedBuffer((CharSequence)sequence, (Charset)charset);
        try {
            Assertions.assertEquals((Object)sequence, (Object)copied.toString(charset));
        }
        finally {
            copied.release();
        }
    }

    @Test
    public void testCopiedBuffer() {
        ByteBuf copied = Unpooled.copiedBuffer((ByteBuffer)ByteBuffer.allocateDirect(16));
        Assertions.assertEquals((int)16, (int)copied.capacity());
        copied.release();
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.copiedBuffer((byte[][])new byte[][]{{1, 2, 3}}));
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.copiedBuffer((byte[][])new byte[][]{{1}, {2}, {3}}));
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3})}));
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1}), Unpooled.wrappedBuffer((byte[])new byte[]{2}), Unpooled.wrappedBuffer((byte[])new byte[]{3})}));
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.copiedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(new byte[]{1, 2, 3})}));
        UnpooledTest.assertEqualsAndRelease(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), Unpooled.copiedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{2}), ByteBuffer.wrap(new byte[]{3})}));
    }

    private static void assertEqualsAndRelease(ByteBuf expected, ByteBuf actual) {
        Assertions.assertEquals((Object)expected, (Object)actual);
        expected.release();
        actual.release();
    }

    private static void assertSameAndRelease(ByteBuf expected, ByteBuf actual) {
        Assertions.assertEquals((Object)expected, (Object)actual);
        expected.release();
        actual.release();
    }

    @Test
    public void testHexDump() {
        Assertions.assertEquals((Object)"", (Object)ByteBufUtil.hexDump((ByteBuf)Unpooled.EMPTY_BUFFER));
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])new byte[]{18, 52, 86});
        Assertions.assertEquals((Object)"123456", (Object)ByteBufUtil.hexDump((ByteBuf)buffer));
        buffer.release();
        buffer = Unpooled.wrappedBuffer((byte[])new byte[]{18, 52, 86, 120, -112, -85, -51, -17});
        Assertions.assertEquals((Object)"1234567890abcdef", (Object)ByteBufUtil.hexDump((ByteBuf)buffer));
        buffer.release();
    }

    @Test
    public void testSwapMedium() {
        Assertions.assertEquals((int)5649426, (int)ByteBufUtil.swapMedium((int)1193046));
        Assertions.assertEquals((int)128, (int)ByteBufUtil.swapMedium((int)0x800000));
    }

    @Test
    public void testUnmodifiableBuffer() throws Exception {
        ByteBuf buf = Unpooled.unmodifiableBuffer((ByteBuf)Unpooled.buffer((int)16));
        try {
            buf.discardReadBytes();
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            buf.setByte(0, 0);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            buf.setBytes(0, Unpooled.EMPTY_BUFFER, 0, 0);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            buf.setBytes(0, EmptyArrays.EMPTY_BYTES, 0, 0);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            buf.setBytes(0, ByteBuffer.allocate(0));
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            buf.setShort(0, 0);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            buf.setMedium(0, 0);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            buf.setInt(0, 0);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            buf.setLong(0, 0L);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        try {
            buf.setBytes(0, inputStream, 0);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{inputStream});
        ScatteringByteChannel scatteringByteChannel = (ScatteringByteChannel)Mockito.mock(ScatteringByteChannel.class);
        try {
            buf.setBytes(0, scatteringByteChannel, 0);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{scatteringByteChannel});
        buf.release();
    }

    @Test
    public void testWrapSingleInt() {
        ByteBuf buffer = Unpooled.copyInt((int)42);
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        Assertions.assertEquals((int)42, (int)buffer.readInt());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
    }

    @Test
    public void testWrapInt() {
        ByteBuf buffer = Unpooled.copyInt((int[])new int[]{1, 4});
        Assertions.assertEquals((int)8, (int)buffer.capacity());
        Assertions.assertEquals((int)1, (int)buffer.readInt());
        Assertions.assertEquals((int)4, (int)buffer.readInt());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
        buffer = Unpooled.copyInt(null);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
        buffer = Unpooled.copyInt((int[])new int[0]);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
    }

    @Test
    public void testWrapSingleShort() {
        ByteBuf buffer = Unpooled.copyShort((int)42);
        Assertions.assertEquals((int)2, (int)buffer.capacity());
        Assertions.assertEquals((int)42, (int)buffer.readShort());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
    }

    @Test
    public void testWrapShortFromShortArray() {
        ByteBuf buffer = Unpooled.copyShort((short[])new short[]{1, 4});
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        Assertions.assertEquals((int)1, (int)buffer.readShort());
        Assertions.assertEquals((int)4, (int)buffer.readShort());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
        buffer = Unpooled.copyShort((short[])null);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
        buffer = Unpooled.copyShort((short[])new short[0]);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
    }

    @Test
    public void testWrapShortFromIntArray() {
        ByteBuf buffer = Unpooled.copyShort((int[])new int[]{1, 4});
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        Assertions.assertEquals((int)1, (int)buffer.readShort());
        Assertions.assertEquals((int)4, (int)buffer.readShort());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
        buffer = Unpooled.copyShort((int[])null);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
        buffer = Unpooled.copyShort((int[])new int[0]);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
    }

    @Test
    public void testWrapSingleMedium() {
        ByteBuf buffer = Unpooled.copyMedium((int)42);
        Assertions.assertEquals((int)3, (int)buffer.capacity());
        Assertions.assertEquals((int)42, (int)buffer.readMedium());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
    }

    @Test
    public void testWrapMedium() {
        ByteBuf buffer = Unpooled.copyMedium((int[])new int[]{1, 4});
        Assertions.assertEquals((int)6, (int)buffer.capacity());
        Assertions.assertEquals((int)1, (int)buffer.readMedium());
        Assertions.assertEquals((int)4, (int)buffer.readMedium());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
        buffer = Unpooled.copyMedium(null);
        Assertions.assertEquals((int)0, (int)Unpooled.copyMedium(null).capacity());
        buffer.release();
        buffer = Unpooled.copyMedium((int[])new int[0]);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
    }

    @Test
    public void testWrapSingleLong() {
        ByteBuf buffer = Unpooled.copyLong((long)42L);
        Assertions.assertEquals((int)8, (int)buffer.capacity());
        Assertions.assertEquals((long)42L, (long)buffer.readLong());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
    }

    @Test
    public void testWrapLong() {
        ByteBuf buffer = Unpooled.copyLong((long[])new long[]{1L, 4L});
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((long)1L, (long)buffer.readLong());
        Assertions.assertEquals((long)4L, (long)buffer.readLong());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
        buffer = Unpooled.copyLong(null);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
        buffer = Unpooled.copyLong((long[])new long[0]);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
    }

    @Test
    public void testWrapSingleFloat() {
        ByteBuf buffer = Unpooled.copyFloat((float)42.0f);
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        Assertions.assertEquals((double)42.0, (double)buffer.readFloat(), (double)0.01);
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
    }

    @Test
    public void testWrapFloat() {
        ByteBuf buffer = Unpooled.copyFloat((float[])new float[]{1.0f, 4.0f});
        Assertions.assertEquals((int)8, (int)buffer.capacity());
        Assertions.assertEquals((double)1.0, (double)buffer.readFloat(), (double)0.01);
        Assertions.assertEquals((double)4.0, (double)buffer.readFloat(), (double)0.01);
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
        buffer = Unpooled.copyFloat(null);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
        buffer = Unpooled.copyFloat((float[])new float[0]);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
    }

    @Test
    public void testWrapSingleDouble() {
        ByteBuf buffer = Unpooled.copyDouble((double)42.0);
        Assertions.assertEquals((int)8, (int)buffer.capacity());
        Assertions.assertEquals((double)42.0, (double)buffer.readDouble(), (double)0.01);
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
    }

    @Test
    public void testWrapDouble() {
        ByteBuf buffer = Unpooled.copyDouble((double[])new double[]{1.0, 4.0});
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((double)1.0, (double)buffer.readDouble(), (double)0.01);
        Assertions.assertEquals((double)4.0, (double)buffer.readDouble(), (double)0.01);
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
        buffer = Unpooled.copyDouble(null);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
        buffer = Unpooled.copyDouble((double[])new double[0]);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
    }

    @Test
    public void testWrapBoolean() {
        ByteBuf buffer = Unpooled.copyBoolean((boolean[])new boolean[]{true, false});
        Assertions.assertEquals((int)2, (int)buffer.capacity());
        Assertions.assertTrue((boolean)buffer.readBoolean());
        Assertions.assertFalse((boolean)buffer.readBoolean());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
        buffer = Unpooled.copyBoolean(null);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
        buffer = Unpooled.copyBoolean((boolean[])new boolean[0]);
        Assertions.assertEquals((int)0, (int)buffer.capacity());
        buffer.release();
    }

    @Test
    public void wrappedReadOnlyDirectBuffer() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(12);
        for (int i = 0; i < 12; ++i) {
            buffer.put((byte)i);
        }
        buffer.flip();
        ByteBuf wrapped = Unpooled.wrappedBuffer((ByteBuffer)buffer.asReadOnlyBuffer());
        for (int i = 0; i < 12; ++i) {
            Assertions.assertEquals((byte)((byte)i), (byte)wrapped.readByte());
        }
        wrapped.release();
    }

    @Test
    public void skipBytesNegativeLength() {
        final ByteBuf buf = Unpooled.buffer((int)8);
        try {
            Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    buf.skipBytes(-1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testWrapByteBufArrayStartsWithNonReadable() {
        ByteBuf buffer1 = Unpooled.buffer((int)8);
        ByteBuf buffer2 = Unpooled.buffer((int)8).writeZero(8);
        ByteBuf buffer3 = Unpooled.buffer((int)8);
        ByteBuf buffer4 = Unpooled.buffer((int)8).writeZero(8);
        ByteBuf wrapped = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{buffer1, buffer2, buffer3, buffer4});
        Assertions.assertEquals((int)16, (int)wrapped.readableBytes());
        Assertions.assertTrue((boolean)wrapped.release());
        Assertions.assertEquals((int)0, (int)buffer1.refCnt());
        Assertions.assertEquals((int)0, (int)buffer2.refCnt());
        Assertions.assertEquals((int)0, (int)buffer3.refCnt());
        Assertions.assertEquals((int)0, (int)buffer4.refCnt());
        Assertions.assertEquals((int)0, (int)wrapped.refCnt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBytesByteBuffer() {
        byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103};
        final ByteBuffer nioBuffer = ByteBuffer.allocate(bytes.length + 1);
        final ByteBuf wrappedBuffer = Unpooled.wrappedBuffer((byte[])bytes);
        try {
            Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    wrappedBuffer.getBytes(wrappedBuffer.readerIndex(), nioBuffer);
                }
            });
        }
        finally {
            wrappedBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBytesByteBuffer2() {
        byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103};
        final ByteBuffer nioBuffer = ByteBuffer.allocate(bytes.length + 1);
        final ByteBuf wrappedBuffer = Unpooled.wrappedBuffer((byte[])bytes, (int)0, (int)bytes.length);
        try {
            Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    wrappedBuffer.getBytes(wrappedBuffer.readerIndex(), nioBuffer);
                }
            });
        }
        finally {
            wrappedBuffer.release();
        }
    }

    @Test
    public void littleEndianWriteOnLittleEndianBufferMustStoreLittleEndianValue() {
        ByteBuf b = Unpooled.buffer((int)1024).order(ByteOrder.LITTLE_ENDIAN);
        b.writeShortLE(258);
        Assertions.assertEquals((short)258, (short)b.getShortLE(0));
        Assertions.assertEquals((short)258, (short)b.getShort(0));
        b.clear();
        b.writeMediumLE(66051);
        Assertions.assertEquals((int)66051, (int)b.getMediumLE(0));
        Assertions.assertEquals((int)66051, (int)b.getMedium(0));
        b.clear();
        b.writeIntLE(16909060);
        Assertions.assertEquals((int)16909060, (int)b.getIntLE(0));
        Assertions.assertEquals((int)16909060, (int)b.getInt(0));
        b.clear();
        b.writeLongLE(72623859790382856L);
        Assertions.assertEquals((long)72623859790382856L, (long)b.getLongLE(0));
        Assertions.assertEquals((long)72623859790382856L, (long)b.getLong(0));
    }

    @Test
    public void littleEndianWriteOnDefaultBufferMustStoreLittleEndianValue() {
        ByteBuf b = Unpooled.buffer((int)1024);
        b.writeShortLE(258);
        Assertions.assertEquals((short)258, (short)b.getShortLE(0));
        Assertions.assertEquals((short)513, (short)b.getShort(0));
        b.clear();
        b.writeMediumLE(66051);
        Assertions.assertEquals((int)66051, (int)b.getMediumLE(0));
        Assertions.assertEquals((int)197121, (int)b.getMedium(0));
        b.clear();
        b.writeIntLE(16909060);
        Assertions.assertEquals((int)16909060, (int)b.getIntLE(0));
        Assertions.assertEquals((int)67305985, (int)b.getInt(0));
        b.clear();
        b.writeLongLE(72623859790382856L);
        Assertions.assertEquals((long)72623859790382856L, (long)b.getLongLE(0));
        Assertions.assertEquals((long)578437695752307201L, (long)b.getLong(0));
    }
}

