/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ChannelOutboundBufferTest {
    @Test
    public void testEmptyNioBuffers() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        Assertions.assertEquals((int)0, (int)buffer.nioBufferCount());
        ByteBuffer[] buffers = buffer.nioBuffers();
        Assertions.assertNotNull((Object)buffers);
        for (ByteBuffer b : buffers) {
            Assertions.assertNull((Object)b);
        }
        Assertions.assertEquals((int)0, (int)buffer.nioBufferCount());
        ChannelOutboundBufferTest.release(buffer);
    }

    @Test
    public void testNioBuffersSingleBacked() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        Assertions.assertEquals((int)0, (int)buffer.nioBufferCount());
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)"buf1", (Charset)CharsetUtil.US_ASCII);
        ByteBuffer nioBuf = buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes());
        buffer.addMessage((Object)buf, buf.readableBytes(), channel.voidPromise());
        Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        ByteBuffer[] buffers = buffer.nioBuffers();
        Assertions.assertNotNull((Object)buffers);
        Assertions.assertEquals((int)1, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        for (int i = 0; i < buffer.nioBufferCount(); ++i) {
            if (i == 0) {
                Assertions.assertEquals((Object)buffers[i], (Object)nioBuf);
                continue;
            }
            Assertions.assertNull((Object)buffers[i]);
        }
        ChannelOutboundBufferTest.release(buffer);
    }

    @Test
    public void testNioBuffersExpand() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        ByteBuf buf = Unpooled.directBuffer().writeBytes("buf1".getBytes(CharsetUtil.US_ASCII));
        for (int i = 0; i < 64; ++i) {
            buffer.addMessage((Object)buf.copy(), buf.readableBytes(), channel.voidPromise());
        }
        Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        ByteBuffer[] buffers = buffer.nioBuffers();
        Assertions.assertEquals((int)64, (int)buffer.nioBufferCount());
        for (int i = 0; i < buffer.nioBufferCount(); ++i) {
            Assertions.assertEquals((Object)buffers[i], (Object)buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes()));
        }
        ChannelOutboundBufferTest.release(buffer);
        buf.release();
    }

    @Test
    public void testNioBuffersExpand2() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        CompositeByteBuf comp = Unpooled.compositeBuffer((int)256);
        ByteBuf buf = Unpooled.directBuffer().writeBytes("buf1".getBytes(CharsetUtil.US_ASCII));
        for (int i = 0; i < 65; ++i) {
            comp.addComponent(true, buf.copy());
        }
        buffer.addMessage((Object)comp, comp.readableBytes(), channel.voidPromise());
        Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        ByteBuffer[] buffers = buffer.nioBuffers();
        Assertions.assertEquals((int)65, (int)buffer.nioBufferCount());
        for (int i = 0; i < buffer.nioBufferCount(); ++i) {
            if (i < 65) {
                Assertions.assertEquals((Object)buffers[i], (Object)buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes()));
                continue;
            }
            Assertions.assertNull((Object)buffers[i]);
        }
        ChannelOutboundBufferTest.release(buffer);
        buf.release();
    }

    @Test
    public void testNioBuffersMaxCount() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        CompositeByteBuf comp = Unpooled.compositeBuffer((int)256);
        ByteBuf buf = Unpooled.directBuffer().writeBytes("buf1".getBytes(CharsetUtil.US_ASCII));
        for (int i = 0; i < 65; ++i) {
            comp.addComponent(true, buf.copy());
        }
        Assertions.assertEquals((int)65, (int)comp.nioBufferCount());
        buffer.addMessage((Object)comp, comp.readableBytes(), channel.voidPromise());
        Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        int maxCount = 10;
        ByteBuffer[] buffers = buffer.nioBuffers(10, Integer.MAX_VALUE);
        Assertions.assertTrue((buffer.nioBufferCount() <= 10 ? 1 : 0) != 0, (String)"Should not be greater than maxCount");
        for (int i = 0; i < buffer.nioBufferCount(); ++i) {
            Assertions.assertEquals((Object)buffers[i], (Object)buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes()));
        }
        ChannelOutboundBufferTest.release(buffer);
        buf.release();
    }

    private static void release(ChannelOutboundBuffer buffer) {
        while (buffer.remove()) {
        }
    }

    @Test
    public void testWritability() {
        final StringBuilder buf = new StringBuilder();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) {
                buf.append(ctx.channel().isWritable());
                buf.append(' ');
            }
        }});
        ch.config().setWriteBufferLowWaterMark(128 + ChannelOutboundBuffer.CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD);
        ch.config().setWriteBufferHighWaterMark(256 + ChannelOutboundBuffer.CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD);
        ch.write((Object)Unpooled.buffer().writeZero(128));
        ch.write((Object)Unpooled.buffer().writeZero(2));
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)""));
        ch.unsafe().outboundBuffer().addFlush();
        ch.write((Object)Unpooled.buffer().writeZero(127));
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false "));
        MatcherAssert.assertThat((Object)ch.unsafe().outboundBuffer().remove(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ch.unsafe().outboundBuffer().remove(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ch.unsafe().outboundBuffer().totalPendingWriteBytes(), (Matcher)Matchers.is((Object)(127L + (long)ChannelOutboundBuffer.CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD)));
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false true "));
        ChannelOutboundBufferTest.safeClose(ch);
    }

    @Test
    public void testUserDefinedWritability() {
        final StringBuilder buf = new StringBuilder();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) {
                buf.append(ctx.channel().isWritable());
                buf.append(' ');
            }
        }});
        ch.config().setWriteBufferLowWaterMark(128);
        ch.config().setWriteBufferHighWaterMark(256);
        ChannelOutboundBuffer cob = ch.unsafe().outboundBuffer();
        for (int i = 1; i <= 30; ++i) {
            MatcherAssert.assertThat((Object)cob.getUserDefinedWritability(i), (Matcher)Matchers.is((Object)true));
        }
        cob.setUserDefinedWritability(1, false);
        ch.runPendingTasks();
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false "));
        cob.setUserDefinedWritability(1, true);
        ch.runPendingTasks();
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false true "));
        ChannelOutboundBufferTest.safeClose(ch);
    }

    @Test
    public void testUserDefinedWritability2() {
        final StringBuilder buf = new StringBuilder();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) {
                buf.append(ctx.channel().isWritable());
                buf.append(' ');
            }
        }});
        ch.config().setWriteBufferLowWaterMark(128);
        ch.config().setWriteBufferHighWaterMark(256);
        ChannelOutboundBuffer cob = ch.unsafe().outboundBuffer();
        cob.setUserDefinedWritability(1, false);
        ch.runPendingTasks();
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false "));
        cob.setUserDefinedWritability(2, false);
        ch.runPendingTasks();
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false "));
        cob.setUserDefinedWritability(1, true);
        ch.runPendingTasks();
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false "));
        cob.setUserDefinedWritability(2, true);
        ch.runPendingTasks();
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false true "));
        ChannelOutboundBufferTest.safeClose(ch);
    }

    @Test
    public void testMixedWritability() {
        final StringBuilder buf = new StringBuilder();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) {
                buf.append(ctx.channel().isWritable());
                buf.append(' ');
            }
        }});
        ch.config().setWriteBufferLowWaterMark(128);
        ch.config().setWriteBufferHighWaterMark(256);
        ChannelOutboundBuffer cob = ch.unsafe().outboundBuffer();
        ch.write((Object)Unpooled.buffer().writeZero(257));
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false "));
        cob.setUserDefinedWritability(1, false);
        ch.runPendingTasks();
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false "));
        ch.flush();
        MatcherAssert.assertThat((Object)cob.totalPendingWriteBytes(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false "));
        cob.setUserDefinedWritability(1, true);
        ch.runPendingTasks();
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)Matchers.is((Object)"false true "));
        ChannelOutboundBufferTest.safeClose(ch);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testWriteTaskRejected() throws Exception {
        SingleThreadEventExecutor executor = new SingleThreadEventExecutor(null, (ThreadFactory)new DefaultThreadFactory("executorPool"), true, 1, RejectedExecutionHandlers.reject()){

            protected void run() {
                do {
                    Runnable task;
                    if ((task = this.takeTask()) == null) continue;
                    task.run();
                    this.updateLastExecutionTime();
                } while (!this.confirmShutdown());
            }

            protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
                return super.newTaskQueue(1);
            }
        };
        final CountDownLatch handlerAddedLatch = new CountDownLatch(1);
        final CountDownLatch handlerRemovedLatch = new CountDownLatch(1);
        EmbeddedChannel ch = new EmbeddedChannel();
        ch.pipeline().addLast((EventExecutorGroup)executor, "handler", (ChannelHandler)new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                promise.setFailure((Throwable)((Object)new AssertionError((Object)"Should not be called")));
            }

            public void handlerAdded(ChannelHandlerContext ctx) {
                handlerAddedLatch.countDown();
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                handlerRemovedLatch.countDown();
            }
        });
        handlerAddedLatch.await();
        final CountDownLatch executeLatch = new CountDownLatch(1);
        final CountDownLatch runLatch = new CountDownLatch(1);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runLatch.countDown();
                    executeLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        runLatch.await();
        executor.execute(new Runnable(){

            @Override
            public void run() {
            }
        });
        Assertions.assertEquals((int)1, (int)executor.pendingTasks());
        Assertions.assertEquals((long)0L, (long)ch.unsafe().outboundBuffer().totalPendingWriteBytes());
        ByteBuf buffer = Unpooled.buffer((int)128).writeZero(128);
        ChannelFuture future = ch.write((Object)buffer);
        ch.runPendingTasks();
        Assertions.assertTrue((boolean)(future.cause() instanceof RejectedExecutionException));
        Assertions.assertEquals((int)0, (int)buffer.refCnt());
        Assertions.assertEquals((long)0L, (long)ch.unsafe().outboundBuffer().totalPendingWriteBytes());
        executeLatch.countDown();
        while (executor.pendingTasks() != 0) {
            Thread.sleep(10L);
        }
        ch.pipeline().remove("handler");
        handlerRemovedLatch.await();
        ChannelOutboundBufferTest.safeClose(ch);
        executor.shutdownGracefully();
    }

    private static void safeClose(EmbeddedChannel ch) {
        ByteBuf m;
        ch.finish();
        while ((m = (ByteBuf)ch.readOutbound()) != null) {
            m.release();
        }
    }

    private static final class TestChannel
    extends AbstractChannel {
        private static final ChannelMetadata TEST_METADATA = new ChannelMetadata(false);
        private final ChannelConfig config = new DefaultChannelConfig((Channel)this);

        TestChannel() {
            super(null);
        }

        protected AbstractChannel.AbstractUnsafe newUnsafe() {
            return new TestUnsafe();
        }

        protected boolean isCompatible(EventLoop loop) {
            return false;
        }

        protected SocketAddress localAddress0() {
            throw new UnsupportedOperationException();
        }

        protected SocketAddress remoteAddress0() {
            throw new UnsupportedOperationException();
        }

        protected void doBind(SocketAddress localAddress) {
            throw new UnsupportedOperationException();
        }

        protected void doDisconnect() {
            throw new UnsupportedOperationException();
        }

        protected void doClose() {
            throw new UnsupportedOperationException();
        }

        protected void doBeginRead() {
            throw new UnsupportedOperationException();
        }

        protected void doWrite(ChannelOutboundBuffer in) {
            throw new UnsupportedOperationException();
        }

        public ChannelConfig config() {
            return this.config;
        }

        public boolean isOpen() {
            return true;
        }

        public boolean isActive() {
            return true;
        }

        public ChannelMetadata metadata() {
            return TEST_METADATA;
        }

        final class TestUnsafe
        extends AbstractChannel.AbstractUnsafe {
            TestUnsafe() {
                super((AbstractChannel)TestChannel.this);
            }

            public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

