/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class DefaultChannelPromiseTest {
    @Test
    public void testNullChannel() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DefaultChannelPromise(null);
            }
        });
    }

    @Test
    public void testChannelWithNullExecutor() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DefaultChannelPromise((Channel)new EmbeddedChannel(), null);
            }
        });
    }

    @Test
    public void testNullChannelWithExecutor() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DefaultChannelPromise(null, (EventExecutor)ImmediateEventExecutor.INSTANCE);
            }
        });
    }
}

