/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class LocalTransportThreadModelTest3 {
    private static EventLoopGroup group;
    private static LocalAddress localAddr;

    @BeforeAll
    public static void init() {
        group = new DefaultEventLoopGroup();
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        ReferenceCountUtil.release((Object)msg);
                    }
                }});
            }
        });
        localAddr = (LocalAddress)sb.bind((SocketAddress)LocalAddress.ANY).syncUninterruptibly().channel().localAddress();
    }

    @AfterAll
    public static void destroy() throws Exception {
        group.shutdownGracefully().sync();
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    @Disabled(value="regression test")
    public void testConcurrentAddRemoveInboundEventsMultiple() throws Throwable {
        for (int i = 0; i < 50; ++i) {
            this.testConcurrentAddRemoveInboundEvents();
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    @Disabled(value="regression test")
    public void testConcurrentAddRemoveOutboundEventsMultiple() throws Throwable {
        for (int i = 0; i < 50; ++i) {
            this.testConcurrentAddRemoveOutboundEvents();
        }
    }

    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    @Disabled(value="needs a fix")
    public void testConcurrentAddRemoveInboundEvents() throws Throwable {
        LocalTransportThreadModelTest3.testConcurrentAddRemove(true);
    }

    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    @Disabled(value="needs a fix")
    public void testConcurrentAddRemoveOutboundEvents() throws Throwable {
        LocalTransportThreadModelTest3.testConcurrentAddRemove(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testConcurrentAddRemove(boolean inbound) throws Exception {
        DefaultEventLoopGroup l = new DefaultEventLoopGroup(4, (ThreadFactory)new DefaultThreadFactory("l"));
        DefaultEventExecutorGroup e1 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e1"));
        DefaultEventExecutorGroup e2 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e2"));
        DefaultEventExecutorGroup e3 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e3"));
        DefaultEventExecutorGroup e4 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e4"));
        DefaultEventExecutorGroup e5 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e5"));
        EventExecutorGroup[] groups = new EventExecutorGroup[]{e1, e2, e3, e4, e5};
        try {
            ConcurrentLinkedDeque<EventType> events = new ConcurrentLinkedDeque<EventType>();
            EventForwarder h1 = new EventForwarder();
            EventForwarder h2 = new EventForwarder();
            EventForwarder h3 = new EventForwarder();
            EventForwarder h4 = new EventForwarder();
            EventForwarder h5 = new EventForwarder();
            EventRecorder h6 = new EventRecorder(events, inbound);
            LocalChannel ch = new LocalChannel();
            if (!inbound) {
                ch.config().setAutoRead(false);
            }
            ch.pipeline().addLast((EventExecutorGroup)e1, new ChannelHandler[]{h1}).addLast((EventExecutorGroup)e1, new ChannelHandler[]{h2}).addLast((EventExecutorGroup)e1, new ChannelHandler[]{h3}).addLast((EventExecutorGroup)e1, new ChannelHandler[]{h4}).addLast((EventExecutorGroup)e1, new ChannelHandler[]{h5}).addLast((EventExecutorGroup)e1, "recorder", (ChannelHandler)h6);
            l.register((Channel)ch).sync().channel().connect((SocketAddress)localAddr).sync();
            LinkedList<EventType> expectedEvents = LocalTransportThreadModelTest3.events(inbound, 8192);
            Throwable cause = new Throwable();
            Thread pipelineModifier = new Thread(new Runnable((Channel)ch, groups){
                final /* synthetic */ Channel val$ch;
                final /* synthetic */ EventExecutorGroup[] val$groups;
                {
                    this.val$ch = channel;
                    this.val$groups = eventExecutorGroupArray;
                }

                @Override
                public void run() {
                    Random random = new Random();
                    while (true) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (!this.val$ch.isRegistered()) continue;
                        ChannelHandler handler = this.val$ch.pipeline().removeFirst();
                        this.val$ch.pipeline().addBefore(this.val$groups[random.nextInt(this.val$groups.length)], "recorder", UUID.randomUUID().toString(), handler);
                    }
                }
            });
            pipelineModifier.setDaemon(true);
            pipelineModifier.start();
            for (EventType event : expectedEvents) {
                switch (event) {
                    case EXCEPTION_CAUGHT: {
                        ch.pipeline().fireExceptionCaught(cause);
                        break;
                    }
                    case MESSAGE_RECEIVED: {
                        ch.pipeline().fireChannelRead((Object)"");
                        break;
                    }
                    case MESSAGE_RECEIVED_LAST: {
                        ch.pipeline().fireChannelReadComplete();
                        break;
                    }
                    case USER_EVENT: {
                        ch.pipeline().fireUserEventTriggered((Object)"");
                        break;
                    }
                    case WRITE: {
                        ch.pipeline().write((Object)"");
                        break;
                    }
                    case READ: {
                        ch.pipeline().read();
                    }
                }
            }
            ch.close().sync();
            while (events.peekLast() != EventType.UNREGISTERED) {
                Thread.sleep(10L);
            }
            expectedEvents.addFirst(EventType.ACTIVE);
            expectedEvents.addFirst(EventType.REGISTERED);
            expectedEvents.addLast(EventType.INACTIVE);
            expectedEvents.addLast(EventType.UNREGISTERED);
            while (true) {
                EventType event;
                if ((event = (EventType)((Object)events.poll())) == null) {
                    Assertions.assertTrue((boolean)expectedEvents.isEmpty(), (String)("Missing events:" + expectedEvents));
                    break;
                }
                Assertions.assertEquals((Object)((Object)event), (Object)((Object)expectedEvents.poll()));
            }
        }
        finally {
            l.shutdownGracefully();
            e1.shutdownGracefully();
            e2.shutdownGracefully();
            e3.shutdownGracefully();
            e4.shutdownGracefully();
            e5.shutdownGracefully();
            l.terminationFuture().sync();
            e1.terminationFuture().sync();
            e2.terminationFuture().sync();
            e3.terminationFuture().sync();
            e4.terminationFuture().sync();
            e5.terminationFuture().sync();
        }
    }

    private static LinkedList<EventType> events(boolean inbound, int size) {
        EventType[] events = inbound ? new EventType[]{EventType.USER_EVENT, EventType.MESSAGE_RECEIVED, EventType.MESSAGE_RECEIVED_LAST, EventType.EXCEPTION_CAUGHT} : new EventType[]{EventType.READ, EventType.WRITE, EventType.EXCEPTION_CAUGHT};
        Random random = new Random();
        LinkedList<EventType> expectedEvents = new LinkedList<EventType>();
        for (int i = 0; i < size; ++i) {
            expectedEvents.add(events[random.nextInt(events.length)]);
        }
        return expectedEvents;
    }

    private static final class EventRecorder
    extends ChannelDuplexHandler {
        private final Queue<EventType> events;
        private final boolean inbound;

        EventRecorder(Queue<EventType> events, boolean inbound) {
            this.events = events;
            this.inbound = inbound;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.events.add(EventType.EXCEPTION_CAUGHT);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (this.inbound) {
                this.events.add(EventType.USER_EVENT);
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (this.inbound) {
                this.events.add(EventType.MESSAGE_RECEIVED_LAST);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.events.add(EventType.INACTIVE);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.events.add(EventType.ACTIVE);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            this.events.add(EventType.UNREGISTERED);
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            this.events.add(EventType.REGISTERED);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (this.inbound) {
                this.events.add(EventType.MESSAGE_RECEIVED);
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (!this.inbound) {
                this.events.add(EventType.WRITE);
            }
            promise.setSuccess();
        }

        public void read(ChannelHandlerContext ctx) {
            if (!this.inbound) {
                this.events.add(EventType.READ);
            }
        }
    }

    @ChannelHandler.Sharable
    private static final class EventForwarder
    extends ChannelDuplexHandler {
        private EventForwarder() {
        }
    }

    static enum EventType {
        EXCEPTION_CAUGHT,
        USER_EVENT,
        MESSAGE_RECEIVED_LAST,
        INACTIVE,
        ACTIVE,
        UNREGISTERED,
        REGISTERED,
        MESSAGE_RECEIVED,
        WRITE,
        READ;

    }
}

