/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.EmptyHeaders;
import io.netty.handler.codec.Headers;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class EmptyHeadersTest {
    private static final TestEmptyHeaders HEADERS = new TestEmptyHeaders();

    @Test
    public void testAddStringValue() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.add("name", "value");
            }
        });
    }

    @Test
    public void testAddStringValues() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.add("name", new String[]{"value1", "value2"});
            }
        });
    }

    @Test
    public void testAddStringValuesIterable() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.add("name", Arrays.asList("value1", "value2"));
            }
        });
    }

    @Test
    public void testAddBoolean() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.addBoolean("name", true);
            }
        });
    }

    @Test
    public void testAddByte() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.addByte("name", (byte)1);
            }
        });
    }

    @Test
    public void testAddChar() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.addChar("name", 'a');
            }
        });
    }

    @Test
    public void testAddDouble() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.addDouble("name", 0.0);
            }
        });
    }

    @Test
    public void testAddFloat() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.addFloat("name", 0.0f);
            }
        });
    }

    @Test
    public void testAddInt() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.addInt("name", 0);
            }
        });
    }

    @Test
    public void testAddLong() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.addLong("name", 0L);
            }
        });
    }

    @Test
    public void testAddShort() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.addShort("name", (short)0);
            }
        });
    }

    @Test
    public void testAddTimeMillis() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.addTimeMillis("name", 0L);
            }
        });
    }

    @Test
    public void testSetStringValue() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.set("name", "value");
            }
        });
    }

    @Test
    public void testSetStringValues() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.set("name", new String[]{"value1", "value2"});
            }
        });
    }

    @Test
    public void testSetStringValuesIterable() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.set("name", Arrays.asList("value1", "value2"));
            }
        });
    }

    @Test
    public void testSetBoolean() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.setBoolean("name", true);
            }
        });
    }

    @Test
    public void testSetByte() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.setByte("name", (byte)1);
            }
        });
    }

    @Test
    public void testSetChar() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.setChar("name", 'a');
            }
        });
    }

    @Test
    public void testSetDouble() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.setDouble("name", 0.0);
            }
        });
    }

    @Test
    public void testSetFloat() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.setFloat("name", 0.0f);
            }
        });
    }

    @Test
    public void testSetInt() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.setInt("name", 0);
            }
        });
    }

    @Test
    public void testSetLong() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.setLong("name", 0L);
            }
        });
    }

    @Test
    public void testSetShort() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.setShort("name", (short)0);
            }
        });
    }

    @Test
    public void testSetTimeMillis() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.setTimeMillis("name", 0L);
            }
        });
    }

    @Test
    public void testSetAll() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.setAll((Headers)new TestEmptyHeaders());
            }
        });
    }

    @Test
    public void testSet() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                HEADERS.set((Headers)new TestEmptyHeaders());
            }
        });
    }

    @Test
    public void testGet() {
        Assertions.assertNull((Object)HEADERS.get("name1"));
    }

    @Test
    public void testGetDefault() {
        Assertions.assertEquals((Object)"default", (Object)HEADERS.get("name1", "default"));
    }

    @Test
    public void testGetAndRemove() {
        Assertions.assertNull((Object)HEADERS.getAndRemove("name1"));
    }

    @Test
    public void testGetAndRemoveDefault() {
        Assertions.assertEquals((Object)"default", (Object)HEADERS.getAndRemove("name1", "default"));
    }

    @Test
    public void testGetAll() {
        Assertions.assertEquals(Collections.emptyList(), (Object)HEADERS.getAll("name1"));
    }

    @Test
    public void testGetAllAndRemove() {
        Assertions.assertEquals(Collections.emptyList(), (Object)HEADERS.getAllAndRemove("name1"));
    }

    @Test
    public void testGetBoolean() {
        Assertions.assertNull((Object)HEADERS.getBoolean("name1"));
    }

    @Test
    public void testGetBooleanDefault() {
        Assertions.assertTrue((boolean)HEADERS.getBoolean("name1", true));
    }

    @Test
    public void testGetBooleanAndRemove() {
        Assertions.assertNull((Object)HEADERS.getBooleanAndRemove("name1"));
    }

    @Test
    public void testGetBooleanAndRemoveDefault() {
        Assertions.assertTrue((boolean)HEADERS.getBooleanAndRemove("name1", true));
    }

    @Test
    public void testGetByte() {
        Assertions.assertNull((Object)HEADERS.getByte("name1"));
    }

    @Test
    public void testGetByteDefault() {
        Assertions.assertEquals((byte)0, (byte)HEADERS.getByte("name1", (byte)0));
    }

    @Test
    public void testGetByteAndRemove() {
        Assertions.assertNull((Object)HEADERS.getByteAndRemove("name1"));
    }

    @Test
    public void testGetByteAndRemoveDefault() {
        Assertions.assertEquals((byte)0, (byte)HEADERS.getByteAndRemove("name1", (byte)0));
    }

    @Test
    public void testGetChar() {
        Assertions.assertNull((Object)HEADERS.getChar("name1"));
    }

    @Test
    public void testGetCharDefault() {
        Assertions.assertEquals((char)'x', (char)HEADERS.getChar("name1", 'x'));
    }

    @Test
    public void testGetCharAndRemove() {
        Assertions.assertNull((Object)HEADERS.getCharAndRemove("name1"));
    }

    @Test
    public void testGetCharAndRemoveDefault() {
        Assertions.assertEquals((char)'x', (char)HEADERS.getCharAndRemove("name1", 'x'));
    }

    @Test
    public void testGetDouble() {
        Assertions.assertNull((Object)HEADERS.getDouble("name1"));
    }

    @Test
    public void testGetDoubleDefault() {
        Assertions.assertEquals((double)1.0, (double)HEADERS.getDouble("name1", 1.0), (double)0.0);
    }

    @Test
    public void testGetDoubleAndRemove() {
        Assertions.assertNull((Object)HEADERS.getDoubleAndRemove("name1"));
    }

    @Test
    public void testGetDoubleAndRemoveDefault() {
        Assertions.assertEquals((double)1.0, (double)HEADERS.getDoubleAndRemove("name1", 1.0), (double)0.0);
    }

    @Test
    public void testGetFloat() {
        Assertions.assertNull((Object)HEADERS.getFloat("name1"));
    }

    @Test
    public void testGetFloatDefault() {
        Assertions.assertEquals((float)1.0f, (float)HEADERS.getFloat("name1", 1.0f), (float)0.0f);
    }

    @Test
    public void testGetFloatAndRemove() {
        Assertions.assertNull((Object)HEADERS.getFloatAndRemove("name1"));
    }

    @Test
    public void testGetFloatAndRemoveDefault() {
        Assertions.assertEquals((float)1.0f, (float)HEADERS.getFloatAndRemove("name1", 1.0f), (float)0.0f);
    }

    @Test
    public void testGetInt() {
        Assertions.assertNull((Object)HEADERS.getInt("name1"));
    }

    @Test
    public void testGetIntDefault() {
        Assertions.assertEquals((int)1, (int)HEADERS.getInt("name1", 1));
    }

    @Test
    public void testGetIntAndRemove() {
        Assertions.assertNull((Object)HEADERS.getIntAndRemove("name1"));
    }

    @Test
    public void testGetIntAndRemoveDefault() {
        Assertions.assertEquals((int)1, (int)HEADERS.getIntAndRemove("name1", 1));
    }

    @Test
    public void testGetLong() {
        Assertions.assertNull((Object)HEADERS.getLong("name1"));
    }

    @Test
    public void testGetLongDefault() {
        Assertions.assertEquals((long)1L, (long)HEADERS.getLong("name1", 1L));
    }

    @Test
    public void testGetLongAndRemove() {
        Assertions.assertNull((Object)HEADERS.getLongAndRemove("name1"));
    }

    @Test
    public void testGetLongAndRemoveDefault() {
        Assertions.assertEquals((long)1L, (long)HEADERS.getLongAndRemove("name1", 1L));
    }

    @Test
    public void testGetShort() {
        Assertions.assertNull((Object)HEADERS.getShort("name1"));
    }

    @Test
    public void testGetShortDefault() {
        Assertions.assertEquals((int)1, (int)HEADERS.getShort("name1", (short)1));
    }

    @Test
    public void testGetShortAndRemove() {
        Assertions.assertNull((Object)HEADERS.getShortAndRemove("name1"));
    }

    @Test
    public void testGetShortAndRemoveDefault() {
        Assertions.assertEquals((int)1, (int)HEADERS.getShortAndRemove("name1", (short)1));
    }

    @Test
    public void testGetTimeMillis() {
        Assertions.assertNull((Object)HEADERS.getTimeMillis("name1"));
    }

    @Test
    public void testGetTimeMillisDefault() {
        Assertions.assertEquals((long)1L, (long)HEADERS.getTimeMillis("name1", 1L));
    }

    @Test
    public void testGetTimeMillisAndRemove() {
        Assertions.assertNull((Object)HEADERS.getTimeMillisAndRemove("name1"));
    }

    @Test
    public void testGetTimeMillisAndRemoveDefault() {
        Assertions.assertEquals((long)1L, (long)HEADERS.getTimeMillisAndRemove("name1", 1L));
    }

    @Test
    public void testContains() {
        Assertions.assertFalse((boolean)HEADERS.contains("name1"));
    }

    @Test
    public void testContainsWithValue() {
        Assertions.assertFalse((boolean)HEADERS.contains("name1", "value1"));
    }

    @Test
    public void testContainsBoolean() {
        Assertions.assertFalse((boolean)HEADERS.containsBoolean("name1", false));
    }

    @Test
    public void testContainsByte() {
        Assertions.assertFalse((boolean)HEADERS.containsByte("name1", (byte)120));
    }

    @Test
    public void testContainsChar() {
        Assertions.assertFalse((boolean)HEADERS.containsChar("name1", 'x'));
    }

    @Test
    public void testContainsDouble() {
        Assertions.assertFalse((boolean)HEADERS.containsDouble("name1", 1.0));
    }

    @Test
    public void testContainsFloat() {
        Assertions.assertFalse((boolean)HEADERS.containsFloat("name1", 1.0f));
    }

    @Test
    public void testContainsInt() {
        Assertions.assertFalse((boolean)HEADERS.containsInt("name1", 1));
    }

    @Test
    public void testContainsLong() {
        Assertions.assertFalse((boolean)HEADERS.containsLong("name1", 1L));
    }

    @Test
    public void testContainsShort() {
        Assertions.assertFalse((boolean)HEADERS.containsShort("name1", (short)1));
    }

    @Test
    public void testContainsTimeMillis() {
        Assertions.assertFalse((boolean)HEADERS.containsTimeMillis("name1", 1L));
    }

    @Test
    public void testContainsObject() {
        Assertions.assertFalse((boolean)HEADERS.containsObject("name1", ""));
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)HEADERS.isEmpty());
    }

    @Test
    public void testClear() {
        Assertions.assertSame((Object)((Object)HEADERS), (Object)HEADERS.clear());
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)0, (int)HEADERS.size());
    }

    @Test
    public void testValueIterator() {
        Assertions.assertFalse((boolean)HEADERS.valueIterator("name1").hasNext());
    }

    private static final class TestEmptyHeaders
    extends EmptyHeaders<String, String, TestEmptyHeaders> {
        private TestEmptyHeaders() {
        }
    }
}

