/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.decoder.Decoder;
import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import com.aayushatharva.brotli4j.decoder.DirectDecompress;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractEncoderTest;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliEncoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.util.internal.PlatformDependent;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.condition.DisabledIf;

@DisabledIf(value="isNotSupported", disabledReason="Brotli is not supported on this platform")
public class BrotliEncoderTest
extends AbstractEncoderTest {
    @BeforeAll
    static void setUp() {
        try {
            Brotli.ensureAvailability();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
    }

    @Override
    public EmbeddedChannel createChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new BrotliEncoder()});
    }

    @Override
    protected ByteBuf decompress(ByteBuf compressed, int originalLength) throws Exception {
        byte[] compressedArray = new byte[compressed.readableBytes()];
        compressed.readBytes(compressedArray);
        compressed.release();
        DirectDecompress decompress = Decoder.decompress((byte[])compressedArray);
        if (decompress.getResultStatus() == DecoderJNI.Status.ERROR) {
            throw new DecompressionException("Brotli stream corrupted");
        }
        byte[] decompressed = decompress.getDecompressedData();
        return Unpooled.wrappedBuffer((byte[])decompressed);
    }

    @Override
    protected ByteBuf readDecompressed(int dataLength) throws Exception {
        ByteBuf msg;
        CompositeByteBuf decompressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)this.channel.readOutbound()) != null) {
            if (msg.isReadable()) {
                decompressed.addComponent(true, this.decompress(msg, -1));
                continue;
            }
            msg.release();
        }
        return decompressed;
    }

    static boolean isNotSupported() {
        return PlatformDependent.isOsx() && "aarch_64".equals(PlatformDependent.normalizedArch());
    }
}

