/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractIntegrationTest;
import io.netty.handler.codec.compression.FastLzFrameDecoder;
import io.netty.handler.codec.compression.FastLzFrameEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class FastLzIntegrationTest
extends AbstractIntegrationTest {
    @Override
    protected EmbeddedChannel createEncoder() {
        return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameEncoder(rand.nextBoolean())});
    }

    @Override
    protected EmbeddedChannel createDecoder() {
        return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameDecoder(rand.nextBoolean())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void testIdentity(byte[] data, boolean heapBuffer) {
        this.initChannels();
        ByteBuf original = heapBuffer ? Unpooled.wrappedBuffer((byte[])data) : Unpooled.directBuffer((int)data.length).writeBytes(data);
        CompositeByteBuf compressed = Unpooled.compositeBuffer();
        CompositeByteBuf decompressed = Unpooled.compositeBuffer();
        try {
            ByteBuf msg;
            ByteBuf in;
            int written = 0;
            int length = rand.nextInt(100);
            while (written + length < data.length) {
                in = Unpooled.wrappedBuffer((byte[])data, (int)written, (int)length);
                this.encoder.writeOutbound(new Object[]{in});
                written += length;
                length = rand.nextInt(100);
            }
            in = Unpooled.wrappedBuffer((byte[])data, (int)written, (int)(data.length - written));
            this.encoder.writeOutbound(new Object[]{in});
            this.encoder.finish();
            while ((msg = (ByteBuf)this.encoder.readOutbound()) != null) {
                compressed.addComponent(true, msg);
            }
            MatcherAssert.assertThat((Object)compressed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            byte[] compressedArray = new byte[compressed.readableBytes()];
            compressed.readBytes(compressedArray);
            written = 0;
            length = rand.nextInt(100);
            while (written + length < compressedArray.length) {
                in = Unpooled.wrappedBuffer((byte[])compressedArray, (int)written, (int)length);
                this.decoder.writeInbound(new Object[]{in});
                written += length;
                length = rand.nextInt(100);
            }
            in = Unpooled.wrappedBuffer((byte[])compressedArray, (int)written, (int)(compressedArray.length - written));
            this.decoder.writeInbound(new Object[]{in});
            Assertions.assertFalse((boolean)compressed.isReadable());
            while ((msg = (ByteBuf)this.decoder.readInbound()) != null) {
                decompressed.addComponent(true, msg);
            }
            Assertions.assertEquals((Object)original, (Object)decompressed);
        }
        finally {
            compressed.release();
            decompressed.release();
            original.release();
            this.closeChannels();
        }
    }

    public static class TestRandomChecksum
    extends AbstractIntegrationTest {
        @Override
        protected EmbeddedChannel createEncoder() {
            return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameEncoder(rand.nextBoolean())});
        }

        @Override
        protected EmbeddedChannel createDecoder() {
            return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameDecoder(rand.nextBoolean())});
        }
    }

    public static class TestWithChecksum
    extends AbstractIntegrationTest {
        @Override
        protected EmbeddedChannel createEncoder() {
            return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameEncoder(true)});
        }

        @Override
        protected EmbeddedChannel createDecoder() {
            return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameDecoder(true)});
        }
    }
}

