/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpInvalidMessageTest {
    private final Random rnd = new Random();

    @Test
    public void testRequestWithBadInitialLine() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET / HTTP/1.0 with extra\r\n", (Charset)CharsetUtil.UTF_8)});
        HttpRequest req = (HttpRequest)ch.readInbound();
        DecoderResult dr = req.decoderResult();
        Assertions.assertFalse((boolean)dr.isSuccess());
        Assertions.assertTrue((boolean)dr.isFailure());
        this.ensureInboundTrafficDiscarded(ch);
    }

    @Test
    public void testRequestWithBadHeader() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET /maybe-something HTTP/1.0\r\n", (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"Good_Name: Good Value\r\n", (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"Bad=Name: Bad Value\r\n", (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.UTF_8)});
        HttpRequest req = (HttpRequest)ch.readInbound();
        DecoderResult dr = req.decoderResult();
        Assertions.assertFalse((boolean)dr.isSuccess());
        Assertions.assertTrue((boolean)dr.isFailure());
        Assertions.assertEquals((Object)"Good Value", (Object)req.headers().get(HttpHeadersTestUtils.of("Good_Name")));
        Assertions.assertEquals((Object)"/maybe-something", (Object)req.uri());
        this.ensureInboundTrafficDiscarded(ch);
    }

    @Test
    public void testResponseWithBadInitialLine() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.0 BAD_CODE Bad Server\r\n", (Charset)CharsetUtil.UTF_8)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        DecoderResult dr = res.decoderResult();
        Assertions.assertFalse((boolean)dr.isSuccess());
        Assertions.assertTrue((boolean)dr.isFailure());
        this.ensureInboundTrafficDiscarded(ch);
    }

    @Test
    public void testResponseWithBadHeader() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.0 200 Maybe OK\r\n", (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"Good_Name: Good Value\r\n", (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"Bad=Name: Bad Value\r\n", (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.UTF_8)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        DecoderResult dr = res.decoderResult();
        Assertions.assertFalse((boolean)dr.isSuccess());
        Assertions.assertTrue((boolean)dr.isFailure());
        Assertions.assertEquals((Object)"Maybe OK", (Object)res.status().reasonPhrase());
        Assertions.assertEquals((Object)"Good Value", (Object)res.headers().get(HttpHeadersTestUtils.of("Good_Name")));
        this.ensureInboundTrafficDiscarded(ch);
    }

    @Test
    public void testBadChunk() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET / HTTP/1.0\r\n", (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"Transfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"BAD_LENGTH\r\n", (Charset)CharsetUtil.UTF_8)});
        HttpRequest req = (HttpRequest)ch.readInbound();
        Assertions.assertTrue((boolean)req.decoderResult().isSuccess());
        LastHttpContent chunk = (LastHttpContent)ch.readInbound();
        DecoderResult dr = chunk.decoderResult();
        Assertions.assertFalse((boolean)dr.isSuccess());
        Assertions.assertTrue((boolean)dr.isFailure());
        this.ensureInboundTrafficDiscarded(ch);
    }

    private void ensureInboundTrafficDiscarded(EmbeddedChannel ch) {
        byte[] data = new byte[0x100000];
        this.rnd.nextBytes(data);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
        for (int i = 0; i < 4096; ++i) {
            buf.setIndex(0, data.length);
            ch.writeInbound(new Object[]{buf.retain()});
            ch.checkException();
            Assertions.assertNull((Object)ch.readInbound());
        }
        buf.release();
    }
}

