/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMessageDecoderResult;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpResponseDecoderTest {
    @Test
    public void testMaxHeaderSize1() {
        int maxHeaderSize = 8192;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(4096, 8192, 8192)});
        char[] bytes = new char[4092];
        Arrays.fill(bytes, 'a');
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"A:", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"B:", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        Assertions.assertNull((Object)res.decoderResult().cause());
        Assertions.assertTrue((boolean)res.decoderResult().isSuccess());
        Assertions.assertNull((Object)ch.readInbound());
        Assertions.assertTrue((boolean)ch.finish());
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.instanceOf(LastHttpContent.class));
    }

    @Test
    public void testMaxHeaderSize2() {
        int maxHeaderSize = 8192;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(4096, 8192, 8192)});
        char[] bytes = new char[4094];
        Arrays.fill(bytes, 'a');
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"A:", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"B: ", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        Assertions.assertTrue((boolean)(res.decoderResult().cause() instanceof TooLongHttpHeaderException));
        Assertions.assertFalse((boolean)ch.finish());
        Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testResponseChunked() {
        int i;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        byte[] data = new byte[64];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(data.length) + "\r\n"), (Charset)CharsetUtil.US_ASCII)}));
            Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)}));
            HttpContent content = (HttpContent)ch.readInbound();
            Assertions.assertEquals((int)data.length, (int)content.content().readableBytes());
            byte[] decodedData = new byte[data.length];
            content.content().readBytes(decodedData);
            Assertions.assertArrayEquals((byte[])data, (byte[])decodedData);
            content.release();
            Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        Assertions.assertFalse((boolean)content.content().isReadable());
        content.release();
        ch.finish();
        Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testResponseDisallowPartialChunks() {
        HttpResponseDecoder decoder = new HttpResponseDecoder(4096, 8192, 8192, true, 128, false, false);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{decoder});
        String headers = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n";
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)headers, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        byte[] chunkBytes = new byte[10];
        Random random = new Random();
        random.nextBytes(chunkBytes);
        ByteBuf chunk = ch.alloc().buffer().writeBytes(chunkBytes);
        int chunkSize = chunk.readableBytes();
        ByteBuf partialChunk1 = chunk.retainedSlice(0, 5);
        ByteBuf partialChunk2 = chunk.retainedSlice(5, 5);
        Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(chunkSize) + "\r\n"), (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{partialChunk1}));
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{partialChunk2}));
        HttpContent content = (HttpContent)ch.readInbound();
        Assertions.assertEquals((Object)chunk, (Object)content.content());
        content.release();
        chunk.release();
        Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        HttpContent lastContent = (HttpContent)ch.readInbound();
        Assertions.assertFalse((boolean)lastContent.content().isReadable());
        lastContent.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testResponseChunkedExceedMaxChunkSize() {
        int i;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(4096, 8192, 32)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        byte[] data = new byte[64];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(data.length) + "\r\n"), (Charset)CharsetUtil.US_ASCII)}));
            Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)}));
            byte[] decodedData = new byte[data.length];
            HttpContent content = (HttpContent)ch.readInbound();
            Assertions.assertEquals((int)32, (int)content.content().readableBytes());
            content.content().readBytes(decodedData, 0, 32);
            content.release();
            content = (HttpContent)ch.readInbound();
            Assertions.assertEquals((int)32, (int)content.content().readableBytes());
            content.content().readBytes(decodedData, 32, 32);
            Assertions.assertArrayEquals((byte[])data, (byte[])decodedData);
            content.release();
            Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        Assertions.assertFalse((boolean)content.content().isReadable());
        content.release();
        ch.finish();
        Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testClosureWithoutContentLength1() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertTrue((boolean)ch.finish());
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        content.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testClosureWithoutContentLength2() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n12345678", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"12345678"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(LastHttpContent.class))));
        content.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertTrue((boolean)ch.finish());
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testPrematureClosureWithChunkedEncoding1() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Object)"chunked"));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.finish();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testPrematureClosureWithChunkedEncoding2() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n8\r\n12345678", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Object)"chunked"));
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"12345678"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(LastHttpContent.class))));
        content.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.finish();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testLastResponseWithEmptyHeaderAndEmptyContent() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)true));
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        content.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testLastResponseWithoutContentLengthHeader() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[1024])});
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().readableBytes(), (Matcher)CoreMatchers.is((Object)1024));
        content.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)true));
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testLastResponseWithHeaderRemoveTrailingSpaces() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nX-Header: h2=h2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT       \r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)res.headers().get(HttpHeadersTestUtils.of("X-Header")), (Matcher)CoreMatchers.is((Object)"h2=h2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT"));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[1024])});
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().readableBytes(), (Matcher)CoreMatchers.is((Object)1024));
        content.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)true));
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testResetContentResponseWithTransferEncoding() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 205 Reset Content\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.RESET_CONTENT));
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testLastResponseWithTrailingHeader() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n0\r\nSet-Cookie: t1=t1v1\r\nSet-Cookie: t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        HttpHeaders headers = lastContent.trailingHeaders();
        Assertions.assertEquals((int)1, (int)headers.names().size());
        List values = headers.getAll(HttpHeadersTestUtils.of("Set-Cookie"));
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertTrue((boolean)values.contains("t1=t1v1"));
        Assertions.assertTrue((boolean)values.contains("t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT"));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testLastResponseWithTrailingHeaderFragmented() {
        byte[] data = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n0\r\nSet-Cookie: t1=t1v1\r\nSet-Cookie: t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT\r\n\r\n".getBytes(CharsetUtil.US_ASCII);
        for (int i = 1; i < data.length; ++i) {
            HttpResponseDecoderTest.testLastResponseWithTrailingHeaderFragmented(data, i);
        }
    }

    private static void testLastResponseWithTrailingHeaderFragmented(byte[] content, int fragmentSize) {
        int amount;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        int headerLength = 47;
        for (int a = 0; a < headerLength; a += amount) {
            amount = fragmentSize;
            if (a + amount > headerLength) {
                amount = headerLength - a;
            }
            boolean headerDone = a + amount == headerLength;
            Assertions.assertEquals((Object)headerDone, (Object)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content, (int)a, (int)amount)}));
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content, (int)headerLength, (int)(content.length - headerLength))});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        HttpHeaders headers = lastContent.trailingHeaders();
        Assertions.assertEquals((int)1, (int)headers.names().size());
        List values = headers.getAll(HttpHeadersTestUtils.of("Set-Cookie"));
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertTrue((boolean)values.contains("t1=t1v1"));
        Assertions.assertTrue((boolean)values.contains("t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT"));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testResponseWithContentLength() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nContent-Length: 10\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        byte[] data = new byte[10];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)0, (int)(data.length / 2))});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)5, (int)(data.length / 2))});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        HttpContent firstContent = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)firstContent.content().readableBytes(), (Matcher)CoreMatchers.is((Object)5));
        Assertions.assertEquals((Object)Unpooled.copiedBuffer((byte[])data, (int)0, (int)5), (Object)firstContent.content());
        firstContent.release();
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        Assertions.assertEquals((int)5, (int)lastContent.content().readableBytes());
        Assertions.assertEquals((Object)Unpooled.copiedBuffer((byte[])data, (int)5, (int)5), (Object)lastContent.content());
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testResponseWithContentLengthFragmented() {
        byte[] data = "HTTP/1.1 200 OK\r\nContent-Length: 10\r\n\r\n".getBytes(CharsetUtil.US_ASCII);
        for (int i = 1; i < data.length; ++i) {
            HttpResponseDecoderTest.testResponseWithContentLengthFragmented(data, i);
        }
    }

    private static void testResponseWithContentLengthFragmented(byte[] header, int fragmentSize) {
        int amount;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        for (int a = 0; a < header.length; a += amount) {
            amount = fragmentSize;
            if (a + amount > header.length) {
                amount = header.length - a;
            }
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header, (int)a, (int)amount)});
        }
        byte[] data = new byte[10];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)0, (int)(data.length / 2))});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)5, (int)(data.length / 2))});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        HttpContent firstContent = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)firstContent.content().readableBytes(), (Matcher)CoreMatchers.is((Object)5));
        Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data, (int)0, (int)5), (Object)firstContent.content());
        firstContent.release();
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        Assertions.assertEquals((int)5, (int)lastContent.content().readableBytes());
        Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data, (int)5, (int)5), (Object)lastContent.content());
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testWebSocketResponse() {
        byte[] data = "HTTP/1.1 101 WebSocket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Origin: http://localhost:8080\r\nSec-WebSocket-Location: ws://localhost/some/path\r\n\r\n1234567812345678".getBytes();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])data)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.SWITCHING_PROTOCOLS));
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().readableBytes(), (Matcher)CoreMatchers.is((Object)16));
        content.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebSocketResponseWithDataFollowing() {
        byte[] data = "HTTP/1.1 101 WebSocket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Origin: http://localhost:8080\r\nSec-WebSocket-Location: ws://localhost/some/path\r\n\r\n1234567812345678".getBytes();
        byte[] otherData = new byte[]{1, 2, 3, 4};
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[][])new byte[][]{data, otherData})});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.SWITCHING_PROTOCOLS));
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().readableBytes(), (Matcher)CoreMatchers.is((Object)16));
        content.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)true));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])otherData);
        ByteBuf buffer = (ByteBuf)ch.readInbound();
        try {
            Assertions.assertEquals((Object)expected, (Object)buffer);
        }
        finally {
            expected.release();
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    @Test
    public void testGarbageHeaders() {
        byte[] data = "<html>\r\n<head><title>400 Bad Request</title></head>\r\n<body bgcolor=\"white\">\r\n<center><h1>400 Bad Request</h1></center>\r\n<hr><center>nginx/1.1.19</center>\r\n</body>\r\n</html>\r\n".getBytes();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_0));
        MatcherAssert.assertThat((Object)res.status().code(), (Matcher)CoreMatchers.is((Object)999));
        MatcherAssert.assertThat((Object)res.decoderResult().isFailure(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)res.decoderResult().isFinished(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)});
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.finish();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testGarbageChunk() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseWithIllegalChunk = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\nNOT_A_CHUNK_LENGTH\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseWithIllegalChunk, (Charset)CharsetUtil.US_ASCII)});
        MatcherAssert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpResponse.class)));
        LastHttpContent invalidChunk = (LastHttpContent)channel.readInbound();
        MatcherAssert.assertThat((Object)invalidChunk.decoderResult().isFailure(), (Matcher)CoreMatchers.is((Object)true));
        invalidChunk.release();
        MatcherAssert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testConnectionClosedBeforeHeadersReceived() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseInitialLine = "HTTP/1.1 200 OK\r\n";
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseInitialLine, (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertTrue((boolean)channel.finish());
        HttpMessage message = (HttpMessage)channel.readInbound();
        Assertions.assertTrue((boolean)message.decoderResult().isFailure());
        MatcherAssert.assertThat((Object)message.decoderResult().cause(), (Matcher)CoreMatchers.instanceOf(PrematureChannelClosureException.class));
        Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testTrailerWithEmptyLineInSeparateBuffer() {
        HttpResponseDecoder decoder = new HttpResponseDecoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
        String headers = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\nTrailer: My-Trailer\r\n";
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])headers.getBytes(CharsetUtil.US_ASCII))}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])"\r\n".getBytes(CharsetUtil.US_ASCII))}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"My-Trailer: 42\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        Assertions.assertEquals((int)2, (int)response.headers().size());
        Assertions.assertEquals((Object)"chunked", (Object)response.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        Assertions.assertEquals((Object)"My-Trailer", (Object)response.headers().get((CharSequence)HttpHeaderNames.TRAILER));
        LastHttpContent lastContent = (LastHttpContent)channel.readInbound();
        Assertions.assertEquals((int)1, (int)lastContent.trailingHeaders().size());
        Assertions.assertEquals((Object)"42", (Object)lastContent.trailingHeaders().get("My-Trailer"));
        Assertions.assertEquals((int)0, (int)lastContent.content().readableBytes());
        lastContent.release();
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testWhitespace() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String requestStr = "HTTP/1.1 200 OK\r\nTransfer-Encoding : chunked\r\nHost: netty.io\n\r\n";
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        Assertions.assertFalse((boolean)response.decoderResult().isFailure());
        Assertions.assertEquals((Object)HttpHeaderValues.CHUNKED.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        Assertions.assertEquals((Object)"netty.io", (Object)response.headers().get((CharSequence)HttpHeaderNames.HOST));
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testHttpMessageDecoderResult() {
        String responseStr = "HTTP/1.1 200 OK\r\nContent-Length: 11\r\nConnection: close\r\n\r\nLorem ipsum";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        Assertions.assertTrue((boolean)response.decoderResult().isSuccess());
        MatcherAssert.assertThat((Object)response.decoderResult(), (Matcher)CoreMatchers.instanceOf(HttpMessageDecoderResult.class));
        HttpMessageDecoderResult decoderResult = (HttpMessageDecoderResult)response.decoderResult();
        MatcherAssert.assertThat((Object)decoderResult.initialLineLength(), (Matcher)CoreMatchers.is((Object)15));
        MatcherAssert.assertThat((Object)decoderResult.headerSize(), (Matcher)CoreMatchers.is((Object)35));
        MatcherAssert.assertThat((Object)decoderResult.totalSize(), (Matcher)CoreMatchers.is((Object)50));
        HttpContent c = (HttpContent)channel.readInbound();
        c.release();
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testHeaderNameStartsWithControlChar1c() {
        this.testHeaderNameStartsWithControlChar(28);
    }

    @Test
    public void testHeaderNameStartsWithControlChar1d() {
        this.testHeaderNameStartsWithControlChar(29);
    }

    @Test
    public void testHeaderNameStartsWithControlChar1e() {
        this.testHeaderNameStartsWithControlChar(30);
    }

    @Test
    public void testHeaderNameStartsWithControlChar1f() {
        this.testHeaderNameStartsWithControlChar(31);
    }

    @Test
    public void testHeaderNameStartsWithControlChar0c() {
        this.testHeaderNameStartsWithControlChar(12);
    }

    private void testHeaderNameStartsWithControlChar(int controlChar) {
        ByteBuf responseBuffer = Unpooled.buffer();
        responseBuffer.writeCharSequence((CharSequence)"HTTP/1.1 200 OK\r\nHost: netty.io\r\n", CharsetUtil.US_ASCII);
        responseBuffer.writeByte(controlChar);
        responseBuffer.writeCharSequence((CharSequence)"Transfer-Encoding: chunked\r\n\r\n", CharsetUtil.US_ASCII);
        HttpResponseDecoderTest.testInvalidHeaders0(responseBuffer);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1c() {
        this.testHeaderNameEndsWithControlChar(28);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1d() {
        this.testHeaderNameEndsWithControlChar(29);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1e() {
        this.testHeaderNameEndsWithControlChar(30);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1f() {
        this.testHeaderNameEndsWithControlChar(31);
    }

    @Test
    public void testHeaderNameEndsWithControlChar0c() {
        this.testHeaderNameEndsWithControlChar(12);
    }

    private void testHeaderNameEndsWithControlChar(int controlChar) {
        ByteBuf responseBuffer = Unpooled.buffer();
        responseBuffer.writeCharSequence((CharSequence)"HTTP/1.1 200 OK\r\nHost: netty.io\r\n", CharsetUtil.US_ASCII);
        responseBuffer.writeCharSequence((CharSequence)"Transfer-Encoding", CharsetUtil.US_ASCII);
        responseBuffer.writeByte(controlChar);
        responseBuffer.writeCharSequence((CharSequence)": chunked\r\n\r\n", CharsetUtil.US_ASCII);
        HttpResponseDecoderTest.testInvalidHeaders0(responseBuffer);
    }

    private static void testInvalidHeaders0(ByteBuf responseBuffer) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{responseBuffer}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        MatcherAssert.assertThat((Object)response.decoderResult().cause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
        Assertions.assertTrue((boolean)response.decoderResult().isFailure());
        Assertions.assertFalse((boolean)channel.finish());
    }
}

