/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ClientCookieEncoderTest {
    @Test
    public void testEncodingMultipleClientCookies() {
        String c1 = "myCookie=myValue";
        String c2 = "myCookie2=myValue2";
        String c3 = "myCookie3=myValue3";
        DefaultCookie cookie1 = new DefaultCookie("myCookie", "myValue");
        cookie1.setDomain(".adomainsomewhere");
        cookie1.setMaxAge(50L);
        cookie1.setPath("/apathsomewhere");
        cookie1.setSecure(true);
        DefaultCookie cookie2 = new DefaultCookie("myCookie2", "myValue2");
        cookie2.setDomain(".anotherdomainsomewhere");
        cookie2.setPath("/anotherpathsomewhere");
        cookie2.setSecure(false);
        DefaultCookie cookie3 = new DefaultCookie("myCookie3", "myValue3");
        String encodedCookie = ClientCookieEncoder.STRICT.encode(new Cookie[]{cookie1, cookie2, cookie3});
        Assertions.assertEquals((Object)(c3 + "; " + c2 + "; " + c1), (Object)encodedCookie);
    }

    @Test
    public void testWrappedCookieValue() {
        ClientCookieEncoder.STRICT.encode((Cookie)new DefaultCookie("myCookie", "\"foo\""));
    }

    @Test
    public void testRejectCookieValueWithSemicolon() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                ClientCookieEncoder.STRICT.encode((Cookie)new DefaultCookie("myCookie", "foo;bar"));
            }
        });
    }

    @Test
    public void testComparatorForSamePathLength() {
        DefaultCookie cookie = new DefaultCookie("test", "value");
        cookie.setPath("1");
        DefaultCookie cookie2 = new DefaultCookie("test", "value");
        cookie2.setPath("2");
        Assertions.assertEquals((int)0, (int)ClientCookieEncoder.COOKIE_COMPARATOR.compare(cookie, cookie2));
        Assertions.assertEquals((int)0, (int)ClientCookieEncoder.COOKIE_COMPARATOR.compare(cookie2, cookie));
    }
}

