/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cors;

import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class CorsConfigTest {
    @Test
    public void disabled() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().disable().build();
        MatcherAssert.assertThat((Object)cors.isCorsSupportEnabled(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void anyOrigin() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().build();
        MatcherAssert.assertThat((Object)cors.isAnyOriginSupported(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)cors.origin(), (Matcher)CoreMatchers.is((Object)"*"));
        MatcherAssert.assertThat((Object)cors.origins().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void wildcardOrigin() {
        CorsConfig cors = CorsConfigBuilder.forOrigin((String)"*").build();
        MatcherAssert.assertThat((Object)cors.isAnyOriginSupported(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)cors.origin(), (Matcher)CoreMatchers.equalTo((Object)"*"));
        MatcherAssert.assertThat((Object)cors.origins().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void origin() {
        CorsConfig cors = CorsConfigBuilder.forOrigin((String)"http://localhost:7888").build();
        MatcherAssert.assertThat((Object)cors.origin(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"http://localhost:7888")));
        MatcherAssert.assertThat((Object)cors.isAnyOriginSupported(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void origins() {
        Object[] origins = new String[]{"http://localhost:7888", "https://localhost:7888"};
        CorsConfig cors = CorsConfigBuilder.forOrigins((String[])origins).build();
        MatcherAssert.assertThat((Object)cors.origins(), (Matcher)CoreMatchers.hasItems((Object[])origins));
        MatcherAssert.assertThat((Object)cors.isAnyOriginSupported(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void exposeHeaders() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().exposeHeaders(new String[]{"custom-header1", "custom-header2"}).build();
        MatcherAssert.assertThat((Object)cors.exposedHeaders(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"custom-header1", "custom-header2"}));
    }

    @Test
    public void allowCredentials() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().allowCredentials().build();
        MatcherAssert.assertThat((Object)cors.isCredentialsAllowed(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void maxAge() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().maxAge(3000L).build();
        MatcherAssert.assertThat((Object)cors.maxAge(), (Matcher)CoreMatchers.is((Object)3000L));
    }

    @Test
    public void requestMethods() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.POST, HttpMethod.GET}).build();
        MatcherAssert.assertThat((Object)cors.allowedRequestMethods(), (Matcher)CoreMatchers.hasItems((Object[])new HttpMethod[]{HttpMethod.POST, HttpMethod.GET}));
    }

    @Test
    public void requestHeaders() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().allowedRequestHeaders(new String[]{"preflight-header1", "preflight-header2"}).build();
        MatcherAssert.assertThat((Object)cors.allowedRequestHeaders(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"preflight-header1", "preflight-header2"}));
    }

    @Test
    public void preflightResponseHeadersSingleValue() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().preflightResponseHeader((CharSequence)"SingleValue", new Object[]{"value"}).build();
        MatcherAssert.assertThat((Object)cors.preflightResponseHeaders().get(HttpHeadersTestUtils.of("SingleValue")), (Matcher)CoreMatchers.equalTo((Object)"value"));
    }

    @Test
    public void preflightResponseHeadersMultipleValues() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().preflightResponseHeader((CharSequence)"MultipleValues", new Object[]{"value1", "value2"}).build();
        MatcherAssert.assertThat((Object)cors.preflightResponseHeaders().getAll(HttpHeadersTestUtils.of("MultipleValues")), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    public void defaultPreflightResponseHeaders() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().build();
        MatcherAssert.assertThat((Object)cors.preflightResponseHeaders().get((CharSequence)HttpHeaderNames.DATE), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)cors.preflightResponseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Object)"0"));
    }

    @Test
    public void emptyPreflightResponseHeaders() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().noPreflightResponseHeaders().build();
        MatcherAssert.assertThat((Object)cors.preflightResponseHeaders(), (Matcher)CoreMatchers.equalTo((Object)EmptyHttpHeaders.INSTANCE));
    }

    @Test
    public void shouldThrowIfValueIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                CorsConfigBuilder.forOrigin((String)"*").preflightResponseHeader((CharSequence)"HeaderName", new Object[]{null}).build();
            }
        });
    }

    @Test
    public void shortCircuit() {
        CorsConfig cors = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").shortCircuit().build();
        MatcherAssert.assertThat((Object)cors.isShortCircuit(), (Matcher)CoreMatchers.is((Object)true));
    }
}

