/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InternalAttribute;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpPostRequestEncoderTest {
    @Test
    public void testAllowedMethods() throws Exception {
        this.shouldThrowExceptionIfNotAllowed(HttpMethod.CONNECT);
        this.shouldThrowExceptionIfNotAllowed(HttpMethod.PUT);
        this.shouldThrowExceptionIfNotAllowed(HttpMethod.POST);
        this.shouldThrowExceptionIfNotAllowed(HttpMethod.PATCH);
        this.shouldThrowExceptionIfNotAllowed(HttpMethod.DELETE);
        this.shouldThrowExceptionIfNotAllowed(HttpMethod.GET);
        this.shouldThrowExceptionIfNotAllowed(HttpMethod.HEAD);
        this.shouldThrowExceptionIfNotAllowed(HttpMethod.OPTIONS);
        try {
            this.shouldThrowExceptionIfNotAllowed(HttpMethod.TRACE);
            Assertions.fail((String)"Should raised an exception with TRACE method");
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException errorDataEncoderException) {
            // empty catch block
        }
    }

    private void shouldThrowExceptionIfNotAllowed(HttpMethod method) throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, "http://localhost");
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpRequest)request, true);
        File file1 = new File(this.getClass().getResource("/file-01.txt").toURI());
        encoder.addBodyAttribute("foo", "bar");
        encoder.addBodyFileUpload("quux", file1, "text/plain", false);
        String multipartDataBoundary = encoder.multipartDataBoundary;
        String content = HttpPostRequestEncoderTest.getRequestBody(encoder);
        String expected = "--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"foo\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": 3\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain; charset=UTF-8\r\n\r\nbar\r\n--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"quux\"; filename=\"file-01.txt\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": " + file1.length() + "\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": binary\r\n\r\nFile 01" + StringUtil.NEWLINE + "\r\n--" + multipartDataBoundary + "--\r\n";
        Assertions.assertEquals((Object)expected, (Object)content);
    }

    @Test
    public void testSingleFileUploadNoName() throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpRequest)request, true);
        File file1 = new File(this.getClass().getResource("/file-01.txt").toURI());
        encoder.addBodyAttribute("foo", "bar");
        encoder.addBodyFileUpload("quux", "", file1, "text/plain", false);
        String multipartDataBoundary = encoder.multipartDataBoundary;
        String content = HttpPostRequestEncoderTest.getRequestBody(encoder);
        String expected = "--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"foo\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": 3\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain; charset=UTF-8\r\n\r\nbar\r\n--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"quux\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": " + file1.length() + "\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": binary\r\n\r\nFile 01" + StringUtil.NEWLINE + "\r\n--" + multipartDataBoundary + "--\r\n";
        Assertions.assertEquals((Object)expected, (Object)content);
    }

    @Test
    public void testMultiFileUploadInMixedMode() throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpRequest)request, true);
        File file1 = new File(this.getClass().getResource("/file-01.txt").toURI());
        File file2 = new File(this.getClass().getResource("/file-02.txt").toURI());
        File file3 = new File(this.getClass().getResource("/file-03.txt").toURI());
        encoder.addBodyAttribute("foo", "bar");
        encoder.addBodyFileUpload("quux", file1, "text/plain", false);
        encoder.addBodyFileUpload("quux", file2, "text/plain", false);
        encoder.addBodyFileUpload("quux", file3, "text/plain", false);
        String multipartDataBoundary = encoder.multipartDataBoundary;
        String multipartMixedBoundary = encoder.multipartMixedBoundary;
        String content = HttpPostRequestEncoderTest.getRequestBody(encoder);
        String expected = "--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"foo\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": 3\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain; charset=UTF-8\r\n\r\nbar\r\n--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"quux\"\r\n" + HttpHeaderNames.CONTENT_TYPE + ": multipart/mixed; boundary=" + multipartMixedBoundary + "\r\n\r\n--" + multipartMixedBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": attachment; filename=\"file-01.txt\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": " + file1.length() + "\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": binary\r\n\r\nFile 01" + StringUtil.NEWLINE + "\r\n--" + multipartMixedBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": attachment; filename=\"file-02.txt\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": " + file2.length() + "\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": binary\r\n\r\nFile 02" + StringUtil.NEWLINE + "\r\n--" + multipartMixedBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": attachment; filename=\"file-03.txt\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": " + file3.length() + "\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": binary\r\n\r\nFile 03" + StringUtil.NEWLINE + "\r\n--" + multipartMixedBoundary + "--\r\n--" + multipartDataBoundary + "--\r\n";
        Assertions.assertEquals((Object)expected, (Object)content);
    }

    @Test
    public void testMultiFileUploadInMixedModeNoName() throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpRequest)request, true);
        File file1 = new File(this.getClass().getResource("/file-01.txt").toURI());
        File file2 = new File(this.getClass().getResource("/file-02.txt").toURI());
        encoder.addBodyAttribute("foo", "bar");
        encoder.addBodyFileUpload("quux", "", file1, "text/plain", false);
        encoder.addBodyFileUpload("quux", "", file2, "text/plain", false);
        String multipartDataBoundary = encoder.multipartDataBoundary;
        String multipartMixedBoundary = encoder.multipartMixedBoundary;
        String content = HttpPostRequestEncoderTest.getRequestBody(encoder);
        String expected = "--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"foo\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": 3\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain; charset=UTF-8\r\n\r\nbar\r\n--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"quux\"\r\n" + HttpHeaderNames.CONTENT_TYPE + ": multipart/mixed; boundary=" + multipartMixedBoundary + "\r\n\r\n--" + multipartMixedBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": attachment\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": " + file1.length() + "\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": binary\r\n\r\nFile 01" + StringUtil.NEWLINE + "\r\n--" + multipartMixedBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": attachment\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": " + file2.length() + "\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": binary\r\n\r\nFile 02" + StringUtil.NEWLINE + "\r\n--" + multipartMixedBoundary + "--\r\n--" + multipartDataBoundary + "--\r\n";
        Assertions.assertEquals((Object)expected, (Object)content);
    }

    @Test
    public void testSingleFileUploadInHtml5Mode() throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpDataFactory)factory, (HttpRequest)request, true, CharsetUtil.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        File file1 = new File(this.getClass().getResource("/file-01.txt").toURI());
        File file2 = new File(this.getClass().getResource("/file-02.txt").toURI());
        encoder.addBodyAttribute("foo", "bar");
        encoder.addBodyFileUpload("quux", file1, "text/plain", false);
        encoder.addBodyFileUpload("quux", file2, "text/plain", false);
        String multipartDataBoundary = encoder.multipartDataBoundary;
        String content = HttpPostRequestEncoderTest.getRequestBody(encoder);
        String expected = "--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"foo\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": 3\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain; charset=UTF-8\r\n\r\nbar\r\n--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"quux\"; filename=\"file-01.txt\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": " + file1.length() + "\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": binary\r\n\r\nFile 01" + StringUtil.NEWLINE + "\r\n--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"quux\"; filename=\"file-02.txt\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": " + file2.length() + "\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": binary\r\n\r\nFile 02" + StringUtil.NEWLINE + "\r\n--" + multipartDataBoundary + "--\r\n";
        Assertions.assertEquals((Object)expected, (Object)content);
    }

    @Test
    public void testMultiFileUploadInHtml5Mode() throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpDataFactory)factory, (HttpRequest)request, true, CharsetUtil.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        File file1 = new File(this.getClass().getResource("/file-01.txt").toURI());
        encoder.addBodyAttribute("foo", "bar");
        encoder.addBodyFileUpload("quux", file1, "text/plain", false);
        String multipartDataBoundary = encoder.multipartDataBoundary;
        String content = HttpPostRequestEncoderTest.getRequestBody(encoder);
        String expected = "--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"foo\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": 3\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain; charset=UTF-8\r\n\r\nbar\r\n--" + multipartDataBoundary + "\r\n" + HttpHeaderNames.CONTENT_DISPOSITION + ": form-data; name=\"quux\"; filename=\"file-01.txt\"\r\n" + HttpHeaderNames.CONTENT_LENGTH + ": " + file1.length() + "\r\n" + HttpHeaderNames.CONTENT_TYPE + ": text/plain\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": binary\r\n\r\nFile 01" + StringUtil.NEWLINE + "\r\n--" + multipartDataBoundary + "--\r\n";
        Assertions.assertEquals((Object)expected, (Object)content);
    }

    @Test
    public void testHttpPostRequestEncoderSlicedBuffer() throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpRequest)request, true);
        encoder.addBodyAttribute("getform", "POST");
        encoder.addBodyAttribute("info", "first value");
        encoder.addBodyAttribute("secondinfo", "secondvalue a&");
        encoder.addBodyAttribute("thirdinfo", "short text");
        int length = 100000;
        char[] array = new char[length];
        Arrays.fill(array, 'a');
        String longText = new String(array);
        encoder.addBodyAttribute("fourthinfo", longText.substring(0, 7470));
        File file1 = new File(this.getClass().getResource("/file-01.txt").toURI());
        encoder.addBodyFileUpload("myfile", file1, "application/x-zip-compressed", false);
        encoder.finalizeRequest();
        while (!encoder.isEndOfInput()) {
            HttpContent httpContent = encoder.readChunk((ByteBufAllocator)null);
            ByteBuf content = httpContent.content();
            int refCnt = content.refCnt();
            Assertions.assertTrue(((content.unwrap() == content || content.unwrap() == null) && refCnt == 1 || content.unwrap() != content && refCnt == 2 ? 1 : 0) != 0, (String)("content: " + content + " content.unwrap(): " + content.unwrap() + " refCnt: " + refCnt));
            httpContent.release();
        }
        encoder.cleanFiles();
        encoder.close();
    }

    private static String getRequestBody(HttpPostRequestEncoder encoder) throws Exception {
        encoder.finalizeRequest();
        List chunks = encoder.multipartHttpDatas;
        ByteBuf[] buffers = new ByteBuf[chunks.size()];
        for (int i = 0; i < buffers.length; ++i) {
            InterfaceHttpData data = (InterfaceHttpData)chunks.get(i);
            if (data instanceof InternalAttribute) {
                buffers[i] = ((InternalAttribute)data).toByteBuf();
                continue;
            }
            if (!(data instanceof HttpData)) continue;
            buffers[i] = ((HttpData)data).getByteBuf();
        }
        ByteBuf content = Unpooled.wrappedBuffer((ByteBuf[])buffers);
        String contentStr = content.toString(CharsetUtil.UTF_8);
        content.release();
        return contentStr;
    }

    @Test
    public void testDataIsMultipleOfChunkSize1() throws Exception {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpDataFactory)factory, (HttpRequest)request, true, HttpConstants.DEFAULT_CHARSET, HttpPostRequestEncoder.EncoderMode.RFC1738);
        MemoryFileUpload first = new MemoryFileUpload("resources", "", "application/json", null, CharsetUtil.UTF_8, -1L);
        first.setMaxSize(-1L);
        first.setContent((InputStream)new ByteArrayInputStream(new byte[7955]));
        encoder.addBodyHttpData((InterfaceHttpData)first);
        MemoryFileUpload second = new MemoryFileUpload("resources2", "", "application/json", null, CharsetUtil.UTF_8, -1L);
        second.setMaxSize(-1L);
        second.setContent((InputStream)new ByteArrayInputStream(new byte[7928]));
        encoder.addBodyHttpData((InterfaceHttpData)second);
        Assertions.assertNotNull((Object)encoder.finalizeRequest());
        HttpPostRequestEncoderTest.checkNextChunkSize(encoder, 8080);
        HttpPostRequestEncoderTest.checkNextChunkSize(encoder, 8080);
        HttpContent httpContent = encoder.readChunk((ByteBufAllocator)null);
        Assertions.assertTrue((boolean)(httpContent instanceof LastHttpContent), (String)"Expected LastHttpContent is not received");
        httpContent.release();
        Assertions.assertTrue((boolean)encoder.isEndOfInput(), (String)"Expected end of input is not receive");
    }

    @Test
    public void testDataIsMultipleOfChunkSize2() throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost");
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpRequest)request, true);
        int length = 7943;
        char[] array = new char[length];
        Arrays.fill(array, 'a');
        String longText = new String(array);
        encoder.addBodyAttribute("foo", longText);
        Assertions.assertNotNull((Object)encoder.finalizeRequest());
        HttpPostRequestEncoderTest.checkNextChunkSize(encoder, 8080);
        HttpContent httpContent = encoder.readChunk((ByteBufAllocator)null);
        Assertions.assertTrue((boolean)(httpContent instanceof LastHttpContent), (String)"Expected LastHttpContent is not received");
        httpContent.release();
        Assertions.assertTrue((boolean)encoder.isEndOfInput(), (String)"Expected end of input is not receive");
    }

    private static void checkNextChunkSize(HttpPostRequestEncoder encoder, int sizeWithoutDelimiter) throws Exception {
        int expectedSizeMin = sizeWithoutDelimiter + 2;
        int expectedSizeMax = sizeWithoutDelimiter + 16;
        HttpContent httpContent = encoder.readChunk((ByteBufAllocator)null);
        int readable = httpContent.content().readableBytes();
        boolean expectedSize = readable >= expectedSizeMin && readable <= expectedSizeMax;
        Assertions.assertTrue((boolean)expectedSize, (String)("Chunk size is not in expected range (" + expectedSizeMin + " - " + expectedSizeMax + "), was: " + readable));
        httpContent.release();
    }

    @Test
    public void testEncodeChunkedContent() throws Exception {
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpRequest)req, false);
        int length = 16173;
        char[] array = new char[length];
        Arrays.fill(array, 'a');
        String longText = new String(array);
        encoder.addBodyAttribute("data", longText);
        encoder.addBodyAttribute("moreData", "abcd");
        Assertions.assertNotNull((Object)encoder.finalizeRequest());
        while (!encoder.isEndOfInput()) {
            encoder.readChunk((ByteBufAllocator)null).release();
        }
        Assertions.assertTrue((boolean)encoder.isEndOfInput());
        encoder.cleanFiles();
    }
}

