/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class WebSocketClientHandshakerTest {
    protected abstract WebSocketClientHandshaker newHandshaker(URI var1, String var2, HttpHeaders var3, boolean var4);

    protected WebSocketClientHandshaker newHandshaker(URI uri) {
        return this.newHandshaker(uri, null, null, false);
    }

    protected abstract CharSequence getOriginHeaderName();

    protected abstract CharSequence getProtocolHeaderName();

    protected abstract CharSequence[] getHandshakeRequiredHeaderNames();

    @Test
    public void hostHeaderWs() {
        for (String scheme : new String[]{"ws://", "http://"}) {
            for (String host : new String[]{"localhost", "127.0.0.1", "[::1]", "Netty.io"}) {
                String enter = scheme + host;
                this.testHostHeader(enter, host);
                this.testHostHeader(enter + '/', host);
                this.testHostHeader(enter + ":80", host);
                this.testHostHeader(enter + ":443", host + ":443");
                this.testHostHeader(enter + ":9999", host + ":9999");
                this.testHostHeader(enter + "/path", host);
                this.testHostHeader(enter + ":80/path", host);
                this.testHostHeader(enter + ":443/path", host + ":443");
                this.testHostHeader(enter + ":9999/path", host + ":9999");
            }
        }
    }

    @Test
    public void hostHeaderWss() {
        for (String scheme : new String[]{"wss://", "https://"}) {
            for (String host : new String[]{"localhost", "127.0.0.1", "[::1]", "Netty.io"}) {
                String enter = scheme + host;
                this.testHostHeader(enter, host);
                this.testHostHeader(enter + '/', host);
                this.testHostHeader(enter + ":80", host + ":80");
                this.testHostHeader(enter + ":443", host);
                this.testHostHeader(enter + ":9999", host + ":9999");
                this.testHostHeader(enter + "/path", host);
                this.testHostHeader(enter + ":80/path", host + ":80");
                this.testHostHeader(enter + ":443/path", host);
                this.testHostHeader(enter + ":9999/path", host + ":9999");
            }
        }
    }

    @Test
    public void hostHeaderWithoutScheme() {
        this.testHostHeader("//localhost/", "localhost");
        this.testHostHeader("//localhost/path", "localhost");
        this.testHostHeader("//localhost:80/", "localhost:80");
        this.testHostHeader("//localhost:443/", "localhost:443");
        this.testHostHeader("//localhost:9999/", "localhost:9999");
    }

    @Test
    public void originHeaderWs() {
        for (String scheme : new String[]{"ws://", "http://"}) {
            for (String host : new String[]{"localhost", "127.0.0.1", "[::1]", "NETTY.IO"}) {
                String enter = scheme + host;
                String expect = "http://" + host.toLowerCase();
                this.testOriginHeader(enter, expect);
                this.testOriginHeader(enter + '/', expect);
                this.testOriginHeader(enter + ":80", expect);
                this.testOriginHeader(enter + ":443", expect + ":443");
                this.testOriginHeader(enter + ":9999", expect + ":9999");
                this.testOriginHeader(enter + "/path%20with%20ws", expect);
                this.testOriginHeader(enter + ":80/path%20with%20ws", expect);
                this.testOriginHeader(enter + ":443/path%20with%20ws", expect + ":443");
                this.testOriginHeader(enter + ":9999/path%20with%20ws", expect + ":9999");
            }
        }
    }

    @Test
    public void originHeaderWss() {
        for (String scheme : new String[]{"wss://", "https://"}) {
            for (String host : new String[]{"localhost", "127.0.0.1", "[::1]", "NETTY.IO"}) {
                String enter = scheme + host;
                String expect = "https://" + host.toLowerCase();
                this.testOriginHeader(enter, expect);
                this.testOriginHeader(enter + '/', expect);
                this.testOriginHeader(enter + ":80", expect + ":80");
                this.testOriginHeader(enter + ":443", expect);
                this.testOriginHeader(enter + ":9999", expect + ":9999");
                this.testOriginHeader(enter + "/path%20with%20ws", expect);
                this.testOriginHeader(enter + ":80/path%20with%20ws", expect + ":80");
                this.testOriginHeader(enter + ":443/path%20with%20ws", expect);
                this.testOriginHeader(enter + ":9999/path%20with%20ws", expect + ":9999");
            }
        }
    }

    @Test
    public void originHeaderWithoutScheme() {
        this.testOriginHeader("//localhost/", "http://localhost");
        this.testOriginHeader("//localhost/path", "http://localhost");
        this.testOriginHeader("//localhost:80/", "http://localhost");
        this.testOriginHeader("//localhost:80/path", "http://localhost");
        this.testOriginHeader("//localhost:443/", "https://localhost");
        this.testOriginHeader("//localhost:443/path", "https://localhost");
        this.testOriginHeader("//localhost:9999/", "http://localhost:9999");
        this.testOriginHeader("//localhost:9999/path", "http://localhost:9999");
        this.testOriginHeader("//LOCALHOST/", "http://localhost");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetOriginFromCustomHeaders() {
        HttpHeaders customHeaders = new DefaultHttpHeaders().set(this.getOriginHeaderName(), (Object)"http://example.com");
        WebSocketClientHandshaker handshaker = this.newHandshaker(URI.create("ws://server.example.com/chat"), null, customHeaders, false);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assertions.assertEquals((Object)"http://example.com", (Object)request.headers().get(this.getOriginHeaderName()));
        }
        finally {
            request.release();
        }
    }

    private void testHostHeader(String uri, String expected) {
        this.testHeaderDefaultHttp(uri, (CharSequence)HttpHeaderNames.HOST, expected);
    }

    private void testOriginHeader(String uri, String expected) {
        this.testHeaderDefaultHttp(uri, this.getOriginHeaderName(), expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testHeaderDefaultHttp(String uri, CharSequence header, String expectedValue) {
        WebSocketClientHandshaker handshaker = this.newHandshaker(URI.create(uri));
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assertions.assertEquals((Object)expectedValue, (Object)request.headers().get(header));
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeUrl() {
        URI uri = URI.create("ws://localhost:9999/path%20with%20ws");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assertions.assertEquals((Object)"/path%20with%20ws", (Object)request.getUri());
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeUrlWithQuery() {
        URI uri = URI.create("ws://localhost:9999/path%20with%20ws?a=b%20c");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assertions.assertEquals((Object)"/path%20with%20ws?a=b%20c", (Object)request.uri());
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeUrlWithoutPath() {
        URI uri = URI.create("ws://localhost:9999");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assertions.assertEquals((Object)"/", (Object)request.uri());
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeUrlWithoutPathWithQuery() {
        URI uri = URI.create("ws://localhost:9999?a=b%20c");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assertions.assertEquals((Object)"/?a=b%20c", (Object)request.uri());
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbsoluteUpgradeUrlWithQuery() {
        URI uri = URI.create("ws://localhost:9999/path%20with%20ws?a=b%20c");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri, null, null, true);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assertions.assertEquals((Object)"ws://localhost:9999/path%20with%20ws?a=b%20c", (Object)request.uri());
        }
        finally {
            request.release();
        }
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testHttpResponseAndFrameInSameBuffer() {
        this.testHttpResponseAndFrameInSameBuffer(false);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testHttpResponseAndFrameInSameBufferCodec() {
        this.testHttpResponseAndFrameInSameBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHttpResponseAndFrameInSameBuffer(boolean codec) {
        ByteBuf buf;
        ByteBuf frameBytes;
        String url = "ws://localhost:9999/ws";
        final WebSocketClientHandshaker shaker = this.newHandshaker(URI.create(url));
        final WebSocketClientHandshaker handshaker = new WebSocketClientHandshaker(shaker.uri(), shaker.version(), null, (HttpHeaders)EmptyHttpHeaders.INSTANCE, Integer.MAX_VALUE, -1L){

            protected FullHttpRequest newHandshakeRequest() {
                return shaker.newHandshakeRequest();
            }

            protected void verify(FullHttpResponse response) {
            }

            protected WebSocketFrameDecoder newWebsocketDecoder() {
                return shaker.newWebsocketDecoder();
            }

            protected WebSocketFrameEncoder newWebSocketEncoder() {
                return shaker.newWebSocketEncoder();
            }
        };
        byte[] data = WebSocketUtil.randomBytes((int)24);
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(url, null, false);
        FullHttpRequest request = shaker.newHandshakeRequest();
        WebSocketServerHandshaker socketServerHandshaker = factory.newHandshaker((HttpRequest)request);
        request.release();
        EmbeddedChannel websocketChannel = new EmbeddedChannel(new ChannelHandler[]{socketServerHandshaker.newWebSocketEncoder(), socketServerHandshaker.newWebsocketDecoder()});
        Assertions.assertTrue((boolean)websocketChannel.writeOutbound(new Object[]{new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])data))}));
        byte[] bytes = "HTTP/1.1 101 Switching Protocols\r\nSec-Websocket-Accept: not-verify\r\nUpgrade: websocket\r\n\r\n".getBytes(CharsetUtil.US_ASCII);
        CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer();
        compositeByteBuf.addComponent(true, Unpooled.wrappedBuffer((byte[])bytes));
        while ((frameBytes = (ByteBuf)websocketChannel.readOutbound()) != null) {
            compositeByteBuf.addComponent(true, frameBytes);
        }
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE), new SimpleChannelInboundHandler<FullHttpResponse>(){

            protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
                handshaker.finishHandshake(ctx.channel(), msg);
                ctx.pipeline().remove((ChannelHandler)this);
            }
        }});
        if (codec) {
            ch.pipeline().addFirst(new ChannelHandler[]{new HttpClientCodec()});
        } else {
            ch.pipeline().addFirst(new ChannelHandler[]{new HttpRequestEncoder(), new HttpResponseDecoder()});
        }
        shaker.handshake((Channel)ch).syncUninterruptibly();
        while ((buf = (ByteBuf)ch.readOutbound()) != null) {
            buf.release();
        }
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{compositeByteBuf}));
        Assertions.assertTrue((boolean)ch.finish());
        BinaryWebSocketFrame frame = (BinaryWebSocketFrame)ch.readInbound();
        ByteBuf expect = Unpooled.wrappedBuffer((byte[])data);
        try {
            Assertions.assertEquals((Object)expect, (Object)frame.content());
            Assertions.assertTrue((boolean)frame.isFinalFragment());
            Assertions.assertEquals((int)0, (int)frame.rsv());
        }
        finally {
            expect.release();
            frame.release();
        }
    }

    @Test
    public void testDuplicateWebsocketHandshakeHeaders() {
        URI uri = URI.create("ws://localhost:9999/foo");
        DefaultHttpHeaders inputHeaders = new DefaultHttpHeaders();
        String bogusSubProtocol = "bogusSubProtocol";
        String bogusHeaderValue = "bogusHeaderValue";
        for (CharSequence header : this.getHandshakeRequiredHeaderNames()) {
            if (HttpHeaderNames.HOST.equals((Object)header)) continue;
            inputHeaders.add(header, (Object)bogusHeaderValue);
        }
        inputHeaders.add(this.getProtocolHeaderName(), (Object)bogusSubProtocol);
        String realSubProtocol = "realSubProtocol";
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri, realSubProtocol, (HttpHeaders)inputHeaders, false);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        HttpHeaders outputHeaders = request.headers();
        for (CharSequence header : this.getHandshakeRequiredHeaderNames()) {
            Assertions.assertEquals((int)1, (int)outputHeaders.getAll(header).size());
            Assertions.assertNotEquals((Object)bogusHeaderValue, (Object)outputHeaders.get(header));
        }
        Assertions.assertEquals((int)1, (int)outputHeaders.getAll(this.getProtocolHeaderName()).size());
        Assertions.assertEquals((Object)realSubProtocol, (Object)outputHeaders.get(this.getProtocolHeaderName()));
        request.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebSocketClientHandshakeException() {
        URI uri = URI.create("ws://localhost:9999/exception");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri, null, null, false);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
        response.headers().set((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)"realm = access token required");
        try {
            handshaker.finishHandshake(null, (FullHttpResponse)response);
            Assertions.fail((String)"Expected WebSocketClientHandshakeException");
        }
        catch (WebSocketClientHandshakeException exception) {
            Assertions.assertEquals((Object)"Invalid handshake response getStatus: 401 Unauthorized", (Object)exception.getMessage());
            Assertions.assertEquals((Object)HttpResponseStatus.UNAUTHORIZED, (Object)exception.response().status());
            Assertions.assertTrue((boolean)exception.response().headers().contains((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (CharSequence)"realm = access token required", false));
        }
        finally {
            response.release();
        }
    }

    @Test
    public void testHandshakeForHttpResponseWithoutAggregator() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestEncoder(), new HttpResponseDecoder()});
        URI uri = URI.create("ws://localhost:9999/chat");
        WebSocketClientHandshaker clientHandshaker = this.newHandshaker(uri);
        FullHttpRequest handshakeRequest = clientHandshaker.newHandshakeRequest();
        handshakeRequest.release();
        String accept = "";
        if (clientHandshaker.version() != WebSocketVersion.V00) {
            String acceptSeed = handshakeRequest.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY) + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            byte[] sha1 = WebSocketUtil.sha1((byte[])acceptSeed.getBytes(CharsetUtil.US_ASCII));
            accept = WebSocketUtil.base64((byte[])sha1);
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        response.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, (Object)accept);
        ChannelFuture handshakeFuture = clientHandshaker.processHandshake((Channel)channel, (HttpResponse)response);
        Assertions.assertFalse((boolean)handshakeFuture.isDone());
        Assertions.assertNotNull((Object)channel.pipeline().get("handshaker"));
        if (clientHandshaker.version() != WebSocketVersion.V00) {
            Assertions.assertNull((Object)channel.pipeline().get("httpAggregator"));
            channel.writeInbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        } else {
            Assertions.assertNotNull((Object)channel.pipeline().get("httpAggregator"));
            channel.writeInbound(new Object[]{new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"8jKS'y:G*Co,Wxa-", (Charset)CharsetUtil.US_ASCII))});
        }
        Assertions.assertTrue((boolean)handshakeFuture.isDone());
        Assertions.assertNull((Object)channel.pipeline().get("handshaker"));
        Assertions.assertFalse((boolean)channel.finish());
    }
}

