/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class DataCompressionHttp2Test {
    private static final AsciiString GET = new AsciiString((CharSequence)"GET");
    private static final AsciiString POST = new AsciiString((CharSequence)"POST");
    private static final AsciiString PATH = new AsciiString((CharSequence)"/some/path");
    @Mock
    private Http2FrameListener serverListener;
    @Mock
    private Http2FrameListener clientListener;
    private Http2ConnectionEncoder clientEncoder;
    private ServerBootstrap sb;
    private Bootstrap cb;
    private Channel serverChannel;
    private Channel clientChannel;
    private volatile Channel serverConnectedChannel;
    private CountDownLatch serverLatch;
    private Http2Connection serverConnection;
    private Http2Connection clientConnection;
    private Http2ConnectionHandler clientHandler;
    private ByteArrayOutputStream serverOut;

    @BeforeEach
    public void setup() throws InterruptedException, Http2Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                if (((Boolean)invocation.getArgument(4)).booleanValue()) {
                    DataCompressionHttp2Test.this.serverConnection.stream(((Integer)invocation.getArgument(1)).intValue()).close();
                }
                return null;
            }
        }).when((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyBoolean());
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                if (((Boolean)invocation.getArgument(7)).booleanValue()) {
                    DataCompressionHttp2Test.this.serverConnection.stream(((Integer)invocation.getArgument(1)).intValue()).close();
                }
                return null;
            }
        }).when((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean());
    }

    @AfterEach
    public void cleanup() throws IOException {
        this.serverOut.close();
    }

    @AfterEach
    public void teardown() throws InterruptedException {
        Channel serverConnectedChannel;
        if (this.clientChannel != null) {
            this.clientChannel.close().sync();
            this.clientChannel = null;
        }
        if (this.serverChannel != null) {
            this.serverChannel.close().sync();
            this.serverChannel = null;
        }
        if ((serverConnectedChannel = this.serverConnectedChannel) != null) {
            serverConnectedChannel.close().sync();
            this.serverConnectedChannel = null;
        }
        Future serverGroup = this.sb.config().group().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        Future serverChildGroup = this.sb.config().childGroup().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        Future clientGroup = this.cb.config().group().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        serverGroup.sync();
        serverChildGroup.sync();
        clientGroup.sync();
    }

    @Test
    public void justHeadersNoData() throws Exception {
        this.bootstrapEnv(0);
        final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)GET).path((CharSequence)PATH).set((Object)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.GZIP);
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                DataCompressionHttp2Test.this.clientEncoder.writeHeaders(DataCompressionHttp2Test.this.ctxClient(), 3, headers, 0, true, DataCompressionHttp2Test.this.newPromiseClient());
                DataCompressionHttp2Test.this.clientHandler.flush(DataCompressionHttp2Test.this.ctxClient());
            }
        });
        this.awaitServer();
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gzipEncodingSingleEmptyMessage() throws Exception {
        String text = "";
        final ByteBuf data = Unpooled.copiedBuffer((byte[])"".getBytes());
        this.bootstrapEnv(data.readableBytes());
        try {
            final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)POST).path((CharSequence)PATH).set((Object)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.GZIP);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    DataCompressionHttp2Test.this.clientEncoder.writeHeaders(DataCompressionHttp2Test.this.ctxClient(), 3, headers, 0, false, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientEncoder.writeData(DataCompressionHttp2Test.this.ctxClient(), 3, data.retain(), 0, true, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientHandler.flush(DataCompressionHttp2Test.this.ctxClient());
                }
            });
            this.awaitServer();
            Assertions.assertEquals((Object)"", (Object)this.serverOut.toString(CharsetUtil.UTF_8.name()));
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gzipEncodingSingleMessage() throws Exception {
        String text = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc";
        final ByteBuf data = Unpooled.copiedBuffer((byte[])"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc".getBytes());
        this.bootstrapEnv(data.readableBytes());
        try {
            final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)POST).path((CharSequence)PATH).set((Object)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.GZIP);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    DataCompressionHttp2Test.this.clientEncoder.writeHeaders(DataCompressionHttp2Test.this.ctxClient(), 3, headers, 0, false, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientEncoder.writeData(DataCompressionHttp2Test.this.ctxClient(), 3, data.retain(), 0, true, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientHandler.flush(DataCompressionHttp2Test.this.ctxClient());
                }
            });
            this.awaitServer();
            Assertions.assertEquals((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc", (Object)this.serverOut.toString(CharsetUtil.UTF_8.name()));
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gzipEncodingMultipleMessages() throws Exception {
        String text1 = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc";
        String text2 = "dddddddddddddddddddeeeeeeeeeeeeeeeeeeeffffffffffffffffffff";
        final ByteBuf data1 = Unpooled.copiedBuffer((byte[])"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc".getBytes());
        final ByteBuf data2 = Unpooled.copiedBuffer((byte[])"dddddddddddddddddddeeeeeeeeeeeeeeeeeeeffffffffffffffffffff".getBytes());
        this.bootstrapEnv(data1.readableBytes() + data2.readableBytes());
        try {
            final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)POST).path((CharSequence)PATH).set((Object)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.GZIP);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    DataCompressionHttp2Test.this.clientEncoder.writeHeaders(DataCompressionHttp2Test.this.ctxClient(), 3, headers, 0, false, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientEncoder.writeData(DataCompressionHttp2Test.this.ctxClient(), 3, data1.retain(), 0, false, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientEncoder.writeData(DataCompressionHttp2Test.this.ctxClient(), 3, data2.retain(), 0, true, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientHandler.flush(DataCompressionHttp2Test.this.ctxClient());
                }
            });
            this.awaitServer();
            Assertions.assertEquals((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbcccccccccccccccccccccccdddddddddddddddddddeeeeeeeeeeeeeeeeeeeffffffffffffffffffff", (Object)this.serverOut.toString(CharsetUtil.UTF_8.name()));
        }
        finally {
            data1.release();
            data2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void brotliEncodingSingleEmptyMessage() throws Exception {
        String text = "";
        final ByteBuf data = Unpooled.copiedBuffer((byte[])"".getBytes());
        this.bootstrapEnv(data.readableBytes());
        try {
            final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)POST).path((CharSequence)PATH).set((Object)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.BR);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    DataCompressionHttp2Test.this.clientEncoder.writeHeaders(DataCompressionHttp2Test.this.ctxClient(), 3, headers, 0, false, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientEncoder.writeData(DataCompressionHttp2Test.this.ctxClient(), 3, data.retain(), 0, true, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientHandler.flush(DataCompressionHttp2Test.this.ctxClient());
                }
            });
            this.awaitServer();
            Assertions.assertEquals((Object)"", (Object)this.serverOut.toString(CharsetUtil.UTF_8.name()));
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void brotliEncodingSingleMessage() throws Exception {
        String text = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc";
        final ByteBuf data = Unpooled.copiedBuffer((byte[])"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc".getBytes(CharsetUtil.UTF_8.name()));
        this.bootstrapEnv(data.readableBytes());
        try {
            final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)POST).path((CharSequence)PATH).set((Object)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.BR);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    DataCompressionHttp2Test.this.clientEncoder.writeHeaders(DataCompressionHttp2Test.this.ctxClient(), 3, headers, 0, false, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientEncoder.writeData(DataCompressionHttp2Test.this.ctxClient(), 3, data.retain(), 0, true, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientHandler.flush(DataCompressionHttp2Test.this.ctxClient());
                }
            });
            this.awaitServer();
            Assertions.assertEquals((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc", (Object)this.serverOut.toString(CharsetUtil.UTF_8.name()));
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void zstdEncodingSingleEmptyMessage() throws Exception {
        String text = "";
        final ByteBuf data = Unpooled.copiedBuffer((byte[])"".getBytes());
        this.bootstrapEnv(data.readableBytes());
        try {
            final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)POST).path((CharSequence)PATH).set((Object)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.ZSTD);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    DataCompressionHttp2Test.this.clientEncoder.writeHeaders(DataCompressionHttp2Test.this.ctxClient(), 3, headers, 0, false, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientEncoder.writeData(DataCompressionHttp2Test.this.ctxClient(), 3, data.retain(), 0, true, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientHandler.flush(DataCompressionHttp2Test.this.ctxClient());
                }
            });
            this.awaitServer();
            Assertions.assertEquals((Object)"", (Object)this.serverOut.toString(CharsetUtil.UTF_8.name()));
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void zstdEncodingSingleMessage() throws Exception {
        String text = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc";
        final ByteBuf data = Unpooled.copiedBuffer((byte[])"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc".getBytes(CharsetUtil.UTF_8.name()));
        this.bootstrapEnv(data.readableBytes());
        try {
            final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)POST).path((CharSequence)PATH).set((Object)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.ZSTD);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    DataCompressionHttp2Test.this.clientEncoder.writeHeaders(DataCompressionHttp2Test.this.ctxClient(), 3, headers, 0, false, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientEncoder.writeData(DataCompressionHttp2Test.this.ctxClient(), 3, data.retain(), 0, true, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientHandler.flush(DataCompressionHttp2Test.this.ctxClient());
                }
            });
            this.awaitServer();
            Assertions.assertEquals((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccc", (Object)this.serverOut.toString(CharsetUtil.UTF_8.name()));
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deflateEncodingWriteLargeMessage() throws Exception {
        int BUFFER_SIZE = 4096;
        byte[] bytes = new byte[4096];
        new Random().nextBytes(bytes);
        this.bootstrapEnv(4096);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])bytes);
        try {
            final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)POST).path((CharSequence)PATH).set((Object)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.DEFLATE);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    DataCompressionHttp2Test.this.clientEncoder.writeHeaders(DataCompressionHttp2Test.this.ctxClient(), 3, headers, 0, false, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientEncoder.writeData(DataCompressionHttp2Test.this.ctxClient(), 3, data.retain(), 0, true, DataCompressionHttp2Test.this.newPromiseClient());
                    DataCompressionHttp2Test.this.clientHandler.flush(DataCompressionHttp2Test.this.ctxClient());
                }
            });
            this.awaitServer();
            Assertions.assertEquals((Object)data.resetReaderIndex().toString(CharsetUtil.UTF_8), (Object)this.serverOut.toString(CharsetUtil.UTF_8.name()));
        }
        finally {
            data.release();
        }
    }

    private void bootstrapEnv(int serverOutSize) throws Exception {
        final CountDownLatch prefaceWrittenLatch = new CountDownLatch(1);
        this.serverOut = new ByteArrayOutputStream(serverOutSize);
        this.serverLatch = new CountDownLatch(1);
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        this.serverConnection = new DefaultHttp2Connection(true);
        this.clientConnection = new DefaultHttp2Connection(false);
        this.serverConnection.addListener((Http2Connection.Listener)new Http2ConnectionAdapter(){

            public void onStreamClosed(Http2Stream stream) {
                DataCompressionHttp2Test.this.serverLatch.countDown();
            }
        });
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock in) throws Throwable {
                ByteBuf buf = (ByteBuf)in.getArguments()[2];
                int padding = (Integer)in.getArguments()[3];
                int processedBytes = buf.readableBytes() + padding;
                buf.readBytes((OutputStream)DataCompressionHttp2Test.this.serverOut, buf.readableBytes());
                if (((Boolean)in.getArgument(4)).booleanValue()) {
                    DataCompressionHttp2Test.this.serverConnection.stream(((Integer)in.getArgument(1)).intValue()).close();
                }
                return processedBytes;
            }
        }).when((Object)this.serverListener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                DataCompressionHttp2Test.this.serverConnectedChannel = ch;
                ChannelPipeline p = ch.pipeline();
                DefaultHttp2FrameWriter frameWriter = new DefaultHttp2FrameWriter();
                DataCompressionHttp2Test.this.serverConnection.remote().flowController((Http2FlowController)new DefaultHttp2RemoteFlowController(DataCompressionHttp2Test.this.serverConnection));
                DataCompressionHttp2Test.this.serverConnection.local().flowController((Http2FlowController)new DefaultHttp2LocalFlowController(DataCompressionHttp2Test.this.serverConnection).frameWriter((Http2FrameWriter)frameWriter));
                CompressorHttp2ConnectionEncoder encoder = new CompressorHttp2ConnectionEncoder((Http2ConnectionEncoder)new DefaultHttp2ConnectionEncoder(DataCompressionHttp2Test.this.serverConnection, (Http2FrameWriter)frameWriter));
                DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder(DataCompressionHttp2Test.this.serverConnection, (Http2ConnectionEncoder)encoder, (Http2FrameReader)new DefaultHttp2FrameReader());
                Http2ConnectionHandler connectionHandler = new Http2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(DataCompressionHttp2Test.this.serverConnection, DataCompressionHttp2Test.this.serverListener)).codec((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder).build();
                p.addLast(new ChannelHandler[]{connectionHandler});
                serverChannelLatch.countDown();
            }
        });
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                DefaultHttp2FrameWriter frameWriter = new DefaultHttp2FrameWriter();
                DataCompressionHttp2Test.this.clientConnection.remote().flowController((Http2FlowController)new DefaultHttp2RemoteFlowController(DataCompressionHttp2Test.this.clientConnection));
                DataCompressionHttp2Test.this.clientConnection.local().flowController((Http2FlowController)new DefaultHttp2LocalFlowController(DataCompressionHttp2Test.this.clientConnection).frameWriter((Http2FrameWriter)frameWriter));
                DataCompressionHttp2Test.this.clientEncoder = (Http2ConnectionEncoder)new CompressorHttp2ConnectionEncoder((Http2ConnectionEncoder)new DefaultHttp2ConnectionEncoder(DataCompressionHttp2Test.this.clientConnection, (Http2FrameWriter)frameWriter));
                DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder(DataCompressionHttp2Test.this.clientConnection, DataCompressionHttp2Test.this.clientEncoder, (Http2FrameReader)new DefaultHttp2FrameReader());
                DataCompressionHttp2Test.this.clientHandler = new Http2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(DataCompressionHttp2Test.this.clientConnection, DataCompressionHttp2Test.this.clientListener)).gracefulShutdownTimeoutMillis(0L).codec((Http2ConnectionDecoder)decoder, DataCompressionHttp2Test.this.clientEncoder).build();
                p.addLast(new ChannelHandler[]{DataCompressionHttp2Test.this.clientHandler});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
                            prefaceWrittenLatch.countDown();
                            ctx.pipeline().remove((ChannelHandler)this);
                        }
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress(0)).sync().channel();
        int port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
        ChannelFuture ccf = this.cb.connect((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, port));
        Assertions.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
        Assertions.assertTrue((boolean)prefaceWrittenLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
    }

    private void awaitServer() throws Exception {
        Assertions.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
        this.serverOut.flush();
    }

    private ChannelHandlerContext ctxClient() {
        return this.clientChannel.pipeline().firstContext();
    }

    private ChannelPromise newPromiseClient() {
        return this.ctxClient().newPromise();
    }
}

