/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class DefaultHttp2ConnectionEncoderTest {
    private static final int STREAM_ID = 2;
    private static final int PUSH_STREAM_ID = 4;
    @Mock
    private Http2RemoteFlowController remoteFlow;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private Channel channel;
    @Mock
    private Channel.Unsafe unsafe;
    @Mock
    private ChannelPipeline pipeline;
    @Mock
    private Http2FrameWriter writer;
    @Mock
    private Http2FrameWriter.Configuration writerConfig;
    @Mock
    private Http2FrameSizePolicy frameSizePolicy;
    @Mock
    private Http2LifecycleManager lifecycleManager;
    private DefaultHttp2ConnectionEncoder encoder;
    private Http2Connection connection;
    private ArgumentCaptor<Http2RemoteFlowController.FlowControlled> payloadCaptor;
    private List<String> writtenData;
    private List<Integer> writtenPadding;
    private boolean streamClosed;

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ChannelMetadata metadata = new ChannelMetadata(false, 16);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.pipeline()).thenReturn((Object)this.pipeline);
        Mockito.when((Object)this.channel.metadata()).thenReturn((Object)metadata);
        Mockito.when((Object)this.channel.unsafe()).thenReturn((Object)this.unsafe);
        DefaultChannelConfig config = new DefaultChannelConfig(this.channel);
        Mockito.when((Object)this.channel.config()).thenReturn((Object)config);
        ((Channel)Mockito.doAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock in) {
                return DefaultHttp2ConnectionEncoderTest.this.newPromise().setFailure((Throwable)in.getArgument(0));
            }
        }).when((Object)this.channel)).newFailedFuture((Throwable)Mockito.any(Throwable.class));
        Mockito.when((Object)this.writer.configuration()).thenReturn((Object)this.writerConfig);
        Mockito.when((Object)this.writerConfig.frameSizePolicy()).thenReturn((Object)this.frameSizePolicy);
        Mockito.when((Object)this.frameSizePolicy.maxFrameSize()).thenReturn((Object)64);
        ((Http2FrameWriter)Mockito.doAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock in) throws Throwable {
                return ((ChannelPromise)in.getArguments()[2]).setSuccess();
            }
        }).when((Object)this.writer)).writeSettings((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (Http2Settings)Mockito.any(Http2Settings.class), (ChannelPromise)Mockito.any(ChannelPromise.class));
        ((Http2FrameWriter)Mockito.doAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock in) throws Throwable {
                ((ByteBuf)in.getArguments()[3]).release();
                return ((ChannelPromise)in.getArguments()[4]).setSuccess();
            }
        }).when((Object)this.writer)).writeGoAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (long)Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), (ChannelPromise)Mockito.any(ChannelPromise.class));
        this.writtenData = new ArrayList<String>();
        this.writtenPadding = new ArrayList<Integer>();
        Mockito.when((Object)this.writer.writeData((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean(), (ChannelPromise)Mockito.any(ChannelPromise.class))).then((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock in) throws Throwable {
                ChannelPromise promise = (ChannelPromise)in.getArguments()[5];
                if (DefaultHttp2ConnectionEncoderTest.this.streamClosed) {
                    Assertions.fail((String)"Stream already closed");
                } else {
                    DefaultHttp2ConnectionEncoderTest.this.streamClosed = (Boolean)in.getArguments()[4];
                }
                DefaultHttp2ConnectionEncoderTest.this.writtenPadding.add((Integer)in.getArguments()[3]);
                ByteBuf data = (ByteBuf)in.getArguments()[2];
                DefaultHttp2ConnectionEncoderTest.this.writtenData.add(data.toString(CharsetUtil.UTF_8));
                data.release();
                return promise.setSuccess();
            }
        });
        Mockito.when((Object)this.writer.writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean(), (ChannelPromise)Mockito.any(ChannelPromise.class))).then((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                ChannelPromise promise = (ChannelPromise)invocationOnMock.getArgument(8);
                if (DefaultHttp2ConnectionEncoderTest.this.streamClosed) {
                    Assertions.fail((String)"Stream already closed");
                } else {
                    DefaultHttp2ConnectionEncoderTest.this.streamClosed = (Boolean)invocationOnMock.getArgument(5);
                }
                return promise.setSuccess();
            }
        });
        Mockito.when((Object)this.writer.writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyBoolean(), (ChannelPromise)Mockito.any(ChannelPromise.class))).then((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                ChannelPromise promise = (ChannelPromise)invocationOnMock.getArgument(5);
                if (DefaultHttp2ConnectionEncoderTest.this.streamClosed) {
                    Assertions.fail((String)"Stream already closed");
                } else {
                    DefaultHttp2ConnectionEncoderTest.this.streamClosed = (Boolean)invocationOnMock.getArgument(4);
                }
                return promise.setSuccess();
            }
        });
        this.payloadCaptor = ArgumentCaptor.forClass(Http2RemoteFlowController.FlowControlled.class);
        ((Http2RemoteFlowController)Mockito.doNothing().when((Object)this.remoteFlow)).addFlowControlled((Http2Stream)Mockito.any(Http2Stream.class), (Http2RemoteFlowController.FlowControlled)this.payloadCaptor.capture());
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        ((ChannelHandlerContext)Mockito.doAnswer((Answer)new Answer<ChannelPromise>(){

            public ChannelPromise answer(InvocationOnMock in) throws Throwable {
                return DefaultHttp2ConnectionEncoderTest.this.newPromise();
            }
        }).when((Object)this.ctx)).newPromise();
        ((ChannelHandlerContext)Mockito.doAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock in) throws Throwable {
                return DefaultHttp2ConnectionEncoderTest.this.newSucceededFuture();
            }
        }).when((Object)this.ctx)).newSucceededFuture();
        Mockito.when((Object)this.ctx.flush()).thenThrow(new Throwable[]{new AssertionFailedError("forbidden")});
        Mockito.when((Object)this.channel.alloc()).thenReturn((Object)PooledByteBufAllocator.DEFAULT);
        this.connection = new DefaultHttp2Connection(true);
        this.connection.remote().flowController((Http2FlowController)this.remoteFlow);
        this.encoder = new DefaultHttp2ConnectionEncoder(this.connection, this.writer);
        this.encoder.lifecycleManager(this.lifecycleManager);
    }

    @Test
    public void dataWithEndOfStreamWriteShouldSignalThatFrameWasConsumedOnError() throws Exception {
        this.dataWriteShouldSignalThatFrameWasConsumedOnError0(true);
    }

    @Test
    public void dataWriteShouldSignalThatFrameWasConsumedOnError() throws Exception {
        this.dataWriteShouldSignalThatFrameWasConsumedOnError0(false);
    }

    private void dataWriteShouldSignalThatFrameWasConsumedOnError0(boolean endOfStream) throws Exception {
        this.createStream(2, false);
        ByteBuf data = DefaultHttp2ConnectionEncoderTest.dummyData();
        ChannelPromise p = this.newPromise();
        this.encoder.writeData(this.ctx, 2, data, 0, endOfStream, p);
        Http2RemoteFlowController.FlowControlled controlled = (Http2RemoteFlowController.FlowControlled)this.payloadCaptor.getValue();
        Assertions.assertEquals((int)8, (int)controlled.size());
        ((Http2RemoteFlowController.FlowControlled)this.payloadCaptor.getValue()).write(this.ctx, 4);
        Assertions.assertEquals((int)4, (int)controlled.size());
        IllegalStateException error = new IllegalStateException();
        ((Http2RemoteFlowController.FlowControlled)this.payloadCaptor.getValue()).error(this.ctx, (Throwable)error);
        ((Http2RemoteFlowController.FlowControlled)this.payloadCaptor.getValue()).write(this.ctx, 8);
        Assertions.assertEquals((int)0, (int)controlled.size());
        Assertions.assertEquals((Object)"abcd", (Object)this.writtenData.get(0));
        Assertions.assertEquals((int)0, (int)data.refCnt());
        Assertions.assertSame((Object)error, (Object)p.cause());
    }

    @Test
    public void dataWriteShouldSucceed() throws Exception {
        this.createStream(2, false);
        ByteBuf data = DefaultHttp2ConnectionEncoderTest.dummyData();
        ChannelPromise p = this.newPromise();
        this.encoder.writeData(this.ctx, 2, data, 0, true, p);
        Assertions.assertEquals((int)8, (int)((Http2RemoteFlowController.FlowControlled)this.payloadCaptor.getValue()).size());
        ((Http2RemoteFlowController.FlowControlled)this.payloadCaptor.getValue()).write(this.ctx, 8);
        Assertions.assertEquals((int)0, (int)((Http2RemoteFlowController.FlowControlled)this.payloadCaptor.getValue()).size());
        Assertions.assertEquals((Object)"abcdefgh", (Object)this.writtenData.get(0));
        Assertions.assertEquals((int)0, (int)data.refCnt());
        Assertions.assertTrue((boolean)p.isSuccess());
    }

    @Test
    public void dataFramesShouldMerge() throws Exception {
        this.createStream(2, false);
        ByteBuf data = DefaultHttp2ConnectionEncoderTest.dummyData().retain();
        ChannelPromise promise1 = this.newPromise();
        this.encoder.writeData(this.ctx, 2, data, 0, true, promise1);
        ChannelPromise promise2 = this.newPromise();
        this.encoder.writeData(this.ctx, 2, data, 0, true, promise2);
        List capturedWrites = this.payloadCaptor.getAllValues();
        Http2RemoteFlowController.FlowControlled mergedPayload = (Http2RemoteFlowController.FlowControlled)capturedWrites.get(0);
        mergedPayload.merge(this.ctx, (Http2RemoteFlowController.FlowControlled)capturedWrites.get(1));
        Assertions.assertEquals((int)16, (int)mergedPayload.size());
        Assertions.assertFalse((boolean)promise1.isDone());
        Assertions.assertFalse((boolean)promise2.isDone());
        mergedPayload.write(this.ctx, 16);
        Assertions.assertEquals((int)0, (int)mergedPayload.size());
        Assertions.assertEquals((Object)"abcdefghabcdefgh", (Object)this.writtenData.get(0));
        Assertions.assertEquals((int)0, (int)data.refCnt());
        Assertions.assertTrue((boolean)promise1.isSuccess());
        Assertions.assertTrue((boolean)promise2.isSuccess());
    }

    @Test
    public void dataFramesShouldMergeUseVoidPromise() throws Exception {
        this.createStream(2, false);
        ByteBuf data = DefaultHttp2ConnectionEncoderTest.dummyData().retain();
        ChannelPromise promise1 = Http2TestUtil.newVoidPromise(this.channel);
        this.encoder.writeData(this.ctx, 2, data, 0, true, promise1);
        ChannelPromise promise2 = Http2TestUtil.newVoidPromise(this.channel);
        this.encoder.writeData(this.ctx, 2, data, 0, true, promise2);
        List capturedWrites = this.payloadCaptor.getAllValues();
        Http2RemoteFlowController.FlowControlled mergedPayload = (Http2RemoteFlowController.FlowControlled)capturedWrites.get(0);
        mergedPayload.merge(this.ctx, (Http2RemoteFlowController.FlowControlled)capturedWrites.get(1));
        Assertions.assertEquals((int)16, (int)mergedPayload.size());
        Assertions.assertFalse((boolean)promise1.isSuccess());
        Assertions.assertFalse((boolean)promise2.isSuccess());
        mergedPayload.write(this.ctx, 16);
        Assertions.assertEquals((int)0, (int)mergedPayload.size());
        Assertions.assertEquals((Object)"abcdefghabcdefgh", (Object)this.writtenData.get(0));
        Assertions.assertEquals((int)0, (int)data.refCnt());
        Assertions.assertFalse((boolean)promise1.isSuccess());
        Assertions.assertFalse((boolean)promise2.isSuccess());
    }

    @Test
    public void dataFramesDontMergeWithHeaders() throws Exception {
        this.createStream(2, false);
        ByteBuf data = DefaultHttp2ConnectionEncoderTest.dummyData().retain();
        this.encoder.writeData(this.ctx, 2, data, 0, false, this.newPromise());
        Mockito.when((Object)this.remoteFlow.hasFlowControlled((Http2Stream)Mockito.any(Http2Stream.class))).thenReturn((Object)true);
        this.encoder.writeHeaders(this.ctx, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true, this.newPromise());
        List capturedWrites = this.payloadCaptor.getAllValues();
        Assertions.assertFalse((boolean)((Http2RemoteFlowController.FlowControlled)capturedWrites.get(0)).merge(this.ctx, (Http2RemoteFlowController.FlowControlled)capturedWrites.get(1)));
    }

    @Test
    public void emptyFrameShouldSplitPadding() throws Exception {
        ByteBuf data = Unpooled.buffer((int)0);
        this.assertSplitPaddingOnEmptyBuffer(data);
        Assertions.assertEquals((int)0, (int)data.refCnt());
    }

    @Test
    public void writeHeadersUsingVoidPromise() throws Exception {
        final RuntimeException cause = new RuntimeException("fake exception");
        Mockito.when((Object)this.writer.writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyBoolean(), (ChannelPromise)Mockito.any(ChannelPromise.class))).then((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) throws Throwable {
                ChannelPromise promise = (ChannelPromise)invocationOnMock.getArgument(5);
                Assertions.assertFalse((boolean)promise.isVoid());
                return promise.setFailure(cause);
            }
        });
        this.createStream(2, false);
        this.encoder.writeHeaders(this.ctx, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true, Http2TestUtil.newVoidPromise(this.channel));
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyBoolean(), (ChannelPromise)Mockito.any(ChannelPromise.class));
        ((ChannelPipeline)Mockito.verify((Object)this.pipeline)).fireExceptionCaught((Throwable)cause);
    }

    private void assertSplitPaddingOnEmptyBuffer(ByteBuf data) throws Exception {
        this.createStream(2, false);
        Mockito.when((Object)this.frameSizePolicy.maxFrameSize()).thenReturn((Object)5);
        ChannelPromise p = this.newPromise();
        this.encoder.writeData(this.ctx, 2, data, 10, true, p);
        Assertions.assertEquals((int)10, (int)((Http2RemoteFlowController.FlowControlled)this.payloadCaptor.getValue()).size());
        ((Http2RemoteFlowController.FlowControlled)this.payloadCaptor.getValue()).write(this.ctx, 10);
        Assertions.assertEquals((int)1, (int)this.writtenData.size());
        Assertions.assertEquals((Object)"", (Object)this.writtenData.get(0));
        Assertions.assertEquals((int)10, (int)this.writtenPadding.get(0));
        Assertions.assertEquals((int)0, (int)data.refCnt());
        Assertions.assertTrue((boolean)p.isSuccess());
    }

    @Test
    public void headersWriteForUnknownStreamShouldCreateStream() throws Exception {
        this.writeAllFlowControlledFrames();
        int streamId = 6;
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise));
        Assertions.assertTrue((boolean)promise.isSuccess());
    }

    @Test
    public void headersWriteShouldOpenStreamForPush() throws Exception {
        this.writeAllFlowControlledFrames();
        Http2Stream parent = this.createStream(2, false);
        this.reservePushStream(4, parent);
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 4, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise);
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)this.stream(4).state());
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)4), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void trailersDoNotEndStreamThrows() {
        this.writeAllFlowControlledFrames();
        int streamId = 6;
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise);
        ChannelPromise promise2 = this.newPromise();
        ChannelFuture future = this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise2);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isSuccess());
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void trailersDoNotEndStreamWithDataThrows() {
        this.writeAllFlowControlledFrames();
        int streamId = 6;
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise);
        Http2Stream stream = this.connection.stream(6);
        Mockito.when((Object)this.remoteFlow.hasFlowControlled((Http2Stream)Mockito.eq((Object)stream))).thenReturn((Object)true);
        ChannelPromise promise2 = this.newPromise();
        ChannelFuture future = this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise2);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isSuccess());
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void tooManyHeadersNoEOSThrows() {
        this.tooManyHeadersThrows(false);
    }

    @Test
    public void tooManyHeadersEOSThrows() {
        this.tooManyHeadersThrows(true);
    }

    private void tooManyHeadersThrows(boolean eos) {
        this.writeAllFlowControlledFrames();
        int streamId = 6;
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise);
        ChannelPromise promise2 = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true, promise2);
        ChannelPromise promise3 = this.newPromise();
        ChannelFuture future = this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, eos, promise3);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isSuccess());
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise));
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)promise2));
    }

    @Test
    public void infoHeadersAndTrailersAllowed() throws Exception {
        this.infoHeadersAndTrailers(true, 1);
    }

    @Test
    public void multipleInfoHeadersAndTrailersAllowed() throws Exception {
        this.infoHeadersAndTrailers(true, 10);
    }

    @Test
    public void infoHeadersAndTrailersNoEOSThrows() throws Exception {
        this.infoHeadersAndTrailers(false, 1);
    }

    @Test
    public void multipleInfoHeadersAndTrailersNoEOSThrows() throws Exception {
        this.infoHeadersAndTrailers(false, 10);
    }

    private void infoHeadersAndTrailers(boolean eos, int infoHeaderCount) {
        this.writeAllFlowControlledFrames();
        int streamId = 6;
        Http2Headers infoHeaders = DefaultHttp2ConnectionEncoderTest.informationalHeaders();
        for (int i = 0; i < infoHeaderCount; ++i) {
            this.encoder.writeHeaders(this.ctx, 6, infoHeaders, 0, false, this.newPromise());
        }
        ChannelPromise promise2 = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise2);
        ChannelPromise promise3 = this.newPromise();
        ChannelFuture future = this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, eos, promise3);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)eos, (Object)future.isSuccess());
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)infoHeaderCount))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)infoHeaders), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.any(ChannelPromise.class));
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise2));
        if (eos) {
            ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)promise3));
        }
    }

    private static Http2Headers informationalHeaders() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.status((CharSequence)HttpResponseStatus.CONTINUE.codeAsText());
        return headers;
    }

    @Test
    public void tooManyHeadersWithDataNoEOSThrows() {
        this.tooManyHeadersWithDataThrows(false);
    }

    @Test
    public void tooManyHeadersWithDataEOSThrows() {
        this.tooManyHeadersWithDataThrows(true);
    }

    private void tooManyHeadersWithDataThrows(boolean eos) {
        this.writeAllFlowControlledFrames();
        int streamId = 6;
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise);
        Http2Stream stream = this.connection.stream(6);
        Mockito.when((Object)this.remoteFlow.hasFlowControlled((Http2Stream)Mockito.eq((Object)stream))).thenReturn((Object)true);
        ChannelPromise promise2 = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true, promise2);
        ChannelPromise promise3 = this.newPromise();
        ChannelFuture future = this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, eos, promise3);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isSuccess());
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise));
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)promise2));
    }

    @Test
    public void infoHeadersAndTrailersWithDataAllowed() {
        this.infoHeadersAndTrailersWithData(true, 1);
    }

    @Test
    public void multipleInfoHeadersAndTrailersWithDataAllowed() {
        this.infoHeadersAndTrailersWithData(true, 10);
    }

    @Test
    public void infoHeadersAndTrailersWithDataNoEOSThrows() {
        this.infoHeadersAndTrailersWithData(false, 1);
    }

    @Test
    public void multipleInfoHeadersAndTrailersWithDataNoEOSThrows() {
        this.infoHeadersAndTrailersWithData(false, 10);
    }

    private void infoHeadersAndTrailersWithData(boolean eos, int infoHeaderCount) {
        this.writeAllFlowControlledFrames();
        int streamId = 6;
        Http2Headers infoHeaders = DefaultHttp2ConnectionEncoderTest.informationalHeaders();
        for (int i = 0; i < infoHeaderCount; ++i) {
            this.encoder.writeHeaders(this.ctx, 6, infoHeaders, 0, false, this.newPromise());
        }
        Http2Stream stream = this.connection.stream(6);
        Mockito.when((Object)this.remoteFlow.hasFlowControlled((Http2Stream)Mockito.eq((Object)stream))).thenReturn((Object)true);
        ChannelPromise promise2 = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise2);
        ChannelPromise promise3 = this.newPromise();
        ChannelFuture future = this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, eos, promise3);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)eos, (Object)future.isSuccess());
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)infoHeaderCount))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)infoHeaders), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.any(ChannelPromise.class));
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise2));
        if (eos) {
            ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)promise3));
        }
    }

    @Test
    public void pushPromiseWriteAfterGoAwayReceivedShouldFail() throws Exception {
        this.createStream(2, false);
        this.goAwayReceived(0);
        ChannelFuture future = this.encoder.writePushPromise(this.ctx, 2, 4, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, this.newPromise());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isSuccess());
    }

    @Test
    public void pushPromiseWriteShouldReserveStream() throws Exception {
        this.createStream(2, false);
        ChannelPromise promise = this.newPromise();
        this.encoder.writePushPromise(this.ctx, 2, 4, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, promise);
        Assertions.assertEquals((Object)Http2Stream.State.RESERVED_LOCAL, (Object)this.stream(4).state());
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writePushPromise((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), Mockito.eq((int)4), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void priorityWriteAfterGoAwayShouldSucceed() throws Exception {
        this.createStream(2, false);
        this.goAwayReceived(Integer.MAX_VALUE);
        ChannelPromise promise = this.newPromise();
        this.encoder.writePriority(this.ctx, 2, 0, (short)255, true, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writePriority((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), Mockito.eq((int)0), Mockito.eq((short)255), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void priorityWriteShouldSetPriorityForStream() throws Exception {
        ChannelPromise promise = this.newPromise();
        short weight = 255;
        this.encoder.writePriority(this.ctx, 2, 0, weight, true, promise);
        Http2Stream stream = this.stream(2);
        Assertions.assertNull((Object)stream);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writePriority((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), Mockito.eq((int)0), Mockito.eq((short)255), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void priorityWriteOnPreviouslyExistingStreamShouldSucceed() throws Exception {
        this.createStream(2, false).close();
        ChannelPromise promise = this.newPromise();
        short weight = 255;
        this.encoder.writePriority(this.ctx, 2, 0, weight, true, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writePriority((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), Mockito.eq((int)0), Mockito.eq((short)weight), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void priorityWriteOnPreviouslyExistingParentStreamShouldSucceed() throws Exception {
        int parentStreamId = 4;
        this.createStream(2, false);
        this.createStream(4, false).close();
        ChannelPromise promise = this.newPromise();
        short weight = 255;
        this.encoder.writePriority(this.ctx, 2, 4, weight, true, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writePriority((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), Mockito.eq((int)4), Mockito.eq((short)weight), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void rstStreamWriteForUnknownStreamShouldIgnore() throws Exception {
        ChannelPromise promise = this.newPromise();
        this.encoder.writeRstStream(this.ctx, 5, Http2Error.PROTOCOL_ERROR.code(), promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.never())).writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyLong(), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void rstStreamShouldCloseStream() throws Exception {
        this.writeAllFlowControlledFrames();
        this.encoder.writeHeaders(this.ctx, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true, this.newPromise());
        this.stream(2);
        ChannelPromise promise = this.newPromise();
        this.encoder.writeRstStream(this.ctx, 2, Http2Error.PROTOCOL_ERROR.code(), promise);
        ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager)).resetStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), Mockito.anyLong(), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void pingWriteAfterGoAwayShouldSucceed() throws Exception {
        ChannelPromise promise = this.newPromise();
        this.goAwayReceived(0);
        this.encoder.writePing(this.ctx, false, 0L, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writePing((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((boolean)false), Mockito.eq((long)0L), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void pingWriteShouldSucceed() throws Exception {
        ChannelPromise promise = this.newPromise();
        this.encoder.writePing(this.ctx, false, 0L, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writePing((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((boolean)false), Mockito.eq((long)0L), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void settingsWriteAfterGoAwayShouldSucceed() throws Exception {
        this.goAwayReceived(0);
        ChannelPromise promise = this.newPromise();
        this.encoder.writeSettings(this.ctx, new Http2Settings(), promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writeSettings((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (Http2Settings)Mockito.any(Http2Settings.class), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void settingsWriteShouldNotUpdateSettings() throws Exception {
        Http2Settings settings = new Http2Settings();
        settings.initialWindowSize(100);
        settings.maxConcurrentStreams(1000L);
        settings.headerTableSize(2000L);
        ChannelPromise promise = this.newPromise();
        this.encoder.writeSettings(this.ctx, settings, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writeSettings((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (Http2Settings)Mockito.eq((Object)settings), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void dataWriteShouldCreateHalfClosedStream() throws Exception {
        this.writeAllFlowControlledFrames();
        Http2Stream stream = this.createStream(2, false);
        ByteBuf data = DefaultHttp2ConnectionEncoderTest.dummyData();
        ChannelPromise promise = this.newPromise();
        this.encoder.writeData(this.ctx, 2, data.retain(), 0, true, promise);
        Assertions.assertTrue((boolean)promise.isSuccess());
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow)).addFlowControlled((Http2Stream)Mockito.eq((Object)stream), (Http2RemoteFlowController.FlowControlled)Mockito.any(Http2RemoteFlowController.FlowControlled.class));
        ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager)).closeStreamLocal(stream, (ChannelFuture)promise);
        Assertions.assertEquals((Object)data.toString(CharsetUtil.UTF_8), (Object)this.writtenData.get(0));
        data.release();
    }

    @Test
    public void headersWriteShouldHalfCloseStream() throws Exception {
        this.writeAllFlowControlledFrames();
        this.createStream(2, false);
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true, promise);
        Assertions.assertTrue((boolean)promise.isSuccess());
        ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager)).closeStreamLocal((Http2Stream)Mockito.eq((Object)this.stream(2)), (ChannelFuture)Mockito.eq((Object)promise));
    }

    @Test
    public void headersWriteShouldHalfClosePushStream() throws Exception {
        this.writeAllFlowControlledFrames();
        Http2Stream parent = this.createStream(2, false);
        Http2Stream stream = this.reservePushStream(4, parent);
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 4, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true, promise);
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Assertions.assertTrue((boolean)promise.isSuccess());
        ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager)).closeStreamLocal((Http2Stream)Mockito.eq((Object)stream), (ChannelFuture)Mockito.eq((Object)promise));
    }

    @Test
    public void headersWriteShouldHalfCloseAfterOnErrorForPreCreatedStream() throws Exception {
        final ChannelPromise promise = this.newPromise();
        final RuntimeException ex = new RuntimeException();
        Mockito.when((Object)this.writer.writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)promise))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocation) {
                promise.setFailure(ex);
                return promise;
            }
        });
        this.writeAllFlowControlledFrames();
        Http2Stream stream = this.createStream(2, false);
        this.encoder.writeHeaders(this.ctx, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true, promise);
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
        Assertions.assertFalse((boolean)stream.isHeadersSent());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.lifecycleManager});
        ((Http2LifecycleManager)inOrder.verify((Object)this.lifecycleManager)).onError((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((boolean)true), (Throwable)Mockito.eq((Object)ex));
        ((Http2LifecycleManager)inOrder.verify((Object)this.lifecycleManager)).closeStreamLocal((Http2Stream)Mockito.eq((Object)this.stream(2)), (ChannelFuture)Mockito.eq((Object)promise));
    }

    @Test
    public void headersWriteShouldHalfCloseAfterOnErrorForImplicitlyCreatedStream() throws Exception {
        final ChannelPromise promise = this.newPromise();
        final RuntimeException ex = new RuntimeException();
        Mockito.when((Object)this.writer.writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)promise))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocation) {
                promise.setFailure(ex);
                return promise;
            }
        });
        this.writeAllFlowControlledFrames();
        this.encoder.writeHeaders(this.ctx, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true, promise);
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
        Assertions.assertFalse((boolean)this.stream(2).isHeadersSent());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.lifecycleManager});
        ((Http2LifecycleManager)inOrder.verify((Object)this.lifecycleManager)).onError((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((boolean)true), (Throwable)Mockito.eq((Object)ex));
        ((Http2LifecycleManager)inOrder.verify((Object)this.lifecycleManager)).closeStreamLocal((Http2Stream)Mockito.eq((Object)this.stream(2)), (ChannelFuture)Mockito.eq((Object)promise));
    }

    @Test
    public void encoderDelegatesGoAwayToLifeCycleManager() {
        ChannelPromise promise = this.newPromise();
        this.encoder.writeGoAway(this.ctx, 2, Http2Error.INTERNAL_ERROR.code(), null, promise);
        ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager)).goAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), Mockito.eq((long)Http2Error.INTERNAL_ERROR.code()), (ByteBuf)Mockito.eq((Object)null), (ChannelPromise)Mockito.eq((Object)promise));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.writer});
    }

    @Test
    public void dataWriteToClosedStreamShouldFail() throws Exception {
        this.createStream(2, false).close();
        ByteBuf data = (ByteBuf)Mockito.mock(ByteBuf.class);
        ChannelPromise promise = this.newPromise();
        this.encoder.writeData(this.ctx, 2, data, 0, false, promise);
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
        MatcherAssert.assertThat((Object)promise.cause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
        ((ByteBuf)Mockito.verify((Object)data)).release();
    }

    @Test
    public void dataWriteToHalfClosedLocalStreamShouldFail() throws Exception {
        this.createStream(2, true);
        ByteBuf data = (ByteBuf)Mockito.mock(ByteBuf.class);
        ChannelPromise promise = this.newPromise();
        this.encoder.writeData(this.ctx, 2, data, 0, false, promise);
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
        MatcherAssert.assertThat((Object)promise.cause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        ((ByteBuf)Mockito.verify((Object)data)).release();
    }

    @Test
    public void canWriteDataFrameAfterGoAwaySent() throws Exception {
        Http2Stream stream = this.createStream(2, false);
        this.connection.goAwaySent(0, 0L, Unpooled.EMPTY_BUFFER);
        ByteBuf data = (ByteBuf)Mockito.mock(ByteBuf.class);
        this.encoder.writeData(this.ctx, 2, data, 0, false, this.newPromise());
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow)).addFlowControlled((Http2Stream)Mockito.eq((Object)stream), (Http2RemoteFlowController.FlowControlled)Mockito.any(Http2RemoteFlowController.FlowControlled.class));
    }

    @Test
    public void canWriteHeaderFrameAfterGoAwaySent() throws Exception {
        this.writeAllFlowControlledFrames();
        this.createStream(2, false);
        this.goAwaySent(0);
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void canWriteDataFrameAfterGoAwayReceived() throws Exception {
        Http2Stream stream = this.createStream(2, false);
        this.goAwayReceived(2);
        ByteBuf data = (ByteBuf)Mockito.mock(ByteBuf.class);
        this.encoder.writeData(this.ctx, 2, data, 0, false, this.newPromise());
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow)).addFlowControlled((Http2Stream)Mockito.eq((Object)stream), (Http2RemoteFlowController.FlowControlled)Mockito.any(Http2RemoteFlowController.FlowControlled.class));
    }

    @Test
    public void canWriteHeaderFrameAfterGoAwayReceived() throws Http2Exception {
        this.writeAllFlowControlledFrames();
        this.goAwayReceived(2);
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)2), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void headersWithNoPriority() {
        this.writeAllFlowControlledFrames();
        int streamId = 6;
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise));
    }

    @Test
    public void headersWithPriority() {
        this.writeAllFlowControlledFrames();
        int streamId = 6;
        ChannelPromise promise = this.newPromise();
        this.encoder.writeHeaders(this.ctx, 6, (Http2Headers)EmptyHttp2Headers.INSTANCE, 10, (short)16, true, 1, false, promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer)).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)6), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)10), Mockito.eq((short)16), Mockito.eq((boolean)true), Mockito.eq((int)1), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)promise));
    }

    private void writeAllFlowControlledFrames() {
        ((Http2RemoteFlowController)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Http2RemoteFlowController.FlowControlled flowControlled = (Http2RemoteFlowController.FlowControlled)invocationOnMock.getArguments()[1];
                flowControlled.write(DefaultHttp2ConnectionEncoderTest.this.ctx, Integer.MAX_VALUE);
                flowControlled.writeComplete();
                return null;
            }
        }).when((Object)this.remoteFlow)).addFlowControlled((Http2Stream)Mockito.any(Http2Stream.class), (Http2RemoteFlowController.FlowControlled)this.payloadCaptor.capture());
    }

    private Http2Stream createStream(int streamId, boolean halfClosed) throws Http2Exception {
        return this.connection.local().createStream(streamId, halfClosed);
    }

    private Http2Stream reservePushStream(int pushStreamId, Http2Stream parent) throws Http2Exception {
        return this.connection.local().reservePushStream(pushStreamId, parent);
    }

    private Http2Stream stream(int streamId) {
        return this.connection.stream(streamId);
    }

    private void goAwayReceived(int lastStreamId) throws Http2Exception {
        this.connection.goAwayReceived(lastStreamId, 0L, Unpooled.EMPTY_BUFFER);
    }

    private void goAwaySent(int lastStreamId) throws Http2Exception {
        this.connection.goAwaySent(lastStreamId, 0L, Unpooled.EMPTY_BUFFER);
    }

    private ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
    }

    private ChannelFuture newSucceededFuture() {
        return this.newPromise().setSuccess();
    }

    private static ByteBuf dummyData() {
        return Unpooled.wrappedBuffer((byte[])"abcdefgh".getBytes(CharsetUtil.UTF_8));
    }
}

