/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.HpackDecoder;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;

public class HpackEncoderTest {
    private HpackDecoder hpackDecoder;
    private HpackEncoder hpackEncoder;
    private Http2Headers mockHeaders;

    @BeforeEach
    public void setUp() {
        this.hpackEncoder = new HpackEncoder();
        this.hpackDecoder = new HpackDecoder(8192L);
        this.mockHeaders = (Http2Headers)Mockito.mock(Http2Headers.class);
    }

    @Test
    public void testSetMaxHeaderTableSizeToMaxValue() throws Http2Exception {
        ByteBuf buf = Unpooled.buffer();
        this.hpackEncoder.setMaxHeaderTableSize(buf, 0xFFFFFFFFL);
        this.hpackDecoder.setMaxHeaderTableSize(0xFFFFFFFFL);
        this.hpackDecoder.decode(0, buf, this.mockHeaders, true);
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)this.hpackDecoder.getMaxHeaderTableSize());
        buf.release();
    }

    @Test
    public void testSetMaxHeaderTableSizeOverflow() throws Http2Exception {
        final ByteBuf buf = Unpooled.buffer();
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackEncoderTest.this.hpackEncoder.setMaxHeaderTableSize(buf, 0x100000000L);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWillEncode16MBHeaderByDefault() throws Http2Exception {
        ByteBuf buf = Unpooled.buffer();
        String bigHeaderName = "x-big-header";
        int bigHeaderSize = 0x1000000;
        String bigHeaderVal = new String(new char[bigHeaderSize]).replace('\u0000', 'X');
        Http2Headers headersIn = (Http2Headers)new DefaultHttp2Headers().add((Object)"x-big-header", (Object)bigHeaderVal);
        DefaultHttp2Headers headersOut = new DefaultHttp2Headers();
        try {
            this.hpackEncoder.encodeHeaders(0, buf, headersIn, Http2HeadersEncoder.NEVER_SENSITIVE);
            this.hpackDecoder.setMaxHeaderListSize((long)(bigHeaderSize + 1024));
            this.hpackDecoder.decode(0, buf, (Http2Headers)headersOut, false);
        }
        finally {
            buf.release();
        }
        Assertions.assertEquals((Object)((CharSequence)headersOut.get((Object)bigHeaderName)).toString(), (Object)bigHeaderVal);
    }

    @Test
    public void testSetMaxHeaderListSizeEnforcedAfterSet() throws Http2Exception {
        final ByteBuf buf = Unpooled.buffer();
        final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().add((Object)"x-big-header", (Object)new String(new char[16384]).replace('\u0000', 'X'));
        this.hpackEncoder.setMaxHeaderListSize(1000L);
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackEncoderTest.this.hpackEncoder.encodeHeaders(0, buf, headers, Http2HeadersEncoder.NEVER_SENSITIVE);
                }
            });
        }
        finally {
            buf.release();
        }
    }
}

