/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class HttpToHttp2ConnectionHandlerTest {
    private static final int WAIT_TIME_SECONDS = 5;
    @Mock
    private Http2FrameListener clientListener;
    @Mock
    private Http2FrameListener serverListener;
    private ServerBootstrap sb;
    private Bootstrap cb;
    private Channel serverChannel;
    private volatile Channel serverConnectedChannel;
    private Channel clientChannel;
    private CountDownLatch requestLatch;
    private CountDownLatch serverSettingsAckLatch;
    private CountDownLatch trailersLatch;
    private Http2TestUtil.FrameCountDown serverFrameCountDown;

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @AfterEach
    public void teardown() throws Exception {
        Channel serverConnectedChannel;
        if (this.clientChannel != null) {
            this.clientChannel.close().syncUninterruptibly();
            this.clientChannel = null;
        }
        if (this.serverChannel != null) {
            this.serverChannel.close().syncUninterruptibly();
            this.serverChannel = null;
        }
        if ((serverConnectedChannel = this.serverConnectedChannel) != null) {
            serverConnectedChannel.close().syncUninterruptibly();
            this.serverConnectedChannel = null;
        }
        Future serverGroup = this.sb.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        Future serverChildGroup = this.sb.config().childGroup().shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        Future clientGroup = this.cb.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        serverGroup.syncUninterruptibly();
        serverChildGroup.syncUninterruptibly();
        clientGroup.syncUninterruptibly();
    }

    @Test
    public void testHeadersOnlyRequest() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://my-user_name@www.example.org:5555/example");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"my-user_name@www.example.org:5555");
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        httpHeaders.add(Http2TestUtil.of("foo"), (Object)Http2TestUtil.of("goo"));
        httpHeaders.add(Http2TestUtil.of("foo"), (Object)Http2TestUtil.of("goo2"));
        httpHeaders.add(Http2TestUtil.of("foo2"), (Object)Http2TestUtil.of("goo2"));
        Http2Headers http2Headers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/example")).authority((CharSequence)new AsciiString((CharSequence)"www.example.org:5555")).scheme((CharSequence)new AsciiString((CharSequence)"http")).add((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo"))).add((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo2"))).add((Object)new AsciiString((CharSequence)"foo2"), (Object)new AsciiString((CharSequence)"goo2"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testHttpScheme() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://my-user_name@www.example.org:5555/example");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"my-user_name@www.example.org:5555");
        httpHeaders.add(Http2TestUtil.of("foo"), (Object)Http2TestUtil.of("goo"));
        httpHeaders.add(Http2TestUtil.of("foo"), (Object)Http2TestUtil.of("goo2"));
        httpHeaders.add(Http2TestUtil.of("foo2"), (Object)Http2TestUtil.of("goo2"));
        Http2Headers http2Headers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/example")).authority((CharSequence)new AsciiString((CharSequence)"www.example.org:5555")).scheme((CharSequence)new AsciiString((CharSequence)"http")).scheme((CharSequence)new AsciiString((CharSequence)"http")).add((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo"))).add((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo2"))).add((Object)new AsciiString((CharSequence)"foo2"), (Object)new AsciiString((CharSequence)"goo2"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testMultipleCookieEntriesAreCombined() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://my-user_name@www.example.org:5555/example");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"my-user_name@www.example.org:5555");
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        httpHeaders.set((CharSequence)HttpHeaderNames.COOKIE, (Object)"a=b; c=d; e=f");
        Http2Headers http2Headers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/example")).authority((CharSequence)new AsciiString((CharSequence)"www.example.org:5555")).scheme((CharSequence)new AsciiString((CharSequence)"http")).add((Object)HttpHeaderNames.COOKIE, (Object)"a=b")).add((Object)HttpHeaderNames.COOKIE, (Object)"c=d")).add((Object)HttpHeaderNames.COOKIE, (Object)"e=f");
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testOriginFormRequestTargetHandled() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/where?q=now&f=then#section1");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/where?q=now&f=then#section1")).scheme((CharSequence)new AsciiString((CharSequence)"http"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testOriginFormRequestTargetHandledFromUrlencodedUri() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/where%2B0?q=now%2B0&f=then%2B0#section1%2B0");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/where%2B0?q=now%2B0&f=then%2B0#section1%2B0")).scheme((CharSequence)new AsciiString((CharSequence)"http"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testAbsoluteFormRequestTargetHandledFromHeaders() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/pub/WWW/TheProject.html");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"foouser@www.example.org:5555");
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.PATH.text(), (Object)"ignored_path");
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"https");
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/pub/WWW/TheProject.html")).authority((CharSequence)new AsciiString((CharSequence)"www.example.org:5555")).scheme((CharSequence)new AsciiString((CharSequence)"https"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testAbsoluteFormRequestTargetHandledFromRequestTargetUri() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://foouser@www.example.org:5555/pub/WWW/TheProject.html");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/pub/WWW/TheProject.html")).authority((CharSequence)new AsciiString((CharSequence)"www.example.org:5555")).scheme((CharSequence)new AsciiString((CharSequence)"http"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testAuthorityFormRequestTargetHandled() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, "http://www.example.com:80");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"CONNECT")).path((CharSequence)new AsciiString((CharSequence)"/")).scheme((CharSequence)new AsciiString((CharSequence)"http")).authority((CharSequence)new AsciiString((CharSequence)"www.example.com:80"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testAsterikFormRequestTargetHandled() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.OPTIONS, "*");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"www.example.com:80");
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"OPTIONS")).path((CharSequence)new AsciiString((CharSequence)"*")).scheme((CharSequence)new AsciiString((CharSequence)"http")).authority((CharSequence)new AsciiString((CharSequence)"www.example.com:80"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testHostIPv6FormRequestTargetHandled() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"[::1]:80");
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/")).scheme((CharSequence)new AsciiString((CharSequence)"http")).authority((CharSequence)new AsciiString((CharSequence)"[::1]:80"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testHostFormRequestTargetHandled() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"localhost:80");
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/")).scheme((CharSequence)new AsciiString((CharSequence)"http")).authority((CharSequence)new AsciiString((CharSequence)"localhost:80"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testHostIPv4FormRequestTargetHandled() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"1.2.3.4:80");
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/")).scheme((CharSequence)new AsciiString((CharSequence)"http")).authority((CharSequence)new AsciiString((CharSequence)"1.2.3.4:80"));
        ChannelPromise writePromise = this.newPromise();
        this.verifyHeadersOnly(http2Headers, writePromise, this.clientChannel.writeAndFlush((Object)request, writePromise));
    }

    @Test
    public void testNoSchemeRequestTargetHandled() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
        ChannelPromise writePromise = this.newPromise();
        ChannelFuture writeFuture = this.clientChannel.writeAndFlush((Object)request, writePromise);
        Assertions.assertTrue((boolean)writePromise.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)writePromise.isDone());
        Assertions.assertFalse((boolean)writePromise.isSuccess());
        Assertions.assertTrue((boolean)writeFuture.isDone());
        Assertions.assertFalse((boolean)writeFuture.isSuccess());
    }

    @Test
    public void testInvalidStreamId() throws Exception {
        this.bootstrapEnv(2, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/foo", Unpooled.copiedBuffer((CharSequence)"foobar", (Charset)CharsetUtil.UTF_8));
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), -1);
        httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
        ChannelPromise writePromise = this.newPromise();
        ChannelFuture writeFuture = this.clientChannel.writeAndFlush((Object)request, writePromise);
        Assertions.assertTrue((boolean)writePromise.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)writePromise.isDone());
        Assertions.assertFalse((boolean)writePromise.isSuccess());
        Throwable cause = writePromise.cause();
        MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(Http2NoMoreStreamIdsException.class));
        Assertions.assertTrue((boolean)writeFuture.isDone());
        Assertions.assertFalse((boolean)writeFuture.isSuccess());
        cause = writeFuture.cause();
        MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(Http2NoMoreStreamIdsException.class));
    }

    @Test
    public void testRequestWithBody() throws Exception {
        String text = "foooooogoooo";
        final List receivedBuffers = Collections.synchronizedList(new ArrayList());
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock in) throws Throwable {
                receivedBuffers.add(((ByteBuf)in.getArguments()[2]).toString(CharsetUtil.UTF_8));
                return null;
            }
        }).when((Object)this.serverListener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)true));
        this.bootstrapEnv(3, 1, 0);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://your_user-name123@www.example.org:5555/example", Unpooled.copiedBuffer((CharSequence)"foooooogoooo", (Charset)CharsetUtil.UTF_8));
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"www.example-origin.org:5555");
        httpHeaders.add(Http2TestUtil.of("foo"), (Object)Http2TestUtil.of("goo"));
        httpHeaders.add(Http2TestUtil.of("foo"), (Object)Http2TestUtil.of("goo2"));
        httpHeaders.add(Http2TestUtil.of("foo2"), (Object)Http2TestUtil.of("goo2"));
        Http2Headers http2Headers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"POST")).path((CharSequence)new AsciiString((CharSequence)"/example")).authority((CharSequence)new AsciiString((CharSequence)"www.example-origin.org:5555")).scheme((CharSequence)new AsciiString((CharSequence)"http")).add((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo"))).add((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo2"))).add((Object)new AsciiString((CharSequence)"foo2"), (Object)new AsciiString((CharSequence)"goo2"));
        ChannelPromise writePromise = this.newPromise();
        ChannelFuture writeFuture = this.clientChannel.writeAndFlush((Object)request, writePromise);
        Assertions.assertTrue((boolean)writePromise.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)writePromise.isSuccess());
        Assertions.assertTrue((boolean)writeFuture.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)writeFuture.isSuccess());
        this.awaitRequests();
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)http2Headers), Mockito.eq((int)0), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.eq((int)0), Mockito.eq((boolean)false));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)true));
        Assertions.assertEquals((int)1, (int)receivedBuffers.size());
        Assertions.assertEquals((Object)"foooooogoooo", receivedBuffers.get(0));
    }

    @Test
    public void testRequestWithBodyAndTrailingHeaders() throws Exception {
        String text = "foooooogoooo";
        final List receivedBuffers = Collections.synchronizedList(new ArrayList());
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock in) throws Throwable {
                receivedBuffers.add(((ByteBuf)in.getArguments()[2]).toString(CharsetUtil.UTF_8));
                return null;
            }
        }).when((Object)this.serverListener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)false));
        this.bootstrapEnv(4, 1, 1);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://your_user-name123@www.example.org:5555/example", Unpooled.copiedBuffer((CharSequence)"foooooogoooo", (Charset)CharsetUtil.UTF_8));
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"www.example.org:5555");
        httpHeaders.add(Http2TestUtil.of("foo"), (Object)Http2TestUtil.of("goo"));
        httpHeaders.add(Http2TestUtil.of("foo"), (Object)Http2TestUtil.of("goo2"));
        httpHeaders.add(Http2TestUtil.of("foo2"), (Object)Http2TestUtil.of("goo2"));
        Http2Headers http2Headers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"POST")).path((CharSequence)new AsciiString((CharSequence)"/example")).authority((CharSequence)new AsciiString((CharSequence)"www.example.org:5555")).scheme((CharSequence)new AsciiString((CharSequence)"http")).add((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo"))).add((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo2"))).add((Object)new AsciiString((CharSequence)"foo2"), (Object)new AsciiString((CharSequence)"goo2"));
        request.trailingHeaders().add(Http2TestUtil.of("trailing"), (Object)Http2TestUtil.of("bar"));
        Http2Headers http2TrailingHeaders = (Http2Headers)new DefaultHttp2Headers().add((Object)new AsciiString((CharSequence)"trailing"), (Object)new AsciiString((CharSequence)"bar"));
        ChannelPromise writePromise = this.newPromise();
        ChannelFuture writeFuture = this.clientChannel.writeAndFlush((Object)request, writePromise);
        Assertions.assertTrue((boolean)writePromise.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)writePromise.isSuccess());
        Assertions.assertTrue((boolean)writeFuture.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)writeFuture.isSuccess());
        this.awaitRequests();
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)http2Headers), Mockito.eq((int)0), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.eq((int)0), Mockito.eq((boolean)false));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)false));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)http2TrailingHeaders), Mockito.eq((int)0), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.eq((int)0), Mockito.eq((boolean)true));
        Assertions.assertEquals((int)1, (int)receivedBuffers.size());
        Assertions.assertEquals((Object)"foooooogoooo", receivedBuffers.get(0));
    }

    @Test
    public void testChunkedRequestWithBodyAndTrailingHeaders() throws Exception {
        String text = "foooooo";
        String text2 = "goooo";
        final List receivedBuffers = Collections.synchronizedList(new ArrayList());
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock in) throws Throwable {
                receivedBuffers.add(((ByteBuf)in.getArguments()[2]).toString(CharsetUtil.UTF_8));
                return null;
            }
        }).when((Object)this.serverListener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)false));
        this.bootstrapEnv(4, 1, 1);
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://your_user-name123@www.example.org:5555/example");
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"www.example.org:5555");
        httpHeaders.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
        httpHeaders.add(Http2TestUtil.of("foo"), (Object)Http2TestUtil.of("goo"));
        httpHeaders.add(Http2TestUtil.of("foo"), (Object)Http2TestUtil.of("goo2"));
        httpHeaders.add(Http2TestUtil.of("foo2"), (Object)Http2TestUtil.of("goo2"));
        Http2Headers http2Headers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"POST")).path((CharSequence)new AsciiString((CharSequence)"/example")).authority((CharSequence)new AsciiString((CharSequence)"www.example.org:5555")).scheme((CharSequence)new AsciiString((CharSequence)"http")).add((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo"))).add((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo2"))).add((Object)new AsciiString((CharSequence)"foo2"), (Object)new AsciiString((CharSequence)"goo2"));
        DefaultHttpContent httpContent = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"foooooo", (Charset)CharsetUtil.UTF_8));
        DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"goooo", (Charset)CharsetUtil.UTF_8));
        lastHttpContent.trailingHeaders().add(Http2TestUtil.of("trailing"), (Object)Http2TestUtil.of("bar"));
        Http2Headers http2TrailingHeaders = (Http2Headers)new DefaultHttp2Headers().add((Object)new AsciiString((CharSequence)"trailing"), (Object)new AsciiString((CharSequence)"bar"));
        ChannelPromise writePromise = this.newPromise();
        ChannelFuture writeFuture = this.clientChannel.write((Object)request, writePromise);
        ChannelPromise contentPromise = this.newPromise();
        ChannelFuture contentFuture = this.clientChannel.write((Object)httpContent, contentPromise);
        ChannelPromise lastContentPromise = this.newPromise();
        ChannelFuture lastContentFuture = this.clientChannel.write((Object)lastHttpContent, lastContentPromise);
        this.clientChannel.flush();
        Assertions.assertTrue((boolean)writePromise.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)writePromise.isSuccess());
        Assertions.assertTrue((boolean)writeFuture.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)writeFuture.isSuccess());
        Assertions.assertTrue((boolean)contentPromise.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)contentPromise.isSuccess());
        Assertions.assertTrue((boolean)contentFuture.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)contentFuture.isSuccess());
        Assertions.assertTrue((boolean)lastContentPromise.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)lastContentPromise.isSuccess());
        Assertions.assertTrue((boolean)lastContentFuture.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)lastContentFuture.isSuccess());
        this.awaitRequests();
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)http2Headers), Mockito.eq((int)0), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.eq((int)0), Mockito.eq((boolean)false));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)false));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)http2TrailingHeaders), Mockito.eq((int)0), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.eq((int)0), Mockito.eq((boolean)true));
        Assertions.assertEquals((int)1, (int)receivedBuffers.size());
        Assertions.assertEquals((Object)"foooooogoooo", receivedBuffers.get(0));
    }

    private void bootstrapEnv(int requestCountDown, int serverSettingsAckCount, int trailersCount) throws Exception {
        final CountDownLatch prefaceWrittenLatch = new CountDownLatch(1);
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        this.requestLatch = new CountDownLatch(requestCountDown);
        this.serverSettingsAckLatch = new CountDownLatch(serverSettingsAckCount);
        this.trailersLatch = trailersCount == 0 ? null : new CountDownLatch(trailersCount);
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        this.sb.group((EventLoopGroup)new DefaultEventLoopGroup());
        this.sb.channel(LocalServerChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                HttpToHttp2ConnectionHandlerTest.this.serverConnectedChannel = ch;
                ChannelPipeline p = ch.pipeline();
                HttpToHttp2ConnectionHandlerTest.this.serverFrameCountDown = new Http2TestUtil.FrameCountDown(HttpToHttp2ConnectionHandlerTest.this.serverListener, HttpToHttp2ConnectionHandlerTest.this.serverSettingsAckLatch, HttpToHttp2ConnectionHandlerTest.this.requestLatch, null, HttpToHttp2ConnectionHandlerTest.this.trailersLatch);
                p.addLast(new ChannelHandler[]{new HttpToHttp2ConnectionHandlerBuilder().server(true).frameListener((Http2FrameListener)HttpToHttp2ConnectionHandlerTest.this.serverFrameCountDown).httpScheme(HttpScheme.HTTP).build()});
                serverChannelLatch.countDown();
            }
        });
        this.cb.group((EventLoopGroup)new DefaultEventLoopGroup());
        this.cb.channel(LocalChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                HttpToHttp2ConnectionHandler handler = new HttpToHttp2ConnectionHandlerBuilder().server(false).frameListener(HttpToHttp2ConnectionHandlerTest.this.clientListener).gracefulShutdownTimeoutMillis(0L).build();
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
                            prefaceWrittenLatch.countDown();
                            ctx.pipeline().remove((ChannelHandler)this);
                        }
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new LocalAddress("HttpToHttp2ConnectionHandlerTest")).sync().channel();
        ChannelFuture ccf = this.cb.connect(this.serverChannel.localAddress());
        Assertions.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
        Assertions.assertTrue((boolean)prefaceWrittenLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
    }

    private void verifyHeadersOnly(Http2Headers expected, ChannelPromise writePromise, ChannelFuture writeFuture) throws Exception {
        Assertions.assertTrue((boolean)writePromise.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)writePromise.isSuccess());
        Assertions.assertTrue((boolean)writeFuture.awaitUninterruptibly(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)writeFuture.isSuccess());
        this.awaitRequests();
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)5), (Http2Headers)Mockito.eq((Object)expected), Mockito.eq((int)0), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.eq((int)0), Mockito.eq((boolean)true));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
    }

    private void awaitRequests() throws Exception {
        Assertions.assertTrue((boolean)this.requestLatch.await(5L, TimeUnit.SECONDS));
        if (this.trailersLatch != null) {
            Assertions.assertTrue((boolean)this.trailersLatch.await(5L, TimeUnit.SECONDS));
        }
        Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(5L, TimeUnit.SECONDS));
    }

    private ChannelHandlerContext ctx() {
        return this.clientChannel.pipeline().firstContext();
    }

    private ChannelPromise newPromise() {
        return this.ctx().newPromise();
    }
}

