/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5CommonTestUtils;
import io.netty.handler.codec.socksx.v5.Socks5Message;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthResponseDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Socks5PasswordAuthResponseDecoderTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Socks5PasswordAuthResponseDecoderTest.class);

    private static void test(Socks5PasswordAuthStatus status) {
        logger.debug("Testing Socks5PasswordAuthResponseDecoder with status: " + status);
        DefaultSocks5PasswordAuthResponse msg = new DefaultSocks5PasswordAuthResponse(status);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new Socks5PasswordAuthResponseDecoder()});
        Socks5CommonTestUtils.writeFromServerToClient(embedder, (Socks5Message)msg);
        msg = (Socks5PasswordAuthResponse)embedder.readInbound();
        Assertions.assertSame((Object)msg.status(), (Object)status);
        Assertions.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testSocksCmdResponseDecoder() {
        Socks5PasswordAuthResponseDecoderTest.test(Socks5PasswordAuthStatus.SUCCESS);
        Socks5PasswordAuthResponseDecoderTest.test(Socks5PasswordAuthStatus.FAILURE);
    }
}

