/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.pcap;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.pcap.PcapWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Promise;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PcapWriteHandlerTest {
    @Test
    public void udpV4() throws InterruptedException {
        ByteBuf byteBuf = Unpooled.buffer();
        InetSocketAddress srvReqAddr = new InetSocketAddress("127.0.0.1", 0);
        InetSocketAddress cltReqAddr = new InetSocketAddress("127.0.0.1", 0);
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(2);
        Bootstrap server = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) {
            }
        });
        ChannelFuture channelFutureServer = server.bind((SocketAddress)srvReqAddr).sync();
        Assertions.assertTrue((boolean)channelFutureServer.isSuccess());
        Bootstrap client = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new PcapWriteHandler((OutputStream)new ByteBufOutputStream(byteBuf)));
        ChannelFuture channelFutureClient = client.connect(channelFutureServer.channel().localAddress(), (SocketAddress)cltReqAddr).sync();
        Assertions.assertTrue((boolean)channelFutureClient.isSuccess());
        Channel clientChannel = channelFutureClient.channel();
        Assertions.assertTrue((boolean)clientChannel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"Meow".getBytes())).sync().isSuccess());
        Assertions.assertTrue((boolean)eventLoopGroup.shutdownGracefully().sync().isSuccess());
        PcapWriteHandlerTest.verifyGlobalHeaders(byteBuf);
        byteBuf.readInt();
        byteBuf.readInt();
        Assertions.assertEquals((int)46, (int)byteBuf.readInt());
        Assertions.assertEquals((int)46, (int)byteBuf.readInt());
        ByteBuf ethernetPacket = byteBuf.readBytes(46);
        ByteBuf dstMac = ethernetPacket.readBytes(6);
        ByteBuf srcMac = ethernetPacket.readBytes(6);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, -1}, (byte[])ByteBufUtil.getBytes((ByteBuf)dstMac));
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, 0}, (byte[])ByteBufUtil.getBytes((ByteBuf)srcMac));
        Assertions.assertEquals((int)2048, (int)ethernetPacket.readShort());
        ByteBuf ipv4Packet = ethernetPacket.readBytes(32);
        Assertions.assertEquals((int)69, (int)ipv4Packet.readByte());
        Assertions.assertEquals((int)0, (int)ipv4Packet.readByte());
        Assertions.assertEquals((int)32, (int)ipv4Packet.readShort());
        Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        Assertions.assertEquals((byte)-1, (byte)ipv4Packet.readByte());
        Assertions.assertEquals((byte)17, (byte)ipv4Packet.readByte());
        Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        InetSocketAddress localAddr = (InetSocketAddress)clientChannel.remoteAddress();
        Assertions.assertEquals((int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)localAddr.getAddress())), (int)ipv4Packet.readInt());
        InetSocketAddress remoteAddr = (InetSocketAddress)clientChannel.localAddress();
        Assertions.assertEquals((int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)remoteAddr.getAddress())), (int)ipv4Packet.readInt());
        ByteBuf udpPacket = ipv4Packet.readBytes(12);
        Assertions.assertEquals((int)(remoteAddr.getPort() & 0xFFFF), (int)udpPacket.readUnsignedShort());
        Assertions.assertEquals((int)(localAddr.getPort() & 0xFFFF), (int)udpPacket.readUnsignedShort());
        Assertions.assertEquals((int)12, (int)udpPacket.readShort());
        Assertions.assertEquals((int)1, (int)udpPacket.readShort());
        ByteBuf payload = udpPacket.readBytes(4);
        Assertions.assertArrayEquals((byte[])"Meow".getBytes(CharsetUtil.UTF_8), (byte[])ByteBufUtil.getBytes((ByteBuf)payload));
        Assertions.assertTrue((boolean)dstMac.release());
        Assertions.assertTrue((boolean)srcMac.release());
        Assertions.assertTrue((boolean)payload.release());
        Assertions.assertTrue((boolean)byteBuf.release());
        Assertions.assertTrue((boolean)ethernetPacket.release());
        Assertions.assertTrue((boolean)ipv4Packet.release());
        Assertions.assertTrue((boolean)udpPacket.release());
    }

    @Test
    public void tcpV4() throws InterruptedException, ExecutionException {
        final ByteBuf byteBuf = Unpooled.buffer();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup clientGroup = new NioEventLoopGroup();
        ServerBootstrap sb = new ServerBootstrap();
        final Promise dataReadPromise = bossGroup.next().newPromise();
        ((ServerBootstrap)((ServerBootstrap)sb.group((EventLoopGroup)bossGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new PcapWriteHandler((OutputStream)new ByteBufOutputStream(byteBuf))});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        ctx.write(msg);
                    }

                    public void channelReadComplete(ChannelHandlerContext ctx) {
                        ctx.flush();
                        dataReadPromise.setSuccess((Object)true);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        ctx.close();
                    }
                }});
            }
        });
        ChannelFuture serverChannelFuture = sb.bind((SocketAddress)new InetSocketAddress("127.0.0.1", 0)).sync();
        Assertions.assertTrue((boolean)serverChannelFuture.isSuccess());
        Bootstrap cb = new Bootstrap();
        final Promise dataWrittenPromise = clientGroup.next().newPromise();
        ((Bootstrap)((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)clientGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelActive(ChannelHandlerContext ctx) {
                        ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"Meow".getBytes()));
                        dataWrittenPromise.setSuccess((Object)true);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        ctx.close();
                    }
                }});
            }
        });
        ChannelFuture clientChannelFuture = cb.connect(serverChannelFuture.channel().localAddress()).sync();
        Assertions.assertTrue((boolean)clientChannelFuture.isSuccess());
        Assertions.assertTrue((boolean)dataWrittenPromise.await(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)dataReadPromise.await(5L, TimeUnit.SECONDS));
        clientChannelFuture.channel().close().sync();
        serverChannelFuture.channel().close().sync();
        Assertions.assertTrue((boolean)clientGroup.shutdownGracefully().sync().isSuccess());
        Assertions.assertTrue((boolean)bossGroup.shutdownGracefully().sync().isSuccess());
        PcapWriteHandlerTest.verifyGlobalHeaders(byteBuf);
        byteBuf.readInt();
        byteBuf.readInt();
        Assertions.assertEquals((int)54, (int)byteBuf.readInt());
        Assertions.assertEquals((int)54, (int)byteBuf.readInt());
        ByteBuf ethernetPacket = byteBuf.readSlice(54);
        ByteBuf dstMac = ethernetPacket.readSlice(6);
        ByteBuf srcMac = ethernetPacket.readSlice(6);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, -1}, (byte[])ByteBufUtil.getBytes((ByteBuf)dstMac));
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, 0}, (byte[])ByteBufUtil.getBytes((ByteBuf)srcMac));
        Assertions.assertEquals((int)2048, (int)ethernetPacket.readShort());
        ByteBuf ipv4Packet = ethernetPacket.readSlice(32);
        Assertions.assertEquals((int)69, (int)ipv4Packet.readByte());
        Assertions.assertEquals((int)0, (int)ipv4Packet.readByte());
        Assertions.assertEquals((int)40, (int)ipv4Packet.readShort());
        Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        Assertions.assertEquals((byte)-1, (byte)ipv4Packet.readByte());
        Assertions.assertEquals((byte)6, (byte)ipv4Packet.readByte());
        Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        InetSocketAddress serverAddr = (InetSocketAddress)serverChannelFuture.channel().localAddress();
        Assertions.assertEquals((int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)serverAddr.getAddress())), (int)ipv4Packet.readInt());
        ipv4Packet.readInt();
        InetSocketAddress clientAddr = (InetSocketAddress)clientChannelFuture.channel().localAddress();
        ByteBuf tcpPacket = ipv4Packet.readSlice(12);
        Assertions.assertEquals((int)(clientAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        Assertions.assertEquals((int)(serverAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
    }

    private static void verifyGlobalHeaders(ByteBuf byteBuf) {
        Assertions.assertEquals((int)-1582119980, (int)byteBuf.readInt());
        Assertions.assertEquals((int)2, (int)byteBuf.readShort());
        Assertions.assertEquals((int)4, (int)byteBuf.readShort());
        Assertions.assertEquals((int)0, (int)byteBuf.readInt());
        Assertions.assertEquals((int)0, (int)byteBuf.readInt());
        Assertions.assertEquals((int)65535, (int)byteBuf.readInt());
        Assertions.assertEquals((int)1, (int)byteBuf.readInt());
    }
}

