/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.DomainNameMapping;
import io.netty.util.DomainNameMappingBuilder;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class DomainNameMappingTest {
    @Test
    public void testNullDefaultValueInDeprecatedApi() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DomainNameMapping(null);
            }
        });
    }

    @Test
    public void testNullDomainNamePatternsAreForbiddenInDeprecatedApi() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DomainNameMapping((Object)"NotFound").add(null, (Object)"Some value");
            }
        });
    }

    @Test
    public void testNullValuesAreForbiddenInDeprecatedApi() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DomainNameMapping((Object)"NotFound").add("Some key", null);
            }
        });
    }

    @Test
    public void testDefaultValueInDeprecatedApi() {
        DomainNameMapping mapping = new DomainNameMapping((Object)"NotFound");
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map("not-existing"));
        mapping.add("*.netty.io", (Object)"Netty");
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map("not-existing"));
    }

    @Test
    public void testStrictEqualityInDeprecatedApi() {
        DomainNameMapping mapping = new DomainNameMapping((Object)"NotFound").add("netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads");
        Assertions.assertEquals((Object)"Netty", (Object)mapping.map("netty.io"));
        Assertions.assertEquals((Object)"Netty-Downloads", (Object)mapping.map("downloads.netty.io"));
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map("x.y.z.netty.io"));
    }

    @Test
    public void testWildcardMatchesAnyPrefixInDeprecatedApi() {
        DomainNameMapping mapping = new DomainNameMapping((Object)"NotFound").add("*.netty.io", (Object)"Netty");
        Assertions.assertEquals((Object)"Netty", (Object)mapping.map("netty.io"));
        Assertions.assertEquals((Object)"Netty", (Object)mapping.map("downloads.netty.io"));
        Assertions.assertEquals((Object)"Netty", (Object)mapping.map("x.y.z.netty.io"));
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map("netty.io.x"));
    }

    @Test
    public void testFirstMatchWinsInDeprecatedApi() {
        Assertions.assertEquals((Object)"Netty", (Object)new DomainNameMapping((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").map("downloads.netty.io"));
        Assertions.assertEquals((Object)"Netty-Downloads", (Object)new DomainNameMapping((Object)"NotFound").add("downloads.netty.io", (Object)"Netty-Downloads").add("*.netty.io", (Object)"Netty").map("downloads.netty.io"));
    }

    @Test
    public void testToStringInDeprecatedApi() {
        DomainNameMapping mapping = new DomainNameMapping((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads");
        Assertions.assertEquals((Object)"DomainNameMapping(default: NotFound, map: {*.netty.io=Netty, downloads.netty.io=Netty-Downloads})", (Object)mapping.toString());
    }

    @Test
    public void testNullDefaultValue() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DomainNameMappingBuilder(null);
            }
        });
    }

    @Test
    public void testNullDomainNamePatternsAreForbidden() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DomainNameMappingBuilder((Object)"NotFound").add(null, (Object)"Some value");
            }
        });
    }

    @Test
    public void testNullValuesAreForbidden() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DomainNameMappingBuilder((Object)"NotFound").add("Some key", null);
            }
        });
    }

    @Test
    public void testDefaultValue() {
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").build();
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map("not-existing"));
    }

    @Test
    public void testStrictEquality() {
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)"NotFound").add("netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").build();
        Assertions.assertEquals((Object)"Netty", (Object)mapping.map("netty.io"));
        Assertions.assertEquals((Object)"Netty-Downloads", (Object)mapping.map("downloads.netty.io"));
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map("x.y.z.netty.io"));
    }

    @Test
    public void testWildcardMatchesAnyPrefix() {
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").build();
        Assertions.assertEquals((Object)"Netty", (Object)mapping.map("netty.io"));
        Assertions.assertEquals((Object)"Netty", (Object)mapping.map("downloads.netty.io"));
        Assertions.assertEquals((Object)"Netty", (Object)mapping.map("x.y.z.netty.io"));
        Assertions.assertEquals((Object)"NotFound", (Object)mapping.map("netty.io.x"));
    }

    @Test
    public void testFirstMatchWins() {
        Assertions.assertEquals((Object)"Netty", (Object)new DomainNameMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").build().map("downloads.netty.io"));
        Assertions.assertEquals((Object)"Netty-Downloads", (Object)new DomainNameMappingBuilder((Object)"NotFound").add("downloads.netty.io", (Object)"Netty-Downloads").add("*.netty.io", (Object)"Netty").build().map("downloads.netty.io"));
    }

    @Test
    public void testToString() {
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Download").build();
        Assertions.assertEquals((Object)"ImmutableDomainNameMapping(default: NotFound, map: {*.netty.io=Netty, downloads.netty.io=Netty-Download})", (Object)mapping.toString());
    }

    @Test
    public void testAsMap() {
        DomainNameMapping mapping = new DomainNameMapping((Object)"NotFound").add("netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads");
        Map entries = mapping.asMap();
        Assertions.assertEquals((int)2, (int)entries.size());
        Assertions.assertEquals((Object)"Netty", entries.get("netty.io"));
        Assertions.assertEquals((Object)"Netty-Downloads", entries.get("downloads.netty.io"));
    }

    @Test
    public void testAsMapWithImmutableDomainNameMapping() {
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)"NotFound").add("netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").build();
        Map entries = mapping.asMap();
        Assertions.assertEquals((int)2, (int)entries.size());
        Assertions.assertEquals((Object)"Netty", entries.get("netty.io"));
        Assertions.assertEquals((Object)"Netty-Downloads", entries.get("downloads.netty.io"));
    }
}

