/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.concurrent.ThreadProperties;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;

public class SingleThreadEventExecutorTest {
    @Test
    public void testWrappedExecutorIsShutdown() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final SingleThreadEventExecutor executor = new SingleThreadEventExecutor(null, executorService, false){

            protected void run() {
                while (!this.confirmShutdown()) {
                    Runnable task = this.takeTask();
                    if (task == null) continue;
                    task.run();
                }
            }
        };
        executorService.shutdownNow();
        SingleThreadEventExecutorTest.executeShouldFail((Executor)executor);
        SingleThreadEventExecutorTest.executeShouldFail((Executor)executor);
        Assertions.assertThrows(RejectedExecutionException.class, (Executable)new Executable(){

            public void execute() {
                executor.shutdownGracefully().syncUninterruptibly();
            }
        });
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    private static void executeShouldFail(final Executor executor) {
        Assertions.assertThrows(RejectedExecutionException.class, (Executable)new Executable(){

            public void execute() {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
        });
    }

    @Test
    public void testThreadProperties() {
        final AtomicReference threadRef = new AtomicReference();
        SingleThreadEventExecutor executor = new SingleThreadEventExecutor(null, (ThreadFactory)new DefaultThreadFactory("test"), false){

            protected void run() {
                threadRef.set(Thread.currentThread());
                while (!this.confirmShutdown()) {
                    Runnable task = this.takeTask();
                    if (task == null) continue;
                    task.run();
                }
            }
        };
        ThreadProperties threadProperties = executor.threadProperties();
        Thread thread = (Thread)threadRef.get();
        Assertions.assertEquals((long)thread.getId(), (long)threadProperties.id());
        Assertions.assertEquals((Object)thread.getName(), (Object)threadProperties.name());
        Assertions.assertEquals((int)thread.getPriority(), (int)threadProperties.priority());
        Assertions.assertEquals((Object)thread.isAlive(), (Object)threadProperties.isAlive());
        Assertions.assertEquals((Object)thread.isDaemon(), (Object)threadProperties.isDaemon());
        Assertions.assertTrue((threadProperties.stackTrace().length > 0 ? 1 : 0) != 0);
        executor.shutdownGracefully();
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testInvokeAnyInEventLoop() {
        SingleThreadEventExecutorTest.testInvokeInEventLoop(true, false);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testInvokeAnyInEventLoopWithTimeout() {
        SingleThreadEventExecutorTest.testInvokeInEventLoop(true, true);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testInvokeAllInEventLoop() {
        SingleThreadEventExecutorTest.testInvokeInEventLoop(false, false);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testInvokeAllInEventLoopWithTimeout() {
        SingleThreadEventExecutorTest.testInvokeInEventLoop(false, true);
    }

    private static void testInvokeInEventLoop(final boolean any, final boolean timeout) {
        final SingleThreadEventExecutor executor = new SingleThreadEventExecutor(null, Executors.defaultThreadFactory(), true){

            protected void run() {
                while (!this.confirmShutdown()) {
                    Runnable task = this.takeTask();
                    if (task == null) continue;
                    task.run();
                }
            }
        };
        try {
            Assertions.assertThrows(RejectedExecutionException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    final Promise promise = executor.newPromise();
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Set<1> set = Collections.singleton(new Callable<Boolean>(){

                                    @Override
                                    public Boolean call() throws Exception {
                                        promise.setFailure((Throwable)((Object)new AssertionError((Object)"Should never execute the Callable")));
                                        return Boolean.TRUE;
                                    }
                                });
                                if (any) {
                                    if (timeout) {
                                        executor.invokeAny(set, 10L, TimeUnit.SECONDS);
                                    } else {
                                        executor.invokeAny(set);
                                    }
                                } else if (timeout) {
                                    executor.invokeAll(set, 10L, TimeUnit.SECONDS);
                                } else {
                                    executor.invokeAll(set);
                                }
                                promise.setFailure((Throwable)((Object)new AssertionError((Object)"Should never reach here")));
                            }
                            catch (Throwable cause) {
                                promise.setFailure(cause);
                            }
                        }
                    });
                    promise.syncUninterruptibly();
                }
            });
        }
        finally {
            executor.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
    }

    @Test
    public void testLazyExecution() throws Exception {
        SingleThreadEventExecutor executor = new SingleThreadEventExecutor(null, Executors.defaultThreadFactory(), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void run() {
                while (!this.confirmShutdown()) {
                    try {
                        7 var1_1 = this;
                        synchronized (var1_1) {
                            if (!this.hasTasks()) {
                                ((Object)((Object)this)).wait();
                            }
                        }
                        this.runAllTasks();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assertions.fail((String)e.toString());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void wakeup(boolean inEventLoop) {
                if (!inEventLoop) {
                    7 var2_2 = this;
                    synchronized (var2_2) {
                        ((Object)((Object)this)).notifyAll();
                    }
                }
            }
        };
        LatchTask latch0 = new LatchTask();
        executor.execute((Runnable)latch0);
        Assertions.assertTrue((boolean)latch0.await(100L, TimeUnit.MILLISECONDS));
        Thread.sleep(100L);
        LatchTask latch1 = new LatchTask();
        executor.lazyExecute((Runnable)latch1);
        LazyLatchTask latch2 = new LazyLatchTask();
        executor.execute((Runnable)latch2);
        Assertions.assertFalse((boolean)latch1.await(100L, TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)latch2.await(100L, TimeUnit.MILLISECONDS));
        LatchTask latch3 = new LatchTask();
        executor.execute((Runnable)latch3);
        Assertions.assertTrue((boolean)latch3.await(100L, TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)0L, (long)latch1.getCount());
        Assertions.assertEquals((long)0L, (long)latch2.getCount());
    }

    @Test
    public void testTaskAddedAfterShutdownNotAbandoned() throws Exception {
        LinkedBlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>(){

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }
        };
        final Runnable dummyTask = new Runnable(){

            @Override
            public void run() {
            }
        };
        final LinkedBlockingQueue submittedTasks = new LinkedBlockingQueue();
        final AtomicInteger attempts = new AtomicInteger();
        final AtomicInteger rejects = new AtomicInteger();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        SingleThreadEventExecutor executor = new SingleThreadEventExecutor(null, executorService, false, taskQueue, RejectedExecutionHandlers.reject()){

            protected void run() {
                while (!this.confirmShutdown()) {
                    Runnable task = this.takeTask();
                    if (task == null) continue;
                    task.run();
                }
            }

            protected boolean confirmShutdown() {
                boolean result = super.confirmShutdown();
                if (result) {
                    attempts.incrementAndGet();
                    try {
                        submittedTasks.add(this.submit(dummyTask));
                    }
                    catch (RejectedExecutionException e) {
                        rejects.incrementAndGet();
                    }
                }
                return result;
            }
        };
        executor.submit(dummyTask).sync();
        executor.shutdownGracefully(0L, 100L, TimeUnit.MILLISECONDS).sync();
        Assertions.assertEquals((int)0, (int)executor.drainTasks());
        Assertions.assertTrue((boolean)taskQueue.isEmpty());
        Assertions.assertTrue((attempts.get() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)attempts.get(), (int)(submittedTasks.size() + rejects.get()));
        for (Future f : submittedTasks) {
            Assertions.assertTrue((boolean)f.isSuccess());
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testTakeTask() throws Exception {
        SingleThreadEventExecutor executor = new SingleThreadEventExecutor(null, Executors.defaultThreadFactory(), true){

            protected void run() {
                while (!this.confirmShutdown()) {
                    Runnable task = this.takeTask();
                    if (task == null) continue;
                    task.run();
                }
            }
        };
        TestRunnable beforeTask = new TestRunnable();
        executor.execute((Runnable)beforeTask);
        TestRunnable scheduledTask = new TestRunnable();
        ScheduledFuture f = executor.schedule((Runnable)scheduledTask, 1500L, TimeUnit.MILLISECONDS);
        TestRunnable afterTask = new TestRunnable();
        executor.execute((Runnable)afterTask);
        f.sync();
        MatcherAssert.assertThat((Object)beforeTask.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)scheduledTask.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)afterTask.ran.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testTakeTaskAlwaysHasTask() throws Exception {
        final SingleThreadEventExecutor executor = new SingleThreadEventExecutor(null, Executors.defaultThreadFactory(), true){

            protected void run() {
                while (!this.confirmShutdown()) {
                    Runnable task = this.takeTask();
                    if (task == null) continue;
                    task.run();
                }
            }
        };
        TestRunnable t = new TestRunnable();
        final ScheduledFuture f = executor.schedule((Runnable)t, 1500L, TimeUnit.MILLISECONDS);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!f.isDone()) {
                    executor.execute((Runnable)this);
                }
            }
        });
        f.sync();
        MatcherAssert.assertThat((Object)t.ran.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    private static final class TestRunnable
    implements Runnable {
        final AtomicBoolean ran = new AtomicBoolean();

        TestRunnable() {
        }

        @Override
        public void run() {
            this.ran.set(true);
        }
    }

    static class LazyLatchTask
    extends LatchTask
    implements AbstractEventExecutor.LazyRunnable {
        LazyLatchTask() {
        }
    }

    static class LatchTask
    extends CountDownLatch
    implements Runnable {
        LatchTask() {
            super(1);
        }

        @Override
        public void run() {
            this.countDown();
        }
    }
}

