/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent0;
import java.nio.ByteBuffer;
import java.security.Permission;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class PlatformDependent0Test {
    @BeforeAll
    public static void assumeUnsafe() {
        Assumptions.assumeTrue((boolean)PlatformDependent0.hasUnsafe());
        Assumptions.assumeTrue((boolean)PlatformDependent0.hasDirectBufferNoCleanerConstructor());
    }

    @Test
    public void testNewDirectBufferNegativeMemoryAddress() {
        PlatformDependent0Test.testNewDirectBufferMemoryAddress(-1L);
    }

    @Test
    public void testNewDirectBufferNonNegativeMemoryAddress() {
        PlatformDependent0Test.testNewDirectBufferMemoryAddress(10L);
    }

    @Test
    public void testNewDirectBufferZeroMemoryAddress() {
        PlatformDependent0.newDirectBuffer((long)0L, (int)10);
    }

    private static void testNewDirectBufferMemoryAddress(long address) {
        Assumptions.assumeTrue((boolean)PlatformDependent0.hasDirectBufferNoCleanerConstructor());
        int capacity = 10;
        ByteBuffer buffer = PlatformDependent0.newDirectBuffer((long)address, (int)capacity);
        Assertions.assertEquals((long)address, (long)PlatformDependent0.directBufferAddress((ByteBuffer)buffer));
        Assertions.assertEquals((int)capacity, (int)buffer.capacity());
    }

    @Test
    public void testMajorVersionFromJavaSpecificationVersion() {
        SecurityManager current = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPropertyAccess(String key) {
                    if (key.equals("java.specification.version")) {
                        throw new SecurityException(key);
                    }
                }

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            Assertions.assertEquals((int)6, (int)PlatformDependent0.majorVersionFromJavaSpecificationVersion());
        }
        finally {
            System.setSecurityManager(current);
        }
    }

    @Test
    public void testMajorVersion() {
        Assertions.assertEquals((int)6, (int)PlatformDependent0.majorVersion((String)"1.6"));
        Assertions.assertEquals((int)7, (int)PlatformDependent0.majorVersion((String)"1.7"));
        Assertions.assertEquals((int)8, (int)PlatformDependent0.majorVersion((String)"1.8"));
        Assertions.assertEquals((int)8, (int)PlatformDependent0.majorVersion((String)"8"));
        Assertions.assertEquals((int)9, (int)PlatformDependent0.majorVersion((String)"1.9"));
        Assertions.assertEquals((int)9, (int)PlatformDependent0.majorVersion((String)"9"));
    }
}

