/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import org.apache.arrow.memory.Accountant;
import org.apache.arrow.memory.AllocationOutcome;
import org.junit.Assert;
import org.junit.Test;

public class TestAccountant {
    @Test
    public void basic() {
        this.ensureAccurateReservations(null);
    }

    @Test
    public void nested() {
        Accountant parent = new Accountant(null, "test", 0L, Long.MAX_VALUE);
        this.ensureAccurateReservations(parent);
        Assert.assertEquals((long)0L, (long)parent.getAllocatedMemory());
        Assert.assertEquals((long)(parent.getLimit() - parent.getAllocatedMemory()), (long)parent.getHeadroom());
    }

    @Test
    public void multiThread() throws InterruptedException {
        final Accountant parent = new Accountant(null, "test", 0L, Long.MAX_VALUE);
        int numberOfThreads = 32;
        int loops = 100;
        Thread[] threads = new Thread[32];
        for (int i = 0; i < 32; ++i) {
            Thread t;
            threads[i] = t = new Thread(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 100; ++i) {
                            TestAccountant.this.ensureAccurateReservations(parent);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Assert.fail((String)ex.getMessage());
                    }
                }
            };
            t.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Assert.assertEquals((long)0L, (long)parent.getAllocatedMemory());
        Assert.assertEquals((long)(parent.getLimit() - parent.getAllocatedMemory()), (long)parent.getHeadroom());
    }

    private void ensureAccurateReservations(Accountant outsideParent) {
        Accountant parent = new Accountant(outsideParent, "test", 0L, 10L);
        Assert.assertEquals((long)0L, (long)parent.getAllocatedMemory());
        Accountant child = new Accountant(parent, "test", 2L, Long.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)parent.getAllocatedMemory());
        Assert.assertEquals((long)10L, (long)child.getHeadroom());
        AllocationOutcome first = child.allocateBytes(1L);
        Assert.assertEquals((Object)AllocationOutcome.Status.SUCCESS, (Object)first.getStatus());
        Assert.assertEquals((long)1L, (long)child.getAllocatedMemory());
        Assert.assertEquals((long)2L, (long)parent.getAllocatedMemory());
        first = child.allocateBytes(1L);
        Assert.assertEquals((Object)AllocationOutcome.Status.SUCCESS, (Object)first.getStatus());
        Assert.assertEquals((long)2L, (long)child.getAllocatedMemory());
        Assert.assertEquals((long)2L, (long)parent.getAllocatedMemory());
        child.releaseBytes(1L);
        Assert.assertEquals((long)1L, (long)child.getAllocatedMemory());
        Assert.assertEquals((long)2L, (long)parent.getAllocatedMemory());
        first = child.allocateBytes(2L);
        Assert.assertEquals((Object)AllocationOutcome.Status.SUCCESS, (Object)first.getStatus());
        Assert.assertEquals((long)3L, (long)child.getAllocatedMemory());
        Assert.assertEquals((long)3L, (long)parent.getAllocatedMemory());
        Assert.assertEquals((long)7L, (long)child.getHeadroom());
        Assert.assertEquals((long)7L, (long)parent.getHeadroom());
        first = child.allocateBytes(7L);
        Assert.assertEquals((Object)AllocationOutcome.Status.SUCCESS, (Object)first.getStatus());
        Assert.assertEquals((long)10L, (long)child.getAllocatedMemory());
        Assert.assertEquals((long)10L, (long)parent.getAllocatedMemory());
        child.releaseBytes(9L);
        Assert.assertEquals((long)1L, (long)child.getAllocatedMemory());
        Assert.assertEquals((long)9L, (long)child.getHeadroom());
        Assert.assertEquals((long)2L, (long)parent.getAllocatedMemory());
        Assert.assertEquals((long)8L, (long)parent.getHeadroom());
        first = child.allocateBytes(10L);
        Assert.assertEquals((Object)AllocationOutcome.Status.FAILED_PARENT, (Object)first.getStatus());
        Assert.assertEquals((long)1L, (long)child.getAllocatedMemory());
        Assert.assertEquals((long)2L, (long)parent.getAllocatedMemory());
        boolean withinLimit = child.forceAllocate(10L);
        Assert.assertEquals((Object)false, (Object)withinLimit);
        Assert.assertEquals((long)child.getAllocatedMemory(), (long)11L);
        Assert.assertEquals((long)parent.getAllocatedMemory(), (long)11L);
        Assert.assertEquals((long)-1L, (long)child.getHeadroom());
        Assert.assertEquals((long)-1L, (long)parent.getHeadroom());
        child.releaseBytes(11L);
        Assert.assertEquals((long)child.getAllocatedMemory(), (long)0L);
        Assert.assertEquals((long)parent.getAllocatedMemory(), (long)2L);
        Assert.assertEquals((long)10L, (long)child.getHeadroom());
        Assert.assertEquals((long)8L, (long)parent.getHeadroom());
        child.close();
        parent.close();
    }
}

