/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.RootAllocator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestArrowBuf {
    private static final int MAX_ALLOCATION = 8192;
    private static RootAllocator allocator;

    @BeforeClass
    public static void beforeClass() {
        allocator = new RootAllocator(8192L);
    }

    @AfterClass
    public static void afterClass() {
        if (allocator != null) {
            allocator.close();
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceOutOfBoundsLength_RaisesIndexOutOfBoundsException() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(2L);){
            Assert.assertEquals((long)2L, (long)buf.capacity());
            buf.slice(0L, 3L);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceOutOfBoundsIndexPlusLength_RaisesIndexOutOfBoundsException() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(2L);){
            Assert.assertEquals((long)2L, (long)buf.capacity());
            buf.slice(1L, 2L);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceOutOfBoundsIndex_RaisesIndexOutOfBoundsException() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(2L);){
            Assert.assertEquals((long)2L, (long)buf.capacity());
            buf.slice(3L, 0L);
        }
    }

    @Test
    public void testSliceWithinBoundsLength_ReturnsSlice() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(2L);){
            Assert.assertEquals((long)2L, (long)buf.capacity());
            Assert.assertEquals((long)1L, (long)buf.slice(1L, 1L).capacity());
            Assert.assertEquals((long)2L, (long)buf.slice(0L, 2L).capacity());
        }
    }

    @Test
    public void testSetBytesSliced() {
        int arrLength = 64;
        byte[] expected = new byte[arrLength];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = (byte)i;
        }
        ByteBuffer data = ByteBuffer.wrap(expected);
        try (ArrowBuf buf = allocator.buffer((long)expected.length);){
            buf.setBytes(0L, data, 0, data.capacity());
            byte[] actual = new byte[expected.length];
            buf.getBytes(0L, actual);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testSetBytesUnsliced() {
        int arrLength = 64;
        byte[] arr = new byte[arrLength];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)i;
        }
        ByteBuffer data = ByteBuffer.wrap(arr);
        int from = 10;
        int to = arrLength;
        byte[] expected = Arrays.copyOfRange(arr, from, to);
        try (ArrowBuf buf = allocator.buffer((long)expected.length);){
            buf.setBytes(0L, data, from, to - from);
            byte[] actual = new byte[expected.length];
            buf.getBytes(0L, actual);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testSetBytesBigEndian() {
        byte[] expected = new byte[64];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = (byte)i;
        }
        ByteBuffer data = ByteBuffer.wrap(expected).asReadOnlyBuffer();
        Assert.assertFalse((boolean)data.hasArray());
        Assert.assertFalse((boolean)data.isDirect());
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)data.order());
        try (ArrowBuf buf = allocator.buffer((long)expected.length);){
            buf.setBytes(0L, data);
            byte[] actual = new byte[expected.length];
            buf.getBytes(0L, actual);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }
}

